/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.shmjs.inventoryselect.form;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.pa.shmjs.distribution.form.DistributionBillPlugin;
import yem.wm.pa.shmjs.utils.GetFieldMappingUtils;
import yem.wm.pa.shmjs.utils.MatchInventoryUtils;

public class InventoryselectFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.formHeadInitialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        AbstractGrid grid = (AbstractGrid)this.getControl("yem_pa_cxpp_kykc");
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel model = view.getModel();
        switch (e.getProperty().getName()) {
            case "yem_orgs": 
            case "yem_departments": 
            case "yem_materiels": 
            case "yem_units": {
                this.formBodyInitialize(model, parentView.getModel());
                break;
            }
            case "yem_check": {
                this.addDelYxkcBodyEntry(e, model);
                break;
            }
            case "yem_qtyx": {
                this.QuantityModifyValidator(e, view);
            }
        }
        this.getView().updateView();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        String operateKey = ((AbstractOperate)args.getSource()).getOperateKey();
        IFormView view = this.getView();
        switch (operateKey) {
            case "confirm": {
                this.availableInventoryVerify(args, view);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        IDataModel model = view.getModel();
        switch (afterDoOperationEventArgs.getOperateKey()) {
            case "yxkc_qxxz": {
                this.formBodyInitialize(model, parentView.getModel());
                break;
            }
            case "confirm": {
                this.backfillAvailableInventory(model, parentView);
                view.close();
            }
        }
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        Boolean check = (Boolean)model.getValue("yem_check", evt.getRow());
        model.setValue("yem_check", (Object)(check == false ? 1 : 0), evt.getRow());
    }

    private void addDelYxkcBodyEntry(PropertyChangedArgs e, IDataModel model) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        boolean check = (Boolean)e.getChangeSet()[0].getNewValue();
        DynamicObject kykcRow = model.getEntryRowEntity("yem_pa_cxpp_kykc", rowIndex);
        long kykcId = kykcRow.getLong("yem_procurebillrowid");
        if (check) {
            DynamicObjectCollection yxkcEntry = model.getEntryEntity("yem_pa_cxpp_yxkc");
            if (!yxkcEntry.isEmpty()) {
                List checkList = yxkcEntry.stream().filter(row -> row.getLong("yem_procurebillrowidx") == kykcId).map(arg_0 -> yxkcEntry.indexOf(arg_0)).sorted(Collections.reverseOrder()).collect(Collectors.toList());
                if (!checkList.isEmpty()) {
                    return;
                }
            }
            int yxkcIndex = model.createNewEntryRow("yem_pa_cxpp_yxkc");
            ArrayList<String> noUpFiles = new ArrayList<String>();
            noUpFiles.add("id");
            noUpFiles.add("seq");
            noUpFiles.add("yem_check");
            List<String> kykcFieldList = DistributionBillPlugin.getEntityFieldKeyList(model.getDataEntityType().getName(), "yem_pa_cxpp_kykc", noUpFiles);
            model.beginInit();
            for (String field : kykcFieldList) {
                model.setValue(field + "x", kykcRow.get(field), yxkcIndex);
            }
            model.setValue("yem_initqty", kykcRow.get("yem_qty"), yxkcIndex);
            model.endInit();
        } else {
            if (kykcId == 0L) {
                return;
            }
            DynamicObjectCollection yxkcEntry = model.getEntryEntity("yem_pa_cxpp_yxkc");
            if (yxkcEntry.isEmpty()) {
                return;
            }
            List checkList = yxkcEntry.stream().filter(row -> row.getLong("yem_procurebillrowidx") == kykcId).map(arg_0 -> yxkcEntry.indexOf(arg_0)).sorted(Collections.reverseOrder()).collect(Collectors.toList());
            for (Integer index : checkList) {
                model.deleteEntryRow("yem_pa_cxpp_yxkc", index.intValue());
            }
        }
    }

    private void formHeadInitialize() {
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        IFormView parentView = view.getParentView();
        IDataModel parentmodel = parentView.getModel();
        DynamicObject parentEntity = parentmodel.getDataEntity(true);
        if (Objects.isNull(parentEntity) || "ide_formdesigner".equals(parentView.getEntityId())) {
            view.setEnable(Boolean.valueOf(false), new String[]{"contentpanel"});
            return;
        }
        String[] fields = GetFieldMappingUtils.INSTANCE.getFieldMapping(parentView.getEntityId());
        if (Arrays.stream(fields).anyMatch(field -> field == null || field.isEmpty())) {
            return;
        }
        DynamicObject org = parentEntity.getDynamicObject(fields[0]);
        DynamicObject bizdept = parentEntity.getDynamicObject(fields[1]);
        model.setValue("yem_orgs", (Object)org);
        model.setValue("yem_departments", (Object)bizdept);
        this.formBodyInitialize(model, parentmodel);
    }

    private void formBodyInitialize(IDataModel model, IDataModel parentmodel) {
        DynamicObject entity = model.getDataEntity(true);
        DynamicObjectCollection kykcEntry = entity.getDynamicObjectCollection("yem_pa_cxpp_kykc");
        kykcEntry.clear();
        DynamicObject org = entity.getDynamicObject("yem_orgs");
        DynamicObject department = entity.getDynamicObject("yem_departments");
        DynamicObject materiel = entity.getDynamicObject("yem_materiels");
        DynamicObject unit = entity.getDynamicObject("yem_units");
        HashMap<String, Object> fbasedataid = new HashMap<String, Object>();
        if (YEM.isNotEmpty((Object)org)) {
            fbasedataid.put("yem_org", org);
        }
        if (YEM.isNotEmpty((Object)department)) {
            fbasedataid.put("yem_department", department);
        }
        if (YEM.isNotEmpty((Object)materiel)) {
            fbasedataid.put("yem_materiel", materiel.getLong("id"));
        }
        if (YEM.isNotEmpty((Object)unit)) {
            fbasedataid.put("yem_unit", unit);
        }
        Map<String, List<Map<String, Object>>> stringListMap = MatchInventoryUtils.queryUsableInventory(fbasedataid, "", null);
        List<Map<String, Object>> list = stringListMap.get("3");
        list = InventoryselectFormPlugin.filterData(model, parentmodel, list);
        InventoryselectFormPlugin.kykcEntryBuild(model, entity, list);
    }

    private static List<Map<String, Object>> filterData(IDataModel model, IDataModel parentmodel, List<Map<String, Object>> list) {
        DynamicObjectCollection yxkcEntry = model.getEntryEntity("yem_pa_cxpp_yxkc");
        DynamicObjectCollection billentry = parentmodel.getEntryEntity("billentry");
        Map<Long, BigDecimal> yxkcId = new HashMap<Long, BigDecimal>();
        if (!yxkcEntry.isEmpty()) {
            yxkcId = yxkcEntry.stream().map(row -> new AbstractMap.SimpleEntry<Long, BigDecimal>(row.getLong("yem_procurebillrowidx"), row.getBigDecimal("yem_qtyx"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BigDecimal::add));
        }
        if (!billentry.isEmpty()) {
            yxkcId.putAll(billentry.stream().map(row -> new AbstractMap.SimpleEntry<Long, BigDecimal>(row.getLong("yem_procurebillrowid"), row.getBigDecimal("qty"))).filter(map -> (Long)map.getKey() != 0L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, BigDecimal::add)));
        }
        HashMap<Long, BigDecimal> yxkcIdMap = yxkcId;
        if (!yxkcId.isEmpty()) {
            list = list.stream().filter(rowMap -> {
                if (yxkcIdMap.containsKey((long)((Long)rowMap.get("entryid"))) && ((BigDecimal)yxkcIdMap.get((long)((Long)rowMap.get("entryid")))).compareTo((BigDecimal)rowMap.get("yem_qty")) < 0) {
                    return true;
                }
                return !yxkcIdMap.containsKey((long)((Long)rowMap.get("entryid")));
            }).peek(rowMap -> {
                BigDecimal oldQty = yxkcIdMap.getOrDefault((long)((Long)rowMap.get("entryid")), BigDecimal.ZERO);
                rowMap.put("yem_qty", ((BigDecimal)rowMap.get("yem_qty")).subtract(oldQty));
            }).collect(Collectors.toList());
        }
        return list;
    }

    private static void kykcEntryBuild(IDataModel model, DynamicObject entity, List<Map<String, Object>> list) {
        ArrayList<String> noUpFiles = new ArrayList<String>();
        noUpFiles.add("id");
        noUpFiles.add("seq");
        List<String> entrFieldList = DistributionBillPlugin.getEntityFieldKeyList(entity.getDataEntityType().getName(), "yem_pa_cxpp_kykc", noUpFiles);
        for (Map<String, Object> map : list) {
            int rowSeq = model.createNewEntryRow("yem_pa_cxpp_kykc");
            Iterator<String> iterator = entrFieldList.iterator();
            block14: while (iterator.hasNext()) {
                String fireld;
                switch (fireld = iterator.next()) {
                    case "yem_procurebillno": {
                        model.setValue(fireld, map.get("yem_billno"), rowSeq);
                        continue block14;
                    }
                    case "yem_procurebillid": {
                        model.setValue(fireld, map.get("id"), rowSeq);
                        continue block14;
                    }
                    case "yem_procurebillrowid": {
                        model.setValue(fireld, map.get("entryid"), rowSeq);
                        continue block14;
                    }
                    case "yem_procurebill": 
                    case "yem_businessnode": {
                        DynamicObject inventorynode;
                        DynamicObject billconfig = map.get("billconfig") instanceof DynamicObject ? (DynamicObject)map.get("billconfig") : null;
                        if (YEM.isEmpty((Object)billconfig) || YEM.isEmpty((Object)(inventorynode = billconfig.getDynamicObject("yem_inventorynode")))) continue block14;
                        model.setValue("yem_businessnode", (Object)inventorynode, rowSeq);
                        model.setValue("yem_procurebill", (Object)billconfig, rowSeq);
                        continue block14;
                    }
                }
                if (!map.containsKey(fireld)) continue;
                model.setValue(fireld, map.get(fireld), rowSeq);
            }
        }
    }

    private void availableInventoryVerify(BeforeDoOperationEventArgs args, IFormView view) {
        IDataModel model = view.getModel();
        DynamicObjectCollection yxkcEntry = model.getEntryEntity("yem_pa_cxpp_yxkc");
        ArrayList<Integer> errIndex = new ArrayList<Integer>();
        for (DynamicObject yxkcRow : yxkcEntry) {
            DynamicObject procurebill = yxkcRow.getDynamicObject("yem_procurebillx");
            if (YEM.isEmpty((Object)procurebill)) {
                errIndex.add(yxkcEntry.indexOf((Object)yxkcRow));
                continue;
            }
            String billkey = procurebill.getString("number");
            long billId = yxkcRow.getLong("yem_procurebillidx");
            long billEntryId = yxkcRow.getLong("yem_procurebillrowidx");
            BigDecimal matchQty = yxkcRow.getBigDecimal("yem_qtyx");
            Boolean result = MatchInventoryUtils.isAvailableInventory(billkey, billId, billEntryId, matchQty);
            if (result.booleanValue()) continue;
            errIndex.add(yxkcEntry.indexOf((Object)yxkcRow));
        }
        if (!errIndex.isEmpty()) {
            String errSeqInfo = errIndex.stream().map(num -> String.valueOf(num + 1)).collect(Collectors.joining("\u3001"));
            view.showErrorNotification(String.format("\u5df2\u9009\u5206\u5f55\u7b2c%s\u884c\u5e93\u5b58\u4e3a\u4e0d\u53ef\u7528\u5e93\u5b58\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\uff01", errSeqInfo));
            EntryGrid yxkcGrid = (EntryGrid)view.getControl("yem_pa_cxpp_yxkc");
            int[] errArr = errIndex.stream().mapToInt(Integer::intValue).toArray();
            yxkcGrid.selectRows(errArr, errArr[0]);
            args.setCancel(true);
        }
    }

    private void QuantityModifyValidator(PropertyChangedArgs e, IFormView view) {
        IDataModel model = view.getModel();
        BigDecimal newQty = (BigDecimal)e.getChangeSet()[0].getNewValue();
        BigDecimal oldQty = (BigDecimal)e.getChangeSet()[0].getOldValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        if (newQty.compareTo(BigDecimal.ZERO) < 0) {
            model.setValue("yem_qtyx", (Object)oldQty, rowIndex);
            view.showTipNotification("\u5df2\u9009\u5e93\u5b58\u6570\u91cf\u4e0d\u5141\u8bb8\u5c0f\u4e8e0");
            return;
        }
        BigDecimal initqty = (BigDecimal)model.getValue("yem_initqty", rowIndex);
        if (newQty.compareTo(initqty) > 0) {
            model.setValue("yem_qtyx", (Object)oldQty, rowIndex);
            view.showTipNotification(String.format("\u5df2\u8d85\u51fa\u3010\u53ef\u7528\u5e93\u5b58\u6570\u91cf\u3011 %s\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u8bd5", initqty));
        }
    }

    private void backfillAvailableInventory(IDataModel model, IFormView parentView) {
        DynamicObjectCollection yxkcEntry = model.getEntryEntity("yem_pa_cxpp_yxkc");
        IDataModel parentModel = parentView.getModel();
        DynamicObject parentEntity = parentModel.getDataEntity(true);
        if (Objects.isNull(parentEntity) || "ide_formdesigner".equals(parentView.getEntityId())) {
            return;
        }
        for (DynamicObject yxkcRow : yxkcEntry) {
            int rowIndex = parentModel.createNewEntryRow("billentry");
            DynamicObject materielx = yxkcRow.getDynamicObject("yem_materielx");
            materielx = BusinessDataServiceHelper.loadSingle((Object)materielx.getPkValue(), (String)materielx.getDynamicObjectType().getName());
            QFilter filter = new QFilter("masterid", "=", materielx.getPkValue());
            DynamicObject materialinventoryinfo = BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{filter});
            parentModel.setValue("material", (Object)materialinventoryinfo, rowIndex);
            parentModel.setValue("linetype", materielx.get("materialtype"), rowIndex);
            parentModel.setValue("unit", yxkcRow.get("yem_unitx"), rowIndex);
            parentModel.setValue("qty", yxkcRow.get("yem_qtyx"), rowIndex);
            parentModel.setValue("lotnumber", yxkcRow.get("yem_batchnox"), rowIndex);
            if ("im_transdirbill".equals(parentView.getEntityId())) {
                parentModel.setValue("outwarehouse", yxkcRow.get("yem_warehousex"), rowIndex);
            } else {
                parentModel.setValue("warehouse", yxkcRow.get("yem_warehousex"), rowIndex);
            }
            parentModel.setValue("yem_procurebill", yxkcRow.get("yem_procurebillx.number"), rowIndex);
            parentModel.setValue("yem_procurebillid", yxkcRow.get("yem_procurebillidx"), rowIndex);
            parentModel.setValue("yem_procurebillrowid", yxkcRow.get("yem_procurebillrowidx"), rowIndex);
        }
    }
}

