/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.shmjs.purSalmatch.form;

import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.YEM;
import yem.wm.pa.shmjs.utils.MatchInventoryUtils;

public class SalesdeliverBillPlugin
extends AbstractBillPlugIn {
    private static int count = 0;

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        switch (e.getProperty().getName()) {
            case "yem_amttaxbase": 
            case "yem_amtbase": {
                if (model.getEntryEntity("uav6_fwb_match").isEmpty()) {
                    return;
                }
                if (count == 1) {
                    SalesdeliverBillPlugin.BackfillMatchEntry(view);
                    view.updateView();
                    count = 0;
                    break;
                }
                ++count;
            }
        }
    }

    protected static void BackfillMatchEntry(IFormView view) {
        IDataModel model = view.getModel();
        DynamicObject entity = model.getDataEntity(true);
        BigDecimal exrate = entity.getBigDecimal("yem_exrate");
        String stocktype = entity.getString("yem_stocktype");
        String name = view.getEntityId();
        long id = entity.getLong("id");
        DynamicObjectCollection materialEntry = entity.getDynamicObjectCollection("yem_materialentry");
        DynamicObjectCollection matchEntry = entity.getDynamicObjectCollection("uav6_fwb_match");
        matchEntry.clear();
        DynamicObject fromcurr = entity.getDynamicObject("yem_fromcurr");
        long fromcurrid = null != fromcurr ? fromcurr.getLong("id") : 0L;
        Map<String, Integer> precision = SalesdeliverBillPlugin.precision(fromcurrid);
        Integer amtprecision = precision.get("amtprecision");
        for (DynamicObject materialRow : materialEntry) {
            long rowId = materialRow.getLong("id");
            List<DynamicObject> matchRelation = MatchInventoryUtils.queryMatchRelation(false, name, id, rowId);
            if (matchRelation.isEmpty()) continue;
            HashMap<String, Object> rowData = new HashMap<String, Object>();
            rowData.put("yem_material", materialRow.get("yem_material"));
            rowData.put("yem_unit", materialRow.get("yem_unit"));
            rowData.put("uav6_materialtype", materialRow.get("uav6_materialtype"));
            rowData.put("uav6_brand", materialRow.get("uav6_brand"));
            rowData.put("uav6_specification", materialRow.get("uav6_specification"));
            rowData.put("uav6_bundlenum", materialRow.get("uav6_bundlenum"));
            rowData.put("uav6_lotnumber", materialRow.get("uav6_lotnumber"));
            rowData.put("yem_secondunit", materialRow.get("yem_secondunit"));
            rowData.put("yem_secondqty", materialRow.get("yem_secondqty"));
            rowData.put("yem_pricetax", materialRow.get("yem_pricetax"));
            rowData.put("yem_taxrate", materialRow.get("yem_taxrate"));
            rowData.put("yem_taxratevalue", materialRow.get("yem_taxratevalue"));
            rowData.put("uav6_warehousewl", materialRow.get("uav6_warehousewl"));
            rowData.put("yem_cobillkey", materialRow.get("yem_cobillkey"));
            rowData.put("yem_cobillno", materialRow.get("yem_cobillno"));
            rowData.put("yem_cobillid", materialRow.get("yem_cobillid"));
            rowData.put("yem_coentryid", materialRow.get("yem_coentryid"));
            rowData.put("yem_srcbillkey", materialRow.get("yem_srcbillkey"));
            rowData.put("yem_srcbillno", materialRow.get("yem_srcbillno"));
            rowData.put("yem_srcbillid", materialRow.get("yem_srcbillid"));
            rowData.put("yem_srcentryid", materialRow.get("yem_srcentryid"));
            BigDecimal oldQty = materialRow.getBigDecimal("yem_qty");
            BigDecimal oldAmt = materialRow.getBigDecimal("yem_amt");
            BigDecimal oldAmttax = materialRow.getBigDecimal("yem_amttax");
            BigDecimal oldTaxrateamt = materialRow.getBigDecimal("yem_taxrateamt");
            BigDecimal totalQty = BigDecimal.ZERO;
            BigDecimal totalAmttax = BigDecimal.ZERO;
            BigDecimal totalTaxrateamt = BigDecimal.ZERO;
            BigDecimal totalAmt = BigDecimal.ZERO;
            for (DynamicObject matchSingle : matchRelation) {
                BigDecimal tax;
                BigDecimal amt;
                BigDecimal taxAmt;
                DynamicObject matchRow = matchEntry.addNew();
                matchRow.set("uav6_material", rowData.get("yem_material"));
                matchRow.set("uav6_unit", rowData.get("yem_unit"));
                SalesdeliverBillPlugin.attributeAssignment(matchSingle, matchRow);
                matchRow.set("uav6_secondunit", rowData.get("yem_secondunit"));
                matchRow.set("uav6_secondqty", rowData.get("yem_secondqty"));
                matchRow.set("uav6_pricetax", rowData.get("yem_pricetax"));
                matchRow.set("uav6_taxrate", rowData.get("yem_taxrate"));
                matchRow.set("uav6_taxratevalue", rowData.get("yem_taxratevalue"));
                matchRow.set("uav6_qtyc", matchSingle.get("yem_newmatchqty"));
                DynamicObject businessnode = matchSingle.getDynamicObject("yem_businessnode_p");
                String nodeName = businessnode.getString("name");
                String procurebillno = matchSingle.getString("yem_procurebillno");
                if ("\u5408\u540c".equals(nodeName)) {
                    matchRow.set("uav6_mainbillno", (Object)procurebillno);
                    long procurebillid = matchSingle.getLong("yem_procurebillid");
                    DynamicObject contract = BusinessDataServiceHelper.loadSingle((String)"yem_cnb_purcontract", (String)"yem_supplier", (QFilter[])new QFilter("id", "=", (Object)procurebillid).toArray());
                    matchRow.set("uav6_supplier", contract.get("yem_supplier"));
                } else {
                    matchRow.set("uav6_mainbillno", matchSingle.get("yem_mainbillno_p"));
                    matchRow.set("uav6_procurebillno", (Object)procurebillno);
                    String mainbillkeyP = matchSingle.getString("yem_mainbillkey_p");
                    long mainbillidP = matchSingle.getLong("yem_mainbillid_p");
                    DynamicObject contract = BusinessDataServiceHelper.loadSingle((String)mainbillkeyP, (String)"yem_supplier", (QFilter[])new QFilter("id", "=", (Object)mainbillidP).toArray());
                    matchRow.set("uav6_supplier", contract.get("yem_supplier"));
                }
                matchRow.set("uav6_batchno", matchSingle.get("yem_batchno"));
                matchRow.set("uav6_cobillkey", rowData.get("yem_cobillkey"));
                matchRow.set("uav6_cobillno", rowData.get("yem_cobillno"));
                matchRow.set("uav6_cobillid", rowData.get("yem_cobillid"));
                matchRow.set("uav6_coentryid", rowData.get("yem_coentryid"));
                matchRow.set("uav6_srcbillkey", rowData.get("yem_srcbillkey"));
                matchRow.set("uav6_srcbillno", rowData.get("yem_srcbillno"));
                matchRow.set("uav6_srcbillid", rowData.get("yem_srcbillid"));
                matchRow.set("uav6_srcentryid", rowData.get("yem_srcentryid"));
                matchRow.set("uav6_materialentryid", (Object)rowId);
                BigDecimal qty = matchSingle.getBigDecimal("yem_newmatchqty");
                BigDecimal pricetax = (BigDecimal)rowData.get("yem_pricetax");
                BigDecimal taxratevalue = (BigDecimal)rowData.get("yem_taxratevalue");
                BigDecimal realRate = BigDecimalUtils.div((BigDecimal)taxratevalue, (BigDecimal)BigDecimalUtils.one_handred, (int)10).add(BigDecimal.ONE);
                totalQty = totalQty.add(qty);
                if (oldQty.compareTo(totalQty) == 0) {
                    taxAmt = oldAmttax.subtract(totalAmttax);
                    amt = oldAmt.subtract(totalAmt);
                    tax = oldTaxrateamt.subtract(totalTaxrateamt);
                } else {
                    taxAmt = BigDecimalUtils.div((Object)qty.multiply(pricetax), (Object)1, (int)amtprecision);
                    totalAmttax = totalAmttax.add(taxAmt);
                    amt = BigDecimalUtils.div((BigDecimal)taxAmt, (BigDecimal)realRate, (int)amtprecision);
                    totalAmt = totalAmt.add(amt);
                    tax = taxAmt.subtract(amt);
                    totalTaxrateamt = totalTaxrateamt.add(tax);
                }
                matchRow.set("uav6_amttax", (Object)taxAmt);
                matchRow.set("uav6_amttaxbase", (Object)taxAmt.multiply(exrate));
                matchRow.set("uav6_amt", (Object)amt);
                matchRow.set("uav6_amtbase", (Object)amt.multiply(exrate));
                matchRow.set("uav6_taxrateamt", (Object)tax);
                matchRow.set("uav6_taxrateamtbase", (Object)tax.multiply(exrate));
                if (!"A".equals(stocktype)) continue;
                matchRow.set("uav6_materialtypec", materialRow.get("uav6_materialtype"));
                matchRow.set("uav6_brandc", materialRow.get("uav6_brand"));
                matchRow.set("uav6_specificationc", materialRow.get("uav6_specification"));
                matchRow.set("uav6_bundlenumc", materialRow.get("uav6_bundlenum"));
                matchRow.set("uav6_lotnumberc", materialRow.get("uav6_lotnumber"));
            }
        }
        view.invokeOperation("save", YEM.getOptionNoMsg());
        view.updateView();
    }

    private static void attributeAssignment(DynamicObject matchSingle, DynamicObject matchRow) {
        String warehouse;
        String lotnumber;
        String bundlenum;
        String specification;
        String brand;
        DynamicObject procurebillConfig = matchSingle.getDynamicObject("yem_procurebill");
        procurebillConfig = BusinessDataServiceHelper.loadSingle((Object)procurebillConfig.getPkValue(), (String)procurebillConfig.getDynamicObjectType().getName());
        long procurebillid = matchSingle.getLong("yem_procurebillid");
        QFilter filter = new QFilter("id", "=", (Object)procurebillid);
        DynamicObject procurebill = BusinessDataServiceHelper.loadSingle((String)procurebillConfig.getString("number"), (QFilter[])filter.toArray());
        DynamicObjectCollection entry = procurebill.getDynamicObjectCollection(procurebillConfig.getString("yem_matchentry"));
        Optional<DynamicObject> entryRowOptional = entry.stream().filter(row -> row.getLong("id") == matchSingle.getLong("yem_procurebillrowid")).findFirst();
        DynamicObject entryRow = entryRowOptional.get();
        DynamicObjectCollection ppwdEntry = procurebillConfig.getDynamicObjectCollection("yem_pa_cxppdjpz_ppwd");
        Map<String, String> entityfield = ppwdEntry.stream().map(row -> new AbstractMap.SimpleEntry<String, String>(row.getString("yem_matchfieldlib.number"), row.getString("yem_entityfieldid"))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        String materialtype = entityfield.get("uav6_materialtype");
        if (!YEM.isEmpty((Object)materialtype) && materialtype.contains(".")) {
            materialtype = materialtype.substring(materialtype.lastIndexOf(".") + 1);
            matchRow.set("uav6_materialtypec", entryRow.get(materialtype));
        }
        if (!YEM.isEmpty((Object)(brand = entityfield.get("uav6_brand"))) && brand.contains(".")) {
            brand = brand.substring(brand.lastIndexOf(".") + 1);
            matchRow.set("uav6_brandc", entryRow.get(brand));
        }
        if (!YEM.isEmpty((Object)(specification = entityfield.get("uav6_specification"))) && specification.contains(".")) {
            specification = specification.substring(specification.lastIndexOf(".") + 1);
            matchRow.set("uav6_specificationc", entryRow.get(specification));
        }
        if (!YEM.isEmpty((Object)(bundlenum = entityfield.get("uav6_bundlenum"))) && bundlenum.contains(".")) {
            bundlenum = bundlenum.substring(bundlenum.lastIndexOf(".") + 1);
            matchRow.set("uav6_bundlenumc", entryRow.get(bundlenum));
        }
        if (!YEM.isEmpty((Object)(lotnumber = entityfield.get("uav6_lotnumber"))) && lotnumber.contains(".")) {
            lotnumber = lotnumber.substring(lotnumber.lastIndexOf(".") + 1);
            matchRow.set("uav6_lotnumberc", entryRow.get(lotnumber));
        }
        if (!YEM.isEmpty((Object)(warehouse = entityfield.get("yem_warehouse"))) && warehouse.contains(".")) {
            warehouse = warehouse.substring(warehouse.lastIndexOf(".") + 1);
            matchRow.set("uav6_warehousec", entryRow.get(warehouse));
        }
    }

    protected static void DeleteMatchEntry(IFormView view, List<Integer> delRows) {
        if (delRows.isEmpty()) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObjectCollection matchEntry = model.getEntryEntity("uav6_fwb_match");
        for (Integer delRow : delRows) {
            DynamicObject materialRow = model.getEntryRowEntity("yem_materialentry", delRow.intValue());
            long rowId = materialRow.getLong("id");
            int[] matchDelRows = matchEntry.stream().filter(row -> row.getLong("uav6_materialentryid") == rowId).map(arg_0 -> matchEntry.indexOf(arg_0)).mapToInt(Integer::intValue).toArray();
            model.deleteEntryRows("uav6_fwb_match", matchDelRows);
        }
        view.invokeOperation("save", YEM.getOptionNoMsg());
        view.updateView();
    }

    public static Map<String, Integer> precision(Long id) {
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        HashMap<String, Integer> amtMap = new HashMap<String, Integer>();
        amtMap.put("amtprecision", currency.getInt("amtprecision"));
        amtMap.put("priceprecision", currency.getInt("priceprecision"));
        return amtMap;
    }
}

