/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.shmjs.purSalmatch.op;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.DynamicObjectUtil;
import yem.wm.pa.shmjs.purSalmatch.op.validators.InventorySubmitValidatorPlugin;
import yem.wm.pa.shmjs.utils.MatchInventoryUtils;

public class InventoryMatchOpPlugin
extends AbstractOperationServicePlugIn
implements Plugin {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)this.billEntityType.getName(), (boolean)true));
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new InventorySubmitValidatorPlugin());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        switch (e.getOperationKey()) {
            case "submit": {
                this.generateProcurementSalesMatch(e, e.getDataEntities());
                break;
            }
            case "unsubmit": {
                this.deleteProcurementSalesMatch(e.getDataEntities());
            }
        }
    }

    private void generateProcurementSalesMatch(BeforeOperationArgs e, DynamicObject[] dataEntities) {
        String billName = this.billEntityType.getName();
        DynamicObject salesConfig = MatchInventoryUtils.getMatchBillConfig(billName);
        if (Objects.isNull(salesConfig)) {
            return;
        }
        for (DynamicObject entity : dataEntities) {
            ArrayList<DynamicObject> saveMatchRelation = new ArrayList<DynamicObject>();
            DynamicObjectCollection billentry = entity.getDynamicObjectCollection("billentry");
            for (DynamicObject row : billentry) {
                Map<String, Object> purchaseRelationship;
                Map<String, Object> salesRelationship = MatchInventoryUtils.createNodeInfo(salesConfig, entity, row.getLong("id"));
                if (salesRelationship == null) continue;
                String procurebill = row.getString("yem_procurebill");
                long procurebillid = row.getLong("yem_procurebillid");
                long procurebillrowid = row.getLong("yem_procurebillrowid");
                QFilter filter = new QFilter("id", "=", (Object)procurebillid);
                DynamicObject purchaseEntity = BusinessDataServiceHelper.loadSingle((String)procurebill, (QFilter[])filter.toArray());
                DynamicObject purchaseConfig = MatchInventoryUtils.getMatchBillConfig(purchaseEntity.getDataEntityType().getName());
                if (Objects.isNull(purchaseConfig) || (purchaseRelationship = MatchInventoryUtils.createNodeInfo(purchaseConfig, purchaseEntity, procurebillrowid)) == null) continue;
                purchaseRelationship.putAll(salesRelationship);
                DynamicObject xs = MatchInventoryUtils.createMatchRelation(purchaseRelationship, "XS", "\u7528\u6237\u624b\u52a8\u5339\u914d\u3002");
                saveMatchRelation.add(xs);
            }
            OperationResult saveResult = SaveServiceHelper.saveOperate((String)"save", (String)"yem_pa_matchrelation", (DynamicObject[])saveMatchRelation.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            if (saveResult.isSuccess()) continue;
            e.setCancel(true);
            throw new KDBizException("\u4fdd\u5b58\u5339\u914d\u5173\u7cfb\u5931\u8d25!");
        }
    }

    private void deleteProcurementSalesMatch(DynamicObject[] dataEntities) {
        String billName = this.billEntityType.getName();
        for (DynamicObject entity : dataEntities) {
            List matchRelationIdList;
            List<DynamicObject> matchRelation = MatchInventoryUtils.queryMatchRelation(false, billName, entity.getLong("id"), 0L);
            if (matchRelation.isEmpty() || (matchRelationIdList = matchRelation.stream().map(DataEntityBase::getPkValue).collect(Collectors.toList())).isEmpty()) continue;
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"yem_pa_matchrelation"), (Object[])matchRelationIdList.toArray());
        }
    }
}

