/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.shmjs.purchase.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.exception.KDBizException;
import yem.wm.pa.shmjs.utils.MatchInventoryUtils;

public class PurcontractToPurinConvertPlugin
extends AbstractConvertPlugIn {
    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] extendedDataEntities;
        super.afterConvert(e);
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        if (variables.containsKey("zhiyun")) {
            return;
        }
        String billKey = this.getTgtMainType().getName();
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities = e.getTargetExtDataEntitySet().FindByEntityKey(billKey)) {
            DynamicObject entity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection billentry = entity.getDynamicObjectCollection("billentry");
            ArrayList<DynamicObject> deleteRow = new ArrayList<DynamicObject>();
            for (DynamicObject row : billentry) {
                BigDecimal qty;
                String srcbillkey = row.getString("srcbillentity");
                long srcbillid = row.getLong("srcbillid");
                long srcentryid = row.getLong("srcbillentryid");
                List<DynamicObject> srcMatchRelationList = MatchInventoryUtils.queryMatchRelation(true, srcbillkey, srcbillid, srcentryid);
                BigDecimal occupiedQty = srcMatchRelationList.stream().map(single -> single.getBigDecimal("yem_newmatchqty")).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (occupiedQty.compareTo(qty = row.getBigDecimal("qty")) >= 0) {
                    deleteRow.add(row);
                    continue;
                }
                row.set("qty", (Object)qty.subtract(occupiedQty));
                if (occupiedQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                row.set("uav6_enableqty", (Object)qty.subtract(occupiedQty));
            }
            billentry.removeAll(deleteRow);
            if (!billentry.isEmpty()) continue;
            throw new KDBizException("\u5408\u540c\u6570\u91cf\u5df2\u88ab\u5360\u7528\uff0c\u4e0d\u5141\u8bb8\u4e0b\u63a8\uff01");
        }
    }
}

