/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.shmjs.salableinventory.report;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.jetbrains.annotations.NotNull;
import yem.base.common.utils.RptUtil;
import yem.base.common.utils.YEM;
import yem.wm.pa.shmjs.utils.MatchInventoryUtils;

public class SalableinventoryReptListPlugin
extends AbstractReportListDataPlugin {
    private static final String algoKey = SalableinventoryReptListPlugin.class.getName();

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Exception {
        Map<String, DynamicObject> fieldMap = MatchInventoryUtils.queryMatchingFields("A");
        if (fieldMap.isEmpty()) {
            return null;
        }
        HashSet<String> fieldSet = new HashSet<String>(fieldMap.keySet());
        List filterItems = reportQueryParam.getFilter().getFilterItems();
        DataSet queryResult = SalableinventoryReptListPlugin.getQueryResult(filterItems, fieldMap, fieldSet);
        DataSet result = this.queryResultHandling(queryResult);
        return result;
    }

    private DataSet queryResultHandling(DataSet queryResult) {
        ArrayList<String> queryFields = new ArrayList<String>();
        queryFields.add("id materialId");
        queryFields.add("yem_expirationdate uav6_expirationdate");
        QFilter filter = new QFilter("status", "=", (Object)"C").and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("yem_expirationdate", "!=", (Object)0));
        DataSet materialDataSet = ORM.create().queryDataSet(algoKey, "bd_material", String.join((CharSequence)", ", queryFields), null);
        DataSet handlResult = queryResult.leftJoin(materialDataSet).on("yem_materiel", "materialId").select(RptUtil.getDataSetFiledAlias((DataSet)queryResult), RptUtil.getDataSetFiledAlias((DataSet)materialDataSet)).finish();
        List fieldList = RptUtil.getDataSetAliasList((DataSet)handlResult.copy());
        fieldList.remove("materialId");
        fieldList.add("DATEADD(Day, uav6_expirationdate, uav6_warehousdate) as uav6_latestexpirationdate");
        fieldList.add("Now() as uav6_nowdate");
        handlResult = handlResult.select(String.join((CharSequence)", ", fieldList));
        return handlResult;
    }

    private static DataSet getQueryResult(List<FilterItemInfo> filterItems, Map<String, DynamicObject> fieldMap, Set<String> fieldSet) {
        DataSet result = null;
        Map<String, List<DynamicObject>> inventoryScopeA = MatchInventoryUtils.queryInventoryScope("A");
        Map<String, List<DynamicObject>> inventoryScopeB = MatchInventoryUtils.queryInventoryScope("B");
        Set<String> scopes = inventoryScopeA.keySet();
        for (String scope : scopes) {
            List<DynamicObject> purchaseConfigsA = inventoryScopeA.get(scope);
            List<DynamicObject> purchaseConfigsB = inventoryScopeB.get(scope);
            HashSet<DynamicObject> purchaseConfigs = new HashSet<DynamicObject>();
            purchaseConfigs.addAll(purchaseConfigsA);
            purchaseConfigs.addAll(purchaseConfigsB);
            for (DynamicObject purchaseConfig : purchaseConfigs) {
                String purchaseLogo = purchaseConfig.getString("number");
                String purchaseName = purchaseConfig.getString("name");
                Map<String, String> FieldMapping = SalableinventoryReptListPlugin.handleFieldMapping(purchaseConfig);
                if (FieldMapping == null) continue;
                Set<String> oldFieldSet = FieldMapping.keySet();
                DataSet purchaseData = SalableinventoryReptListPlugin.getEntityQueryResult(scope, filterItems, fieldMap, fieldSet, purchaseConfig, oldFieldSet, FieldMapping, purchaseLogo);
                purchaseData = purchaseData.copy().hasNext() ? purchaseData.addField(String.format("'%s'", purchaseName), "uav6_procurebill") : purchaseData.addNullField("uav6_procurebill");
                result = Objects.isNull(result) ? purchaseData : result.union(purchaseData);
            }
        }
        return result;
    }

    private static DataSet getEntityQueryResult(String scope, List<FilterItemInfo> filterItems, Map<String, DynamicObject> fieldMap, Set<String> fieldSet, DynamicObject purchaseConfig, Set<String> oldFieldSet, Map<String, String> FieldMapping, String purchaseLogo) {
        QFilter[] filterArray = SalableinventoryReptListPlugin.buildFilterConditions(filterItems, oldFieldSet, FieldMapping, fieldMap);
        String fields = SalableinventoryReptListPlugin.buildQueryFields(purchaseConfig, FieldMapping);
        if ("1".equals(scope)) {
            fields = fields + ", billno uav6_mainbillno";
        } else {
            String mainbillnonum = purchaseConfig.getString("yem_mainbillnonum");
            fields = fields + ", " + mainbillnonum + " uav6_mainbillno";
        }
        DataSet purchaseData = ORM.create().queryDataSet(algoKey, purchaseLogo, fields, filterArray);
        DynamicObjectCollection purchaseDataCollection = ORM.create().toPlainDynamicObjectCollection(purchaseData.copy());
        List idList = purchaseDataCollection.stream().map(x -> x.getLong("id")).collect(Collectors.toList());
        List entryIdList = purchaseDataCollection.stream().map(x -> x.getLong("yem_billentryid")).collect(Collectors.toList());
        QFilter filter = new QFilter("yem_procurebill.number", "=", (Object)purchaseLogo).and(new QFilter("yem_procurebillid", "in", idList)).and(new QFilter("yem_procurebillrowid", "in", entryIdList)).and(new QFilter("yem_iscomputing", "=", (Object)false)).and(new QFilter("yem_newmatchqty", ">=", (Object)BigDecimal.ZERO));
        DataSet matchRelationData = ORM.create().queryDataSet(algoKey, "yem_pa_matchrelation", "yem_procurebillid,yem_procurebillrowid,yem_newmatchqty yem_matchqty", filter.toArray());
        matchRelationData = matchRelationData.groupBy(new String[]{"yem_procurebillid", "yem_procurebillrowid"}).sum("yem_matchqty").finish();
        purchaseData = purchaseData.leftJoin(matchRelationData).on("id", "yem_procurebillid").on("yem_billentryid", "yem_procurebillrowid").select(RptUtil.getDataSetFiledAlias((DataSet)purchaseData), new String[]{"case when yem_matchqty is null then 0 else yem_matchqty end as yem_matchqty"}).finish();
        HashSet<String> newFieldSet = new HashSet<String>(fieldSet);
        newFieldSet.removeAll(oldFieldSet);
        newFieldSet.remove("yem_matchqty");
        newFieldSet.remove("uav6_mainbillno");
        purchaseData = purchaseData.addNullField(newFieldSet.toArray(new String[0]));
        fieldSet.add("yem_qty - case when yem_matchqty is null then 0 else yem_matchqty end yem_qty");
        fieldSet.add("uav6_mainbillno");
        purchaseData = purchaseData.select(fieldSet.toArray(new String[0])).where("yem_qty > 0");
        return purchaseData;
    }

    private static Map<String, DynamicObject> getFieldLibraryField() {
        HashMap<String, DynamicObject> fieldMap = new HashMap<String, DynamicObject>();
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter = filter.and(new QFilter("status", "=", (Object)"C"));
        filter = filter.and(new QFilter("yem_fieldtype", "in", (Object)new String[]{"A", "C"}));
        DynamicObject[] load = BusinessDataServiceHelper.load((String)"yem_pa_matchingfields", (String)"number, yem_datatype, yem_basics", (QFilter[])new QFilter[]{filter});
        if (load.length == 0) {
            return null;
        }
        for (DynamicObject entity : load) {
            fieldMap.put(entity.getString("number"), entity);
        }
        fieldMap.put("yem_qty", null);
        fieldMap.put("yem_matchqty", null);
        return fieldMap;
    }

    private static Map<String, String> handleFieldMapping(DynamicObject purchaseConfig) {
        DynamicObjectCollection ppwdEntry = purchaseConfig.getDynamicObjectCollection("yem_pa_cxppdjpz_ppwd");
        if (ppwdEntry.isEmpty()) {
            return null;
        }
        HashMap<String, String> FieldMapping = new HashMap<String, String>();
        for (DynamicObject ppwdRow : ppwdEntry) {
            DynamicObject matchfieldlib;
            String entityfieldid = ppwdRow.getString("yem_entityfieldid");
            if (entityfieldid == null || entityfieldid.isEmpty() || YEM.isEmpty((Object)(matchfieldlib = ppwdRow.getDynamicObject("yem_matchfieldlib")))) continue;
            String fieldId = matchfieldlib.getString("number");
            FieldMapping.put(fieldId, entityfieldid);
        }
        FieldMapping.put("yem_qty", purchaseConfig.getString("yem_qtyfiledkeys"));
        FieldMapping.put("id", "id");
        return FieldMapping;
    }

    @NotNull
    private static String buildQueryFields(DynamicObject purchaseConfig, Map<String, String> FieldMapping) {
        ArrayList queryFields = new ArrayList();
        FieldMapping.forEach((key, value) -> {
            if ("yem_qty".equals(key)) {
                String yemQtyfiledkeys = purchaseConfig.getString("yem_qtyfiledkeys");
                StringBuilder qtyfiledkey = new StringBuilder(yemQtyfiledkeys);
                DynamicObjectCollection cxsjy = purchaseConfig.getDynamicObjectCollection("yem_pa_cxppdjpz_cxsjy");
                for (DynamicObject entry : cxsjy) {
                    String yemQentityfieldid = entry.getString("yem_qentityfieldid");
                    if (YEM.isEmpty((Object)yemQentityfieldid)) continue;
                    yemQentityfieldid = "case when " + yemQentityfieldid + " is null then 0 else " + yemQentityfieldid + " end";
                    qtyfiledkey.append(" - ").append(yemQentityfieldid);
                }
                value = qtyfiledkey.toString();
            }
            queryFields.add(value + " " + key);
        });
        return String.join((CharSequence)",", queryFields);
    }

    private static QFilter[] buildFilterConditions(List<FilterItemInfo> filterItems, Set<String> oldFieldSet, Map<String, String> FieldMapping, Map<String, DynamicObject> fieldMap) {
        ArrayList<QFilter> customFilter = new ArrayList<QFilter>();
        for (FilterItemInfo filterItem : filterItems) {
            String datatype;
            Object value;
            String propName = filterItem.getPropName();
            if (!oldFieldSet.contains(propName = propName.substring(0, propName.length() - 1)) || (value = filterItem.getValue()) == null || value.toString().isEmpty()) continue;
            String oldName = FieldMapping.get(propName);
            DynamicObject entity = fieldMap.get(propName);
            switch (datatype = entity.getString("yem_datatype")) {
                case "A": 
                case "C": {
                    QFilter filter = new QFilter(oldName, "=", value);
                    customFilter.add(filter);
                    break;
                }
                case "B": {
                    DynamicObjectCollection basicsCollection = (DynamicObjectCollection)value;
                    ArrayList<Long> list = new ArrayList<Long>();
                    for (DynamicObject basics : basicsCollection) {
                        list.add(basics.getLong("id"));
                    }
                    QFilter basicsFilter = new QFilter(oldName, "in", list);
                    customFilter.add(basicsFilter);
                    break;
                }
            }
        }
        customFilter.add(new QFilter("billstatus", "=", (Object)"C"));
        return customFilter.toArray(new QFilter[0]);
    }
}

