/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pa.shmjs.saloutbill.op.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.module.amt.model.AmountModel;
import yem.base.common.module.amt.utils.AmtUtil;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.wm.pa.shmjs.utils.MatchInventoryUtils;

public class SaloutbillAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey((String)"im_saloutbill", (boolean)true));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        String operationKey;
        super.beforeExecuteOperationTransaction(e);
        switch (operationKey = e.getOperationKey()) {
            case "submit": {
                this.saloutGeneratePurinAudit(e.getDataEntities());
                break;
            }
            case "delete": {
                this.saloutDeletePurinDelete(e.getDataEntities());
            }
        }
    }

    private void saloutDeletePurinDelete(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            OperationResult result;
            String procurementid;
            String stocktype = dataEntity.getString("yem_stocktype");
            HashSet<Long> procurementIdList = new HashSet<Long>();
            if ("A".equals(stocktype) && (procurementid = dataEntity.getString("uav6_procurementid")) != null && !procurementid.isEmpty()) {
                String[] idsArray;
                for (String id : idsArray = procurementid.split(",")) {
                    if (null == id || "0".equals(id)) continue;
                    procurementIdList.add(Long.parseLong(id.trim()));
                }
            }
            if (procurementIdList.isEmpty()) continue;
            Map dirtTargetBills = BFTrackerServiceHelper.findDirtTargetBills((String)"im_purinbill", (Long[])procurementIdList.toArray(new Long[0]));
            HashSet busIdList = new HashSet();
            dirtTargetBills.forEach((key, value) -> {
                for (BFRow bfRow : value) {
                    Long tarBillId = bfRow.getId().getBillId();
                    busIdList.add(tarBillId);
                }
            });
            if (!busIdList.isEmpty()) {
                result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"ap_busbill", (Object[])busIdList.toArray(), (OperateOption)OperateOption.create());
                if (!result.isSuccess()) {
                    DynamicObject[] busbill = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"billno", (QFilter[])new QFilter("id", "in", busIdList).toArray());
                    String billno = Arrays.stream(busbill).map(single -> single.getString("billno")).collect(Collectors.joining(", "));
                    throw new KDBizException(String.format("\u6682\u4f30\u5e94\u4ed8\u5355%s\u53cd\u5ba1\u6838\u5931\u8d25\uff1a%s", billno, YEM.getOpMsg((OperationResult)result)));
                }
                OperationServiceHelper.executeOperate((String)"delete", (String)"ap_busbill", (Object[])busIdList.toArray(), (OperateOption)OperateOption.create());
            }
            if (!(result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"im_purinbill", (Object[])procurementIdList.toArray(), (OperateOption)OperateOption.create())).isSuccess()) {
                String opMsg = YEM.getOpMsg((OperationResult)result);
                if ("\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002".equals(opMsg)) continue;
                throw new KDBizException(String.format("\u91c7\u8d2d\u5165\u5e93\u5355\u53cd\u5ba1\u6838\u5931\u8d25\uff1a%s", YEM.isEmpty((Object)opMsg) ? result.getInteractionContext().getSimpleMessage() : opMsg));
            }
            OperationServiceHelper.executeOperate((String)"delete", (String)"im_purinbill", (Object[])procurementIdList.toArray(), (OperateOption)OperateOption.create());
        }
    }

    public void saloutGeneratePurinAudit(DynamicObject[] dataEntities) {
        for (DynamicObject dataEntity : dataEntities) {
            Map<Long, Map<Long, Set<Long>>> map = this.buildPushdownData(dataEntity);
            this.generatePurinAudit(map);
        }
    }

    private Map<Long, Map<Long, Set<Long>>> buildPushdownData(DynamicObject dataEntity) {
        HashMap<Long, Map<Long, Set<Long>>> map = new HashMap<Long, Map<Long, Set<Long>>>();
        String stocktype = dataEntity.getString("yem_stocktype");
        if ("A".equals(stocktype)) {
            DynamicObjectCollection billentry = dataEntity.getDynamicObjectCollection("billentry");
            for (DynamicObject billRow : billentry) {
                String name = dataEntity.getDataEntityType().getName();
                long hid = dataEntity.getLong("id");
                long eid = billRow.getLong("id");
                List<DynamicObject> load = MatchInventoryUtils.queryMatchRelation(false, name, hid, eid);
                for (DynamicObject dynamicObject : load) {
                    long procurebillid = dynamicObject.getLong("yem_procurebillid");
                    long procurebillrowid = dynamicObject.getLong("yem_procurebillrowid");
                    Map rowIds = map.getOrDefault(procurebillid, new HashMap());
                    Set salesIds = rowIds.getOrDefault(procurebillrowid, new HashSet());
                    salesIds.add(eid);
                    rowIds.put(procurebillrowid, salesIds);
                    map.put(procurebillid, rowIds);
                }
            }
        }
        return map;
    }

    private void generatePurinAudit(Map<Long, Map<Long, Set<Long>>> map) {
        map.forEach((contractId, relatedRowIds) -> {
            PushArgs pushArgs = this.getPushArgs("yem_cnb_purcontract", "im_purinbill", "yem_materialentry", (Long)contractId, (Map<Long, Set<Long>>)relatedRowIds, "2298051178916754432");
            List<DynamicObject> destObject = SaloutbillAuditOpPlugin.getDestObject(pushArgs);
            DynamicObject contract = BusinessDataServiceHelper.loadSingle((String)"yem_cnb_purcontract", (String)"creator", (QFilter[])new QFilter("id", "=", contractId).toArray());
            DynamicObject creator = contract.getDynamicObject("creator");
            for (DynamicObject destInfo : destObject) {
                int i;
                destInfo.set("yem_stocktype", (Object)"A");
                destInfo.set("creator", (Object)creator);
                DynamicObjectCollection billentry = destInfo.getDynamicObjectCollection("billentry");
                ArrayList deleteRow = new ArrayList(billentry);
                if (billentry.isEmpty()) continue;
                int size = billentry.size();
                for (i = 0; i < size; ++i) {
                    DynamicObject[] matchrela;
                    DynamicObject billRow = (DynamicObject)billentry.get(i);
                    String mainbillentity = billRow.getString("mainbillentity");
                    long mainbillid = billRow.getLong("mainbillid");
                    long mainbillentryid = billRow.getLong("mainbillentryid");
                    Set salesEntryIds = (Set)relatedRowIds.get(mainbillentryid);
                    QFilter qFilter = new QFilter("yem_procurebill.number", "=", (Object)mainbillentity);
                    qFilter.and("yem_procurebillid", "=", (Object)mainbillid);
                    qFilter.and("yem_procurebillrowid", "=", (Object)mainbillentryid);
                    qFilter.and("yem_salebillrowid", "in", (Object)salesEntryIds);
                    qFilter.and("yem_salebill.number", "=", (Object)"im_saloutbill");
                    qFilter.and("yem_iscomputing", "=", (Object)false);
                    for (DynamicObject matchrelaInfo : matchrela = BusinessDataServiceHelper.load((String)"yem_pa_matchrelation", (String)String.join((CharSequence)",", DynamicObjectUtil.addFieldKey((String)"yem_pa_matchrelation", (boolean)true)), (QFilter[])qFilter.toArray())) {
                        DynamicObject purinbillEntry = billentry.addNew();
                        DynamicObjectUtil.copyDynamicObject((DynamicObject)billRow, (DynamicObject)purinbillEntry, (int)2, (boolean)false, (boolean)true, (boolean)true);
                        long salebillid = matchrelaInfo.getLong("yem_salebillid");
                        long salebillrowid = matchrelaInfo.getLong("yem_salebillrowid");
                        DynamicObject saloutbill = BusinessDataServiceHelper.loadSingle((String)"im_saloutbill", (QFilter[])new QFilter("id", "=", (Object)salebillid).toArray());
                        DynamicObjectCollection saloutBillentry = saloutbill.getDynamicObjectCollection("billentry");
                        for (DynamicObject saloutRow : saloutBillentry) {
                            long id = saloutRow.getLong("id");
                            if (salebillrowid != id) continue;
                            String materialtype = saloutRow.getString("uav6_materialtype");
                            String materialtypetext = saloutRow.getString("uav6_materialtypetext");
                            String brand = saloutRow.getString("uav6_brand");
                            String specification = saloutRow.getString("uav6_specification");
                            String billadingno = saloutRow.getString("uav6_billadingno");
                            String cabinetno = saloutRow.getString("uav6_cabinetno");
                            BigDecimal qty = matchrelaInfo.getBigDecimal("yem_matchqty");
                            DynamicObject warehouse = saloutRow.getDynamicObject("warehouse");
                            BigDecimal qtyunit2nd = saloutRow.getBigDecimal("qtyunit2nd");
                            purinbillEntry.set("uav6_materialtype", (Object)materialtype);
                            purinbillEntry.set("uav6_materialtypetext", (Object)materialtypetext);
                            purinbillEntry.set("uav6_brand", (Object)brand);
                            purinbillEntry.set("uav6_specification", (Object)specification);
                            purinbillEntry.set("uav6_billadingno", (Object)billadingno);
                            purinbillEntry.set("uav6_cabinetno", (Object)cabinetno);
                            purinbillEntry.set("qty", (Object)qty);
                            purinbillEntry.set("qtyunit2nd", (Object)qtyunit2nd);
                            purinbillEntry.set("baseqty", (Object)qty);
                            purinbillEntry.set("warehouse", (Object)warehouse);
                            purinbillEntry.set("uav6_saloutrowid", (Object)salebillrowid);
                        }
                    }
                }
                for (DynamicObject dynamicObject : deleteRow) {
                    billentry.remove((Object)dynamicObject);
                }
                for (i = 0; i < billentry.size(); ++i) {
                    ((DynamicObject)billentry.get(i)).set("seq", (Object)(i + 1));
                }
            }
            OperationResult result = SaveServiceHelper.saveOperate((String)"im_purinbill", (DynamicObject[])destObject.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("WF", "TRUE");
            result = OperationServiceHelper.executeOperate((String)"submit", (String)"im_purinbill", (DynamicObject[])destObject.toArray(new DynamicObject[0]), (OperateOption)operateOption);
            for (DynamicObject destInfo : destObject) {
                BigDecimal totalQty = BigDecimal.ZERO;
                BigDecimal totalAmt = BigDecimal.ZERO;
                BigDecimal totalAmtBase = BigDecimal.ZERO;
                BigDecimal totalAmtTax = BigDecimal.ZERO;
                BigDecimal totalAmtTaxBase = BigDecimal.ZERO;
                BigDecimal taxRateAmt = BigDecimal.ZERO;
                BigDecimal taxRateAmtBase = BigDecimal.ZERO;
                DynamicObjectCollection billentry = destInfo.getDynamicObjectCollection("billentry");
                for (DynamicObject billRow : billentry) {
                    String mainbillentity = billRow.getString("mainbillentity");
                    long mainbillid = billRow.getLong("mainbillid");
                    long mainbillentryid = billRow.getLong("mainbillentryid");
                    QFilter qFilter = new QFilter("yem_procurebill.number", "=", (Object)mainbillentity);
                    qFilter.and("yem_procurebillid", "=", (Object)mainbillid);
                    qFilter.and("yem_procurebillrowid", "=", (Object)mainbillentryid);
                    qFilter.and("yem_salebill.number", "=", (Object)"im_saloutbill");
                    DynamicObject[] matchrela = BusinessDataServiceHelper.load((String)"yem_pa_matchrelation", (String)String.join((CharSequence)",", DynamicObjectUtil.addFieldKey((String)"yem_pa_matchrelation", (boolean)true)), (QFilter[])qFilter.toArray());
                    HashSet<DynamicObject> saloutbillList = new HashSet<DynamicObject>();
                    for (DynamicObject matchrelaInfo : matchrela) {
                        long salebillid = matchrelaInfo.getLong("yem_salebillid");
                        long salebillrowid = matchrelaInfo.getLong("yem_salebillrowid");
                        DynamicObject saloutbill = BusinessDataServiceHelper.loadSingle((String)"im_saloutbill", (QFilter[])new QFilter("id", "=", (Object)salebillid).toArray());
                        DynamicObjectCollection saloutBillentry = saloutbill.getDynamicObjectCollection("billentry");
                        for (DynamicObject saloutRow : saloutBillentry) {
                            long id = saloutRow.getLong("id");
                            if (salebillrowid == id) {
                                BigDecimal exchangerate = destInfo.getBigDecimal("exchangerate");
                                String billno = destInfo.getString("billno");
                                long purId = destInfo.getLong("id");
                                String lotnumber = billRow.getString("lotnumber");
                                boolean isTax = destInfo.getBoolean("istax");
                                boolean inputAmt = destInfo.getBoolean("inputamount");
                                BigDecimal qty = billRow.getBigDecimal("qty");
                                BigDecimal price = billRow.getBigDecimal("price");
                                BigDecimal taxPrice = billRow.getBigDecimal("priceandtax");
                                BigDecimal amt = billRow.getBigDecimal("amount");
                                BigDecimal taxAmt = billRow.getBigDecimal("amountandtax");
                                BigDecimal tax = billRow.getBigDecimal("taxamount");
                                BigDecimal taxRate = billRow.getBigDecimal("taxrate");
                                int priceUom = 1;
                                DynamicObject settlecurrency = destInfo.getDynamicObject("settlecurrency");
                                Map<String, Integer> precision = SaloutbillAuditOpPlugin.precision(settlecurrency.getLong("id"));
                                int pricePrecision = precision.get("priceprecision");
                                int amtPrecision = precision.get("amtprecision");
                                AmountModel calculate = AmtUtil.calculate((boolean)isTax, (boolean)inputAmt, (BigDecimal)qty, (BigDecimal)price, (BigDecimal)taxPrice, (BigDecimal)amt, (BigDecimal)taxAmt, (BigDecimal)tax, (BigDecimal)taxRate, (int)priceUom, (int)pricePrecision, (int)amtPrecision);
                                saloutRow.set("lotnumber", (Object)lotnumber);
                                String procurementno = saloutbill.getString("uav6_procurementno");
                                if (YEM.isEmpty((Object)procurementno)) {
                                    saloutbill.set("uav6_procurementno", (Object)billno);
                                } else {
                                    saloutbill.set("uav6_procurementno", (Object)(procurementno + "," + billno));
                                }
                                String procurementid = saloutbill.getString("uav6_procurementid");
                                if (YEM.isEmpty((Object)procurementid)) {
                                    saloutbill.set("uav6_procurementid", (Object)purId);
                                } else {
                                    saloutbill.set("uav6_procurementid", (Object)(procurementid + "," + purId));
                                }
                                BigDecimal amts = calculate.getAmt();
                                BigDecimal amtsBase = amts.multiply(exchangerate);
                                BigDecimal taxamt = calculate.getTaxAmt();
                                BigDecimal taxamtBase = taxamt.multiply(exchangerate);
                                BigDecimal taxs = calculate.getTax();
                                BigDecimal taxsBase = taxs.multiply(exchangerate);
                                billRow.set("amount", (Object)amts);
                                billRow.set("curamount", (Object)amtsBase);
                                billRow.set("amountandtax", (Object)taxamt);
                                billRow.set("curamountandtax", (Object)taxamtBase);
                                billRow.set("taxamount", (Object)taxs);
                                billRow.set("curtaxamount", (Object)taxsBase);
                                billRow.set("returnqty", (Object)BigDecimal.ZERO);
                                billRow.set("returnbaseqty", (Object)BigDecimal.ZERO);
                                billRow.set("remainreturnbaseqty", (Object)qty);
                                billRow.set("remainreturnqty", (Object)qty);
                                billRow.set("joinpriceqty", (Object)BigDecimal.ZERO);
                                billRow.set("joinpricebaseqty", (Object)BigDecimal.ZERO);
                                billRow.set("remainjoinpriceqty", (Object)qty);
                                billRow.set("remainjoinpricebaseqty", (Object)qty);
                                billRow.set("verifyqty", (Object)BigDecimal.ZERO);
                                billRow.set("verifybaseqty", (Object)BigDecimal.ZERO);
                                billRow.set("unverifyqty", (Object)qty);
                                billRow.set("unverifybaseqty", (Object)qty);
                                totalQty = totalQty.add(qty);
                                totalAmt = totalAmt.add(amts);
                                totalAmtBase = totalAmtBase.add(amtsBase);
                                totalAmtTax = totalAmtTax.add(taxamt);
                                totalAmtTaxBase = totalAmtTaxBase.add(taxamtBase);
                                taxRateAmt = taxRateAmt.add(taxs);
                                taxRateAmtBase = taxRateAmtBase.add(taxsBase);
                            }
                            saloutbillList.add(saloutbill);
                        }
                        SaveServiceHelper.save((DynamicObject[])saloutbillList.toArray(new DynamicObject[0]));
                    }
                }
                destInfo.set("yem_totalqty", (Object)totalQty);
                destInfo.set("yem_amount", (Object)totalAmt);
                destInfo.set("yem_amountbase", (Object)totalAmtBase);
                destInfo.set("yem_amounttax", (Object)totalAmtTax);
                destInfo.set("yem_amounttaxbase", (Object)totalAmtTaxBase);
                destInfo.set("yem_taxrateamount", (Object)taxRateAmt);
                destInfo.set("yem_taxrateamountbase", (Object)taxRateAmtBase);
            }
            SaveServiceHelper.save((DynamicObject[])destObject.toArray(new DynamicObject[0]));
            result = OperationServiceHelper.executeOperate((String)"audit", (String)"im_purinbill", (DynamicObject[])destObject.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        });
    }

    private PushArgs getPushArgs(String srcEntityNumber, String targetEntityNumber, String targetEntryEntity, Long sourceBillId, Map<Long, Set<Long>> entitypkList, String rule) throws KDBizException {
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(srcEntityNumber);
        pushArgs.setTargetEntityNumber(targetEntityNumber);
        pushArgs.setHasRight(true);
        pushArgs.addCustomParam("zhiyun", "zhiyun");
        pushArgs.setRuleId(rule);
        pushArgs.setBuildConvReport(true);
        ArrayList<ListSelectedRow> auditResult = new ArrayList<ListSelectedRow>();
        for (Long purchaseEntryId : entitypkList.keySet()) {
            ListSelectedRow row = new ListSelectedRow();
            row.setPrimaryKeyValue((Object)sourceBillId);
            row.setEntryEntityKey(targetEntryEntity);
            row.setEntryPrimaryKeyValue((Object)purchaseEntryId);
            auditResult.add(row);
        }
        pushArgs.setSelectedRows(auditResult);
        return pushArgs;
    }

    public static List<DynamicObject> getDestObject(PushArgs pushArgs) {
        ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        if (!pushResult.isSuccess()) {
            String errMessage = pushResult.getMessage();
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0b\u63a8\u5931\u8d25:", (String)"SchemeEngineService_1", (String)"node-debug-mservice_test", (Object[])new Object[0]) + errMessage);
        }
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
        List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

            public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
            }
        }, targetMainType);
        return targetBillObjs;
    }

    public static Map<String, Integer> precision(Long id) {
        DynamicObject currency = BusinessDataServiceHelper.loadSingle((String)"bd_currency", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)});
        HashMap<String, Integer> amtMap = new HashMap<String, Integer>();
        amtMap.put("amtprecision", currency.getInt("amtprecision"));
        amtMap.put("priceprecision", currency.getInt("priceprecision"));
        return amtMap;
    }
}

