/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cng.trade.bill.contracttpl.form;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.DateUtil;
import yem.base.common.utils.YEM;
import yem.wm.cng.trade.bill.utils.BusinessUtil;

public class ContractTplBillPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        IDataModel model = this.getModel();
        ChangeData changeData = e.getChangeSet()[0];
        int index = changeData.getRowIndex();
        int parentRowIndex = e.getChangeSet()[0].getParentRowIndex();
        switch (name) {
            case "yem_paycomm": {
                this.payCommChange(model);
                break;
            }
            case "yem_commissionprice": {
                this.commissPriceChange(model, index);
                break;
            }
            case "yem_commissionamount": {
                this.commissAmountChange(model, index);
                break;
            }
            case "yem_lenghtunitid": 
            case "yem_long": 
            case "yem_wide": 
            case "yem_high": {
                this.setVolM3(model, index);
                break;
            }
            case "yem_material": {
                this.setMaterialSub(model, index);
                break;
            }
            case "yem_unit": {
                BusinessUtil.setSubValue(model, index, "yem_unit", "yem_planunitid");
                break;
            }
            case "yem_qty": {
                this.setQtySub(model, index);
                break;
            }
            case "yem_transportleadtime": 
            case "yem_plandate": {
                this.setDeliverfDate(this.getView(), index, parentRowIndex, "yem_transportleadtime");
                break;
            }
            case "yem_plandeliverydate": {
                this.setDeliverfDate(this.getView(), index, parentRowIndex, "yem_plandeliverydate");
                break;
            }
            case "yem_planqty": {
                this.setBaseQty(index, parentRowIndex);
            }
        }
    }

    private void setBaseQty(int index, int parentRowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("yem_materialentry", parentRowIndex);
        BigDecimal rate = this.getRate(rowEntity);
        BigDecimal yem_planqty = (BigDecimal)this.getModel().getValue("yem_planqty", index, parentRowIndex);
        this.getModel().setValue("yem_baseplanqty", (Object)yem_planqty.multiply(rate), index, parentRowIndex);
    }

    public void setDeliverfDate(IFormView view, int index, int parentRowIndex, String fieldKey) {
        IDataModel model = view.getModel();
        Date yem_plandate = (Date)model.getValue("yem_plandate", index, parentRowIndex);
        Object value = model.getValue(fieldKey, index, parentRowIndex);
        if (yem_plandate != null && value != null) {
            DynamicObject rowEntity = model.getEntryRowEntity("yem_cng_recdelplan", index, parentRowIndex);
            if (value instanceof Date) {
                Date date = (Date)value;
                rowEntity.set("yem_transportleadtime", (Object)DateUtil.countDays((Date)date, (Date)yem_plandate));
                view.updateView("yem_transportleadtime", index, parentRowIndex);
            } else if (value instanceof Integer) {
                int days = (Integer)value;
                rowEntity.set("yem_plandeliverydate", (Object)DateUtil.addDays((Date)yem_plandate, (int)(-days)));
                view.updateView("yem_plandeliverydate", index, parentRowIndex);
            }
        }
    }

    public void setQtySub(IDataModel model, int index) {
        BigDecimal qty = (BigDecimal)model.getValue("yem_qty");
        if (qty.compareTo(BigDecimal.ZERO) > 0) {
            DynamicObject rowEntity = model.getEntryRowEntity("yem_materialentry", index);
            BigDecimal rate = this.getRate(rowEntity);
            DynamicObjectCollection collection = rowEntity.getDynamicObjectCollection("yem_cng_recdelplan");
            if (YEM.isNotEmpty((Object)collection) && collection.size() == 1) {
                model.setValue("yem_planqty", (Object)qty, 0, index);
                model.setValue("yem_baseplanqty", (Object)qty.multiply(rate), 0, index);
            }
        }
    }

    public void setMaterialSub(IDataModel model, int index) {
        DynamicObject rowEntity = model.getEntryRowEntity("yem_materialentry", index);
        DynamicObjectCollection collection = rowEntity.getDynamicObjectCollection("yem_cng_recdelplan");
        if (YEM.isNotEmpty((Object)collection)) {
            DynamicObject yem_material = (DynamicObject)model.getValue("yem_material", index);
            for (int i = 0; i < collection.size(); ++i) {
                ((DynamicObject)collection.get(i)).set("yem_materialplan", (Object)yem_material);
                DynamicObject baseunit = yem_material != null ? yem_material.getDynamicObject("baseunit") : null;
                model.setValue("yem_planunitid", yem_material != null ? baseunit : null, i, index);
                model.setValue("yem_baseunitplan", yem_material != null ? baseunit : null, i, index);
            }
        }
        this.getView().updateView("yem_cng_recdelplan");
    }

    public void payCommChange(IDataModel model) {
        String yem_paycomm = (String)model.getValue("yem_paycomm");
        if (!"C".equals(yem_paycomm)) {
            model.setValue("yem_commissionty", null);
            DynamicObjectCollection cn_spxx = model.getEntryEntity("yem_materialentry");
            for (int i = 0; i < cn_spxx.size(); ++i) {
                model.setValue("yem_commissionprice", (Object)BigDecimal.ZERO, i);
            }
        }
    }

    public void commissPriceChange(IDataModel model, int index) {
        DynamicObject cnSpxx = model.getEntryRowEntity("yem_materialentry", index);
        BigDecimal qty = cnSpxx.getBigDecimal("yem_qty");
        BigDecimal commissionprice = cnSpxx.getBigDecimal("yem_commissionprice");
        int scale = BusinessUtil.getScale(this, true, "yem_commissionamount");
        cnSpxx.set("yem_commissionamount", (Object)BigDecimalUtils.multiply((BigDecimal)qty, (BigDecimal)commissionprice, (int)scale));
        this.getView().updateView("yem_commissionamount", index);
    }

    public void commissAmountChange(IDataModel model, int index) {
        DynamicObject cnSpxx = model.getEntryRowEntity("yem_materialentry", index);
        BigDecimal qty = cnSpxx.getBigDecimal("yem_qty");
        BigDecimal commissionamount = cnSpxx.getBigDecimal("yem_commissionamount");
        int scale = BusinessUtil.getScale(this, false, "yem_commissionprice");
        BigDecimal price = qty.compareTo(BigDecimal.ZERO) > 0 ? BigDecimalUtils.div((BigDecimal)commissionamount, (BigDecimal)qty, (int)scale) : BigDecimal.ZERO;
        cnSpxx.set("yem_commissionprice", (Object)price);
        this.getView().updateView("yem_commissionprice", index);
    }

    public void setVolM3(IDataModel model, int index) {
        DynamicObject lenghtunitid = (DynamicObject)model.getValue("yem_lenghtunitid", index);
        DynamicObject unitM = BusinessDataServiceHelper.loadSingle((String)"bd_measureunits", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"m")});
        DynamicObject material = (DynamicObject)model.getValue("yem_material", index);
        BigDecimal rate = YEM.getUnitRate((Object)material, (Object)lenghtunitid, (Object)unitM);
        BigDecimal yemLong = (BigDecimal)model.getValue("yem_long", index);
        BigDecimal yemWide = (BigDecimal)model.getValue("yem_wide", index);
        BigDecimal yemHigh = (BigDecimal)model.getValue("yem_high", index);
        model.setValue("yem_volm3", (Object)yemLong.multiply(rate).multiply(yemWide).multiply(rate).multiply(yemHigh).multiply(rate), index);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        int row = rowDataEntities[0].getRowIndex();
        int parentRowIndex = rowDataEntities[0].getParentRowIndex();
        if ("yem_cng_recdelplan".equals(name)) {
            this.addIndexRow(row, parentRowIndex);
        }
    }

    private void addIndexRow(int index, int parentRowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("yem_materialentry", parentRowIndex);
        BigDecimal yem_qty = rowEntity.getBigDecimal("yem_qty");
        DynamicObjectCollection collection = rowEntity.getDynamicObjectCollection("yem_cng_recdelplan");
        BigDecimal qty = BigDecimal.ZERO;
        for (DynamicObject bill : collection) {
            qty = qty.add(bill.getBigDecimal("yem_planqty"));
        }
        this.getModel().setValue("yem_materialplan", rowEntity.get("yem_material"), index, parentRowIndex);
        this.getModel().setValue("yem_planunitid", rowEntity.get("yem_unit"), index, parentRowIndex);
        this.getModel().setValue("yem_baseunitplan", rowEntity.get("yem_baseunit"), index, parentRowIndex);
        BigDecimal addqty = yem_qty.subtract(qty);
        BigDecimal rate = this.getRate(rowEntity);
        if (addqty.compareTo(BigDecimal.ZERO) > 0) {
            this.getModel().setValue("yem_planqty", (Object)addqty, index, parentRowIndex);
            this.getModel().setValue("yem_baseplanqty", (Object)addqty.multiply(rate), index, parentRowIndex);
        }
    }

    private BigDecimal getRate(DynamicObject rowEntity) {
        return YEM.getUnitRate((Object)rowEntity.get("yem_material"), (Object)rowEntity.get("yem_unit"), (Object)rowEntity.get("yem_baseunit"));
    }
}

