/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cng.trade.bill.contracttpl.opplugin.op;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.YEM;
import yem.wm.cng.trade.bill.contracttpl.opplugin.validator.ContractTplSubmitValidator;

public class ContractTplSubmitOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("yem_qty");
        fieldKeys.add("yem_material");
        fieldKeys.add("yem_unit");
        fieldKeys.add("yem_qty");
        fieldKeys.add("yem_baseunit");
        fieldKeys.add("yem_forwarddate");
        fieldKeys.add("yem_materialplan");
        fieldKeys.add("yem_plandate");
        fieldKeys.add("yem_plandeliverydate");
        fieldKeys.add("yem_planunitid");
        fieldKeys.add("yem_planqty");
        fieldKeys.add("yem_baseunitplan");
        fieldKeys.add("yem_baseplanqty");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ContractTplSubmitValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String key = e.getOperationKey();
        if (key.equals("submit")) {
            for (DynamicObject dataEntity : e.getDataEntities()) {
                boolean issave = false;
                DynamicObjectCollection yem_materialentry = dataEntity.getDynamicObjectCollection("yem_materialentry");
                DynamicProperty yem_forwarddate = yem_materialentry.getDynamicObjectType().getProperty("yem_forwarddate");
                for (DynamicObject materialentry : yem_materialentry) {
                    Object forwarddate;
                    DynamicObjectCollection collection = materialentry.getDynamicObjectCollection("yem_cng_recdelplan");
                    if (collection.size() != 0) continue;
                    DynamicObject addNew = collection.addNew();
                    Object yem_material = materialentry.get("yem_material");
                    addNew.set("yem_materialplan", yem_material);
                    Object yem_unit = materialentry.get("yem_unit");
                    addNew.set("yem_planunitid", yem_unit);
                    Object yem_baseunit = materialentry.get("yem_baseunit");
                    addNew.set("yem_baseunitplan", yem_baseunit);
                    BigDecimal yem_qty = materialentry.getBigDecimal("yem_qty");
                    addNew.set("yem_planqty", (Object)yem_qty);
                    BigDecimal unitRate = YEM.getUnitRate((Object)yem_material, (Object)yem_unit, (Object)yem_baseunit);
                    addNew.set("yem_baseplanqty", (Object)unitRate.multiply(yem_qty));
                    if (yem_forwarddate != null && (forwarddate = materialentry.get("yem_forwarddate")) instanceof Date) {
                        addNew.set("yem_plandate", forwarddate);
                        addNew.set("yem_plandeliverydate", forwarddate);
                    }
                    issave = true;
                }
                if (!issave) continue;
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
            }
        }
    }
}

