/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cng.trade.bill.contracttpl.opplugin.validator;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import yem.base.common.utils.DateUtil;
import yem.base.common.utils.SystemParamUtil;

public class ContractTplSubmitValidator
extends AbstractValidator {
    public void validate() {
        Boolean yem_isplan = (Boolean)SystemParamUtil.getAppParam((String)"yem_cn", (String)"yem_isplan");
        if (yem_isplan != null && yem_isplan.booleanValue()) {
            for (ExtendedDataEntity extendedData : this.getDataEntities()) {
                DynamicObject dataEntity = extendedData.getDataEntity();
                DynamicObjectCollection yem_materialentry = dataEntity.getDynamicObjectCollection("yem_materialentry");
                for (int i = 0; i < yem_materialentry.size(); ++i) {
                    DynamicObject materialentry = (DynamicObject)yem_materialentry.get(i);
                    DynamicObjectCollection collection = materialentry.getDynamicObjectCollection("yem_cng_recdelplan");
                    String entryName = collection.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN();
                    List collect = collection.stream().filter(x -> x.getDate("yem_plandeliverydate") != null).collect(Collectors.toList());
                    List yem_plandeliverydate = collect.stream().map(x -> DateUtil.getStartOrEndDate((Date)x.getDate("yem_plandeliverydate"), (boolean)false)).distinct().collect(Collectors.toList());
                    if (collect.size() != yem_plandeliverydate.size()) {
                        this.addMessage(extendedData, String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%s\u884c\uff0c{%s}\u4e2d\u5b58\u5728\u3010\u8ba1\u5212\u53d1\u8fd0\u65e5\u671f\u3011\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\uff01", i + 1, entryName));
                    }
                    if (collection.size() == 0) {
                        this.addWarningMessage(extendedData, String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%s\u884c\uff0c\u4e0d\u5b58\u5728{%s}\u6570\u636e\uff0c\u7cfb\u7edf\u4f1a\u81ea\u52a8\u6dfb\u52a0\u4e00\u884c\u6570\u636e\uff0c\u8bf7\u77e5\u6089\u3002", i + 1, entryName));
                    }
                    BigDecimal yem_qty = materialentry.getBigDecimal("yem_qty");
                    BigDecimal qty = BigDecimal.ZERO;
                    for (DynamicObject row : collection) {
                        qty = qty.add(row.getBigDecimal("yem_planqty"));
                    }
                    if (yem_qty.compareTo(qty) == 0 || collection.size() <= 0) continue;
                    this.addMessage(extendedData, String.format("\u5546\u54c1\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5546\u54c1\u660e\u7ec6\u884c\u6570\u91cf\u548c{%s}\u6570\u91cf\u4e4b\u548c\u4e0d\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\uff01", i + 1, entryName));
                }
            }
        }
    }
}

