/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cng.trade.bill.expcontract.form;

import java.math.BigDecimal;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.RowDataEntity;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import yem.base.common.utils.BigDecimalUtils;
import yem.wm.cng.trade.bill.utils.BusinessUtil;

public class ExportContractBillPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        String name = e.getProperty().getName();
        int index = e.getChangeSet()[0].getRowIndex();
        switch (name) {
            case "yem_enablediscount": 
            case "yem_discountway": 
            case "yem_disamount": 
            case "yem_discountrate": 
            case "yem_amount": {
                BusinessUtil.setDiscountAmt(model);
                break;
            }
            case "yem_qty": {
                this.setOtherAmt(model, "yem_freightamt", "yem_oceanamt");
                this.setOtherAmt(model, "yem_premiumamt", "yem_premium");
                break;
            }
            case "yem_freightamt": {
                this.setOtherAmt(model, "yem_freightamt", "yem_oceanamt");
                break;
            }
            case "yem_premiumamt": {
                this.setOtherAmt(model, "yem_premiumamt", "yem_premium");
                break;
            }
            case "yem_forwarddate": {
                BusinessUtil.setSubValue(model, index, "yem_forwarddate", "yem_plandate");
            }
        }
    }

    private void setOtherAmt(IDataModel model, String fieldkey, String entryfieldkey) {
        DynamicObjectCollection cn_spxx = model.getEntryEntity("yem_materialentry");
        BigDecimal sumqty = BigDecimal.ZERO;
        BigDecimal amt = (BigDecimal)model.getValue(fieldkey);
        for (DynamicObject cnSpxx : cn_spxx) {
            sumqty = sumqty.add(cnSpxx.getBigDecimal("yem_qty"));
        }
        if (sumqty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        for (int i = 0; i < cn_spxx.size(); ++i) {
            DynamicObject cnSpxx;
            cnSpxx = (DynamicObject)cn_spxx.get(i);
            BigDecimal qty = cnSpxx.getBigDecimal("yem_qty");
            model.setValue(entryfieldkey, (Object)BigDecimalUtils.div((BigDecimal)qty, (BigDecimal)sumqty, (int)2).multiply(amt), i);
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        RowDataEntity[] rowDataEntities = e.getRowDataEntities();
        int row = rowDataEntities[0].getRowIndex();
        int parentRowIndex = rowDataEntities[0].getParentRowIndex();
        switch (name) {
            case "yem_materialentry": {
                BusinessUtil.setDiscountAmt(model);
                this.setOtherAmt(model, "yem_freightamt", "yem_oceanamt");
                this.setOtherAmt(model, "yem_premiumamt", "yem_premium");
                break;
            }
            case "yem_cng_recdelplan": {
                this.setSubValue(row, parentRowIndex);
            }
        }
    }

    private void setSubValue(int index, int parentRowIndex) {
        DynamicObject rowEntity = this.getModel().getEntryRowEntity("yem_materialentry", parentRowIndex);
        this.getModel().setValue("yem_plandate", rowEntity.get("yem_forwarddate"), index, parentRowIndex);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if (name.equals("yem_materialentry")) {
            BusinessUtil.setDiscountAmt(model);
            this.setOtherAmt(model, "yem_freightamt", "yem_oceanamt");
            this.setOtherAmt(model, "yem_premiumamt", "yem_premium");
        }
    }
}

