/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cng.trade.bill.quotation.form;

import java.math.BigDecimal;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import yem.wm.cng.trade.bill.utils.BusinessUtil;

public class ExpQuotationBillPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        ChangeData[] changeSet = e.getChangeSet();
        int index = changeSet[0].getRowIndex();
        DynamicObjectCollection cn_spxx = this.getModel().getEntryEntity("yem_materialentry");
        switch (e.getProperty().getName()) {
            case "yem_enablediscount": 
            case "yem_discountway": 
            case "yem_disamount": 
            case "yem_amount": 
            case "yem_discountrate": {
                BusinessUtil.setDiscountAmt(model);
                break;
            }
            case "yem_fobamount": {
                this.setFobAmountValue(model);
                break;
            }
            case "yem_exrate": {
                this.setFobAmountValue(model);
                for (int i = 0; i < cn_spxx.size(); ++i) {
                    this.setAmtBaseValue(model, i);
                }
                break;
            }
            case "yem_qty": 
            case "yem_price": {
                this.setAmtValue(model, index);
                break;
            }
            case "yem_amt": {
                this.setAmtBaseValue(model, index);
                break;
            }
        }
    }

    private void setAmtValue(IDataModel model, int index) {
        BigDecimal yem_qty = (BigDecimal)model.getValue("yem_qty", index);
        BigDecimal yem_price = (BigDecimal)model.getValue("yem_price", index);
        model.setValue("yem_amt", (Object)yem_qty.multiply(yem_price), index);
    }

    private void setAmtBaseValue(IDataModel model, int index) {
        BigDecimal yem_amt = (BigDecimal)model.getValue("yem_amt", index);
        BigDecimal exrate = (BigDecimal)model.getValue("yem_exrate");
        model.setValue("yem_fobamountbase", (Object)yem_amt.multiply(exrate));
    }

    private void setFobAmountValue(IDataModel model) {
        BigDecimal fobamount = (BigDecimal)model.getValue("yem_fobamount");
        BigDecimal exrate = (BigDecimal)model.getValue("yem_exrate");
        model.setValue("yem_fobamountbase", (Object)fobamount.multiply(exrate));
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (name.equals("yem_materialentry")) {
            BusinessUtil.setDiscountAmt(this.getModel());
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String name = e.getEntryProp().getName();
        if (name.equals("yem_materialentry")) {
            BusinessUtil.setDiscountAmt(this.getModel());
        }
    }
}

