/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cng.trade.bill.utils;

import java.math.BigDecimal;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.form.control.Control;
import kd.bos.form.field.AmountEdit;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;

public class BusinessUtil {
    public static int getScale(AbstractBillPlugIn plugIn, boolean prop, String fieldKey) {
        int scale;
        IDataModel model = plugIn.getView().getModel();
        Control control = plugIn.getControl(fieldKey);
        AmountEdit edit = (AmountEdit)control;
        AmountProp property = (AmountProp)edit.getProperty();
        String name = property.getControlPropName();
        int n = scale = prop ? 2 : 4;
        if (YEM.isEmpty((Object)name)) {
            return scale;
        }
        DynamicObject currency = (DynamicObject)model.getValue(name);
        if (currency == null) {
            return scale;
        }
        currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getLong("id"), (String)currency.getDynamicObjectType().getName());
        return currency.getInt("amtprecision");
    }

    public static void setDiscountAmt(IDataModel model) {
        if (!((Boolean)model.getValue("yem_enablediscount")).booleanValue()) {
            return;
        }
        String discountway = (String)model.getValue("yem_discountway");
        BigDecimal amt = BigDecimal.ZERO;
        if (discountway == null) {
            return;
        }
        switch (discountway) {
            case "A": {
                BigDecimal amount = (BigDecimal)model.getValue("yem_amount");
                BigDecimal discountrate = (BigDecimal)model.getValue("yem_discountrate");
                amt = amount.multiply(discountrate);
                break;
            }
            case "B": {
                DynamicObjectCollection cn_spxx = model.getEntryEntity("yem_materialentry");
                for (DynamicObject cnSpxx : cn_spxx) {
                    amt = amt.add(cnSpxx.getBigDecimal("yem_disamount"));
                }
                break;
            }
        }
        model.setValue("yem_discountamt", (Object)amt);
    }

    public static void setSubValue(IDataModel model, int index, String srcFieldKey, String tagFieldKey) {
        DynamicObject rowEntity = model.getEntryRowEntity("yem_materialentry", index);
        DynamicObjectCollection collection = rowEntity.getDynamicObjectCollection("yem_cng_recdelplan");
        Object yem_unit = model.getValue(srcFieldKey, index);
        for (int i = 0; i < collection.size(); ++i) {
            model.setValue(tagFieldKey, yem_unit, i, index);
        }
    }
}

