/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.fwg.trade.bill.esdeliver.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.module.amt.model.AmountModel;
import yem.base.common.module.amt.utils.AmtUtil;
import yem.base.common.utils.YEM;
import yem.wm.fw.common.utils.CalculationToolUtil;
import yem.wm.fw.common.utils.ShippUtil;
import yem.wm.fwg.trade.bill.purdeliver.form.PurdeliverBillPlugin;

public class EsdelivergBillPlugin
extends AbstractBillPlugIn {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        DynamicObjectCollection materialentry = dataEntity.getDynamicObjectCollection("yem_materialentry");
        this.enableQty(materialentry, dataEntity);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"yem_fwg_cytd_zxxxtool"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "yem_zxxx_htzx": {
                this.dialogbox("yem_fw_boxbackfill", "yem_zxxx_htzx");
                break;
            }
            case "yem_storageback": {
                this.dialogbox("yem_fw_storagebackfill", "yem_storageback");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        this.propertyChangedHead(e);
        this.propertyChangedSpxxEntry(e);
        this.propertyChangedCgxxEntry(e, dataEntity);
        this.propertyChangedZxxxEntry(e, dataEntity);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        if (entryName.equals("yem_materialentry")) {
            PurdeliverBillPlugin.calculateTotalyqty(model);
        }
    }

    private void enableQty(DynamicObjectCollection materialentry, DynamicObject dataEntity) {
        int rowCount = materialentry.getRowCount();
        boolean result = (dataEntity.getString("billstatus").equals("A") || dataEntity.getString("billstatus").equals("B")) && !ShippUtil.isAllowfw();
        for (int i = 0; i < rowCount; ++i) {
            this.getView().setEnable(Boolean.valueOf(!result), i, new String[]{"yem_qty"});
        }
    }

    private void propertyChangedHead(PropertyChangedArgs e) {
        IDataModel model = this.getModel();
        switch (e.getProperty().getName()) {
            case "yem_warehouse": {
                PurdeliverBillPlugin.autoWarehouseInfo(model);
                break;
            }
            case "yem_qty": {
                PurdeliverBillPlugin.calculateTotalyqty(model);
            }
        }
    }

    private void propertyChangedSpxxEntry(PropertyChangedArgs e) {
        String key = e.getProperty().getName();
        DynamicObjectCollection spxx = this.getModel().getDataEntity().getDynamicObjectCollection("yem_materialentry");
        IDataModel model = this.getModel();
        DynamicObject fromcurr = (DynamicObject)model.getValue("yem_fromcurr");
        long id = null != fromcurr ? fromcurr.getLong("id") : 0L;
        Map precision = CalculationToolUtil.precision((Long)id);
        if ("yem_qty".equals(key) || "yem_pieceqty".equals(key)) {
            for (DynamicObject spxxent : spxx) {
                model.setValue("yem_piece", (Object)CalculationToolUtil.handleBoxPieceCalculation((DynamicObject)spxxent, (String)"yem_qty", (String)"yem_pieceqty"), spxx.indexOf((Object)spxxent));
            }
        }
        if ("yem_qty".equals(key) || "yem_grossweight".equals(key)) {
            for (DynamicObject spxxent : spxx) {
                model.setValue("yem_grossweightsum", (Object)CalculationToolUtil.handleBoxWeightSumCalculation((DynamicObject)spxxent, (String)"yem_qty", (String)"yem_grossweight"), spxx.indexOf((Object)spxxent));
            }
        }
        if ("yem_qty".equals(key) || "yem_netweight".equals(key)) {
            for (DynamicObject spxxent : spxx) {
                model.setValue("yem_netweightsum", (Object)CalculationToolUtil.handleBoxWeightSumCalculation((DynamicObject)spxxent, (String)"yem_qty", (String)"yem_netweight"), spxx.indexOf((Object)spxxent));
            }
        }
        if ("yem_long".equals(key) || "yem_wide".equals(key) || "yem_high".equals(key) || "yem_qty".equals(key) || "yem_lenghtunitid".equals(key)) {
            DynamicObject munit = BusinessDataServiceHelper.loadSingle((String)"bd_measureunits", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"m")});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("qty", "yem_qty");
            map.put("long", "yem_long");
            map.put("weide", "yem_wide");
            map.put("high", "yem_high");
            map.put("lenghtunitid", "yem_lenghtunitid");
            map.put("material", "yem_material");
            map.put("vol", "yem_vol");
            map.put("volm3", "yem_volm3");
            map.put("totalvolm3", "yem_volm3sum");
            for (DynamicObject spxxent : spxx) {
                Map result = CalculationToolUtil.handleBoxVolumeCalculation((DynamicObject)spxxent, map, (DynamicObject)munit);
                model.setValue("yem_vol", result.get("vol"), spxx.indexOf((Object)spxxent));
                model.setValue("yem_volm3", result.get("volm3"), spxx.indexOf((Object)spxxent));
                model.setValue("yem_volm3sum", result.get("totalvolm3"), spxx.indexOf((Object)spxxent));
            }
        }
        if ("yem_hscodeid".equals(key) || "yem_amttax".equals(key) || "yem_degrate".equals(key)) {
            this.autoHsDegrate(e, precision);
        }
    }

    private void propertyChangedCgxxEntry(PropertyChangedArgs e, DynamicObject dataEntity) {
        DynamicObjectCollection cgxxEntry = dataEntity.getDynamicObjectCollection("yem_fwg_cytd_cgxx");
        switch (e.getProperty().getName()) {
            case "yem_purchqty": 
            case "yem_purchpricetax": {
                this.amountCalculationLogic(e, cgxxEntry);
                break;
            }
            case "yem_purtaxrateid": {
                this.carryPurchaseTaxRate(e);
                break;
            }
            case "yem_taxrefundrate": {
                this.calculateTaxrefund(e, cgxxEntry);
                break;
            }
            case "yem_provider": {
                this.clearRowField(e, cgxxEntry);
            }
        }
    }

    private void carryPurchaseTaxRate(PropertyChangedArgs e) {
        DynamicObject purtaxrateid = (DynamicObject)e.getChangeSet()[0].getNewValue();
        purtaxrateid = BusinessDataServiceHelper.loadSingle((Object)purtaxrateid.getPkValue(), (String)purtaxrateid.getDynamicObjectType().getName());
        this.getModel().setValue("yem_vatrate", (Object)purtaxrateid.getBigDecimal("taxrate"));
    }

    private void amountCalculationLogic(PropertyChangedArgs e, DynamicObjectCollection cgxxEntry) {
        IDataModel model = this.getModel();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject cgxxRow = (DynamicObject)cgxxEntry.get(rowIndex);
        Map precision = CalculationToolUtil.precision((Long)cgxxRow.getLong("yem_purchasingcur.id"));
        Integer amtprecision = 5;
        Integer priceprecision = 5;
        if (precision != null) {
            amtprecision = precision.getOrDefault("amtprecision", 5);
            priceprecision = precision.getOrDefault("priceprecision", 5);
        }
        BigDecimal purchqty = cgxxRow.getBigDecimal("yem_purchqty");
        BigDecimal purchpricetax = cgxxRow.getBigDecimal("yem_purchpricetax");
        BigDecimal vatrate = cgxxRow.getBigDecimal("yem_vatrate");
        if (purchqty == null || purchpricetax == null || vatrate == null) {
            return;
        }
        AmountModel calculate = AmtUtil.calculate((boolean)true, (boolean)false, (BigDecimal)purchqty, (BigDecimal)BigDecimal.ZERO, (BigDecimal)purchpricetax, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)vatrate, (int)0, (int)priceprecision, (int)amtprecision);
        model.setValue("yem_purchpriceuntax", (Object)calculate.getPrice(), rowIndex);
        model.setValue("yem_purchamuntax", (Object)calculate.getAmt(), rowIndex);
        model.setValue("yem_purchamtax", (Object)calculate.getTaxAmt(), rowIndex);
        model.setValue("yem_vatamt", (Object)calculate.getTax(), rowIndex);
    }

    private void propertyChangedZxxxEntry(PropertyChangedArgs e, DynamicObject dataEntity) {
        String key = e.getProperty().getName();
        DynamicObjectCollection zxxx = dataEntity.getDynamicObjectCollection("yem_fwg_cytd_zxxx");
        IDataModel model = this.getModel();
        if ("yem_boxgoodsqty".equals(key) || "yem_boxpieceqty".equals(key)) {
            for (DynamicObject zxxxent : zxxx) {
                model.setValue("yem_boxpiece", (Object)CalculationToolUtil.handleBoxPieceCalculation((DynamicObject)zxxxent, (String)"yem_boxgoodsqty", (String)"yem_boxpieceqty"), zxxx.indexOf((Object)zxxxent));
            }
        }
        if ("yem_boxgoodsqty".equals(key) || "yem_boxgoodsgweight".equals(key)) {
            for (DynamicObject zxxxent : zxxx) {
                model.setValue("yem_boxweightsum", (Object)CalculationToolUtil.handleBoxWeightSumCalculation((DynamicObject)zxxxent, (String)"yem_boxgoodsqty", (String)"yem_boxgoodsgweight"), zxxx.indexOf((Object)zxxxent));
            }
        }
        if ("yem_boxgoodsqty".equals(key) || "yem_boxgoodsnweight".equals(key)) {
            for (DynamicObject zxxxent : zxxx) {
                model.setValue("yem_boxnetweightsum", (Object)CalculationToolUtil.handleBoxWeightSumCalculation((DynamicObject)zxxxent, (String)"yem_boxgoodsqty", (String)"yem_boxgoodsnweight"), zxxx.indexOf((Object)zxxxent));
            }
        }
        if ("yem_boxlong".equals(key) || "yem_boxwide".equals(key) || "yem_boxhigh".equals(key) || "yem_boxgoodsqty".equals(key) || "yem_boxlenghtunitid".equals(key)) {
            DynamicObject munit = BusinessDataServiceHelper.loadSingle((String)"bd_measureunits", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"m")});
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("qty", "yem_boxgoodsqty");
            map.put("long", "yem_boxlong");
            map.put("weide", "yem_boxwide");
            map.put("high", "yem_boxhigh");
            map.put("lenghtunitid", "yem_boxlenghtunitid");
            map.put("material", "yem_boxgoodsid");
            map.put("vol", "yem_boxgoodsvol");
            map.put("volm3", "yem_boxsinglevol");
            map.put("totalvolm3", "yem_fboxpeicevol");
            for (DynamicObject zxxxent : zxxx) {
                Map result = CalculationToolUtil.handleBoxVolumeCalculation((DynamicObject)zxxxent, map, (DynamicObject)munit);
                model.setValue("yem_boxgoodsvol", result.get("vol"), zxxx.indexOf((Object)zxxxent));
                model.setValue("yem_boxsinglevol", result.get("volm3"), zxxx.indexOf((Object)zxxxent));
                model.setValue("yem_fboxpeicevol", result.get("totalvolm3"), zxxx.indexOf((Object)zxxxent));
            }
        }
    }

    public void dialogbox(String dynamicform, String button) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(dynamicform);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billno", this.getModel().getValue("yem_salebillno"));
        showParameter.setCustomParams(map);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, button));
        this.getView().showForm(showParameter);
    }

    private void autoHsDegrate(PropertyChangedArgs e, Map<String, Integer> precision) {
        ChangeData change = e.getChangeSet()[0];
        int rowIndex = change.getRowIndex();
        IDataModel model = this.getModel();
        DynamicObject hscodeid = (DynamicObject)model.getValue("yem_hscodeid");
        if (YEM.isEmpty((Object)hscodeid)) {
            model.setValue("yem_degrate", null, rowIndex);
            return;
        }
        DynamicObject hscode = BusinessDataServiceHelper.loadSingle((String)"yem_bd_hscode", (QFilter[])new QFilter[]{new QFilter("id", "=", hscodeid.get("id"))});
        BigDecimal rebateRate = hscode != null ? hscode.getBigDecimal("yem_rebaterate") : BigDecimal.ZERO;
        BigDecimal vatRate = hscode != null ? hscode.getBigDecimal("yem_vatrate") : BigDecimal.ZERO;
        model.setValue("yem_degrate", (Object)rebateRate, rowIndex);
        BigDecimal taxInclusiveAmount = (BigDecimal)model.getValue("yem_amttax");
        if (taxInclusiveAmount == null) {
            model.setValue("yem_degamt", null, rowIndex);
            return;
        }
        BigDecimal vatRatePercent = vatRate.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
        BigDecimal rebateRatePercent = rebateRate.divide(BigDecimal.valueOf(100L), 10, RoundingMode.HALF_UP);
        BigDecimal denominator = vatRatePercent.add(BigDecimal.ONE);
        Integer decimalPrecision = precision.get("amtprecision");
        if (decimalPrecision == null) {
            model.setValue("yem_degamt", null, rowIndex);
            return;
        }
        BigDecimal taxRefundAmount = taxInclusiveAmount.multiply(rebateRatePercent).divide(denominator, (int)decimalPrecision, RoundingMode.HALF_UP);
        model.setValue("yem_degamt", (Object)taxRefundAmount);
    }

    private void calculateTaxrefund(PropertyChangedArgs e, DynamicObjectCollection cgxxEntry) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject cgxxRow = (DynamicObject)cgxxEntry.get(rowIndex);
        Map precision = CalculationToolUtil.precision((Long)cgxxRow.getLong("yem_purchasingcur.id"));
        Integer amtprecision = 5;
        Integer priceprecision = 5;
        if (precision != null) {
            amtprecision = precision.getOrDefault("amtprecision", 5);
            priceprecision = precision.getOrDefault("priceprecision", 5);
        }
        this.getModel().setValue("yem_taxrefund", (Object)CalculationToolUtil.calculateTaxrefund((DynamicObject)cgxxRow, (String)"yem_purchamtax", (String)"yem_taxrefundrate", (String)"yem_vatrate", (int)amtprecision, (int)priceprecision), rowIndex);
    }

    private void clearRowField(PropertyChangedArgs e, DynamicObjectCollection cgxxEntry) {
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        DynamicObject cgxxRow = (DynamicObject)cgxxEntry.get(rowIndex);
        Object provider = cgxxRow.get("yem_provider");
        DynamicObjectType dynamicObjectType = cgxxRow.getDynamicObjectType();
        DynamicObject dynamicObject = new DynamicObject(dynamicObjectType);
        dynamicObject.set("yem_provider", provider);
        cgxxEntry.set(rowIndex, (Object)dynamicObject);
        this.getModel().setValue("yem_fwg_cytd_cgxx", (Object)cgxxEntry);
        this.getView().updateView();
    }
}

