/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.fwb.trade.bill.purdeliver.form;

import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class PurdeliverBillPlugin
extends AbstractBillPlugIn {
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String key = e.getProperty().getName();
        this.propertyChangedHead(key, model);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        String entryName = e.getEntryProp().getName();
        IDataModel model = this.getModel();
        switch (entryName) {
            case "yem_materialentry": {
                PurdeliverBillPlugin.calculateTotalyqty(model);
            }
        }
    }

    private void propertyChangedHead(String key, IDataModel model) {
        switch (key) {
            case "yem_warehouses": {
                PurdeliverBillPlugin.autoWarehouseInfo(model);
                break;
            }
            case "yem_qty": {
                PurdeliverBillPlugin.calculateTotalyqty(model);
            }
        }
    }

    public static void calculateTotalyqty(IDataModel model) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObjectCollection materialentry = dataEntity.getDynamicObjectCollection("yem_materialentry");
        BigDecimal totalqty = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : materialentry) {
            totalqty = totalqty.add(dynamicObject.getBigDecimal("yem_qty"));
        }
        model.setValue("yem_totalqty", (Object)totalqty);
    }

    public static void autoWarehouseInfo(IDataModel model) {
        DynamicObject warehouse = (DynamicObject)model.getValue("yem_warehouses");
        if (Objects.isNull(warehouse)) {
            model.setValue("yem_warehouseaddress", null);
            model.setValue("yem_warehouselinkman", null);
            model.setValue("yem_warehousetel", null);
            return;
        }
        DynamicObject warehouseDetail = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)"address, detailaddress, principal, telephone", (QFilter[])new QFilter("id", "=", warehouse.get("id")).toArray())[0];
        model.setValue("yem_warehouseaddress", (Object)(warehouseDetail.getString("address") + warehouseDetail.getString("detailaddress")));
        model.setValue("yem_warehouselinkman", Objects.nonNull(warehouseDetail.getDynamicObject("principal")) ? warehouseDetail.getDynamicObject("principal").getString("name") : null);
        model.setValue("yem_warehousetel", (Object)warehouseDetail.getString("telephone"));
    }
}

