/*
 * Decompiled with CFR 0.152.
 */
package kd.studio.login;

import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.login.thirdauth.ThirdSSOAuthHandler;
import kd.bos.login.thirdauth.UserAuthResult;
import kd.bos.login.thirdauth.UserProperType;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.cache.AdminUserCache;
import kd.bos.permission.cache.UserAppCache;
import kd.bos.permission.cache.UserMenuCache;
import kd.bos.permission.model.UserParam;
import kd.bos.sec.user.utils.UserOperationUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.url.UrlService;
import kd.bos.util.RevProxyUtil;
import kd.studio.util.HttpUtils;
import kd.studio.util.RsaUtils;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSOLoginPlugin
implements ThirdSSOAuthHandler {
    private Logger log = LoggerFactory.getLogger(SSOLoginPlugin.class);
    private String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCx3NLDPwgFZUSgBfLZXMpJcwQodLP4dTL/DzkUUFkYcTjfHx0xbxwGA57jD0p/n8L/sZivLhUdOQUIUla7kTK0Ygc/rtWFJ+LHLu88hU4DICI2m2iGF04MRmJJ4+TdppYYEM8Hl+HMYcqKOq/5sVFjoGL+xeHmxHRfHNRwOFHjaQIDAQAB";

    public void callTrdSSOLogin(HttpServletRequest request, HttpServletResponse response, String params) {
        String loginUrl = UrlService.getDomainContextUrl();
        try {
            if (!response.isCommitted()) {
                response.sendRedirect(String.valueOf(loginUrl) + "/login.html");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UserAuthResult getTrdSSOAuth(HttpServletRequest request, HttpServletResponse response) {
        String accessToken = request.getParameter("accessToken");
        String serverDomain = request.getParameter("serverDomain");
        UserAuthResult userAuthResult = new UserAuthResult();
        userAuthResult.setSucess(false);
        if (StringUtils.isEmpty((CharSequence)accessToken) || StringUtils.isEmpty((CharSequence)serverDomain)) {
            return userAuthResult;
        }
        try {
            String dataDes = RsaUtils.publicDecrypt(accessToken, this.publicKey);
            boolean hasRright = this.checkCosmic(dataDes);
            if (hasRright) {
                JSONObject data;
                boolean create;
                accessToken = URLEncoder.encode(RsaUtils.publicEncrypt(dataDes, this.publicKey), "utf-8");
                String url = String.format("%s%s?token=%s", serverDomain, "/studio/environment/ssouser", accessToken);
                String result = HttpUtils.post(url, "");
                JSONObject json = JSONObject.fromObject((Object)result);
                int code = json.getInt("code");
                if (code == 200 && (create = this.createUser(request, data = json.getJSONObject("data")))) {
                    userAuthResult.setUserType(UserProperType.Mobile);
                    userAuthResult.setUser((Object)data.getString("phone"));
                    userAuthResult.setSucess(true);
                }
            } else {
                userAuthResult.setErrDesc("\u670d\u52a1\u7aef\u53e3\u4e0d\u4e00\u81f4\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            userAuthResult.setSucess(false);
            userAuthResult.setErrDesc("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\uff01");
            try {
                response.sendRedirect(UrlService.getDomainContextUrl());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return userAuthResult;
    }

    private boolean checkCosmic(String dataDes) throws Exception {
        String cosmicPort = dataDes.split("_")[2];
        String domain = System.getProperty("domain.contextUrl");
        URL url = new URL(domain);
        int port = url.getPort();
        return port == Integer.valueOf(cosmicPort);
    }

    private boolean createUser(HttpServletRequest request, JSONObject userInfo) {
        String phone = userInfo.getString("phone");
        String email = userInfo.getString("email");
        String nickname = userInfo.getString("nickname");
        String avatar = userInfo.getString("avatar");
        String accountId = request.getParameter("accountId");
        String tenantId = RevProxyUtil.getTenantId((HttpServletRequest)request);
        Account account = AccountUtils.getCorrectAccount((String)accountId, (String)tenantId);
        RequestContext rc = RequestContext.getOrCreate();
        if (StringUtils.isEmpty((CharSequence)rc.getAccountId())) {
            rc.setAccountId(account.getAccountId());
        }
        if (StringUtils.isEmpty((CharSequence)rc.getTenantId())) {
            rc.setTenantId(tenantId);
        }
        UserRunnable runable = new UserRunnable(nickname, phone, email, avatar);
        ThreadPools.executeOnceIncludeRequestContext((String)"createUser", (Runnable)runable);
        int x = 0;
        while (x < 10) {
            if (runable.getUpdateFlag()) {
                return true;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException arg14) {
                arg14.printStackTrace();
            }
            ++x;
        }
        return false;
    }

    private class UserRunnable
    implements Runnable {
        private String phone;
        private String email;
        private String userName;
        private String avatar;
        private boolean updateFlag = false;

        public UserRunnable(String userName, String phone, String email, String avatar) {
            this.phone = phone;
            this.email = email;
            this.userName = userName;
            this.avatar = avatar;
        }

        @Override
        public void run() {
            try {
                this.addUser();
            }
            catch (Exception e) {
                SSOLoginPlugin.this.log.error("\u521b\u5efa\u7528\u6237{}\u5931\u8d25\uff01", (Object)this.userName, (Object)e);
            }
        }

        private void addUser() {
            long userId = -1L;
            DynamicObject user = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("phone", "=", (Object)this.phone), new QFilter("usertype", "=", (Object)"1")});
            if (user == null) {
                SSOLoginPlugin.this.log.info("\u7528\u6237{}\u4e0d\u5b58\u5728\uff0c\u6267\u884c\u521b\u5efa\u7528\u6237\uff01", (Object)this.userName);
                userId = DB.genLongId((String)"bos_user");
                String fullPinyin = UserOperationUtils.getFullSpellByName((String)this.userName);
                ArrayList<UserParam> userParamList = new ArrayList<UserParam>(1);
                UserParam userParam = new UserParam();
                HashMap<String, Object> dataMap = new HashMap<String, Object>(16);
                userParam.setDataMap(dataMap);
                userParamList.add(userParam);
                String username = UserOperationUtils.getUserNameByFormatedFullPinyin((long)userId, (String)fullPinyin, null);
                dataMap.put("id", userId);
                dataMap.put("name", this.userName);
                dataMap.put("username", username);
                dataMap.put("usertype", "1");
                dataMap.put("phone", this.phone);
                dataMap.put("email", this.email);
                dataMap.put("picturefield", this.avatar);
                ArrayList entityDeptList = new ArrayList(1);
                HashMap<String, Object> deptMap = new HashMap<String, Object>();
                deptMap.put("dpt", "100000");
                deptMap.put("position", "\u5f00\u53d1\u5de5\u7a0b\u5e08");
                deptMap.put("isincharge", false);
                deptMap.put("ispartjob", false);
                deptMap.put("seq", "1");
                dataMap.put("entryentity", entityDeptList);
                RequestContext rc = RequestContext.getOrCreate();
                if (rc.getUserId() == null) {
                    rc.setUserId(String.valueOf(userId));
                }
                UserServiceHelper.add(userParamList);
                for (UserParam userMap : userParamList) {
                    if (!userMap.isSuccess()) {
                        SSOLoginPlugin.this.log.error("\u7528\u6237{}-{}\u521b\u5efa\u5931\u8d25\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a{}", new Object[]{this.userName, this.phone, userMap.getMsg()});
                        continue;
                    }
                    this.updateFlag = true;
                    DynamicObject superUser = BusinessDataServiceHelper.newDynamicObject((String)"perm_superuser");
                    superUser.set("user", (Object)userId);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{superUser});
                    this.addAdmin(userId);
                    this.addLic(userId);
                }
            } else {
                userId = user.getLong("id");
                DynamicObject[] lics = BusinessDataServiceHelper.load((String)"lic_userlicensegroup", (String)"id", (QFilter[])new QFilter[]{new QFilter("user", "=", (Object)userId)});
                if (lics == null || lics.length == 0) {
                    this.addLic(userId);
                }
            }
            this.updateFlag = true;
        }

        public void addAdmin(long userId) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"perm_admin");
            DynamicObject dot = BusinessDataServiceHelper.newDynamicObject((String)"perm_admin");
            String adminId = DB.genStringId((String)"perm_admin");
            dot.set("id", (Object)adminId);
            dot.set("number", (Object)adminId);
            dot.set("masterid", (Object)adminId);
            dot.set("parent", (Object)"1");
            dot.set("user", (Object)userId);
            dot.set("type", (Object)"20");
            dot.set("level", (Object)1);
            dot.set("enable", (Object)"1");
            dot.set("admintype", (Object)"1");
            dot.set("status", (Object)"C");
            dot.set("longnumber", (Object)".");
            dot.set("fullname", (Object)"null.null");
            dot.set("isleaf", (Object)Boolean.TRUE);
            dot.set("createtime", (Object)TimeServiceHelper.now());
            DynamicObjectCollection orgs = dot.getDynamicObjectCollection("bizlist");
            DynamicObjectType orgsType = orgs.getDynamicObjectType();
            orgs.clear();
            DynamicObject newOrg = new DynamicObject(orgsType);
            newOrg.set("biznumber", (Object)"100000");
            orgs.add((Object)newOrg);
            SaveServiceHelper.save((IDataEntityType)entityType, (Object[])new DynamicObject[]{dot});
            UserAppCache.removeCache((Long)userId);
            UserMenuCache.removeCache((Long)userId);
            AdminUserCache.removeAllCache();
        }

        public void addLic(Long userId) {
            ArrayList<Long> userIds = new ArrayList<Long>(1);
            userIds.add(userId);
            DynamicObject[] lics = BusinessDataServiceHelper.load((String)"lic_license", (String)"id,lic_licensedetail.group", (QFilter[])new QFilter[]{new QFilter("group.type", "=", (Object)"1"), new QFilter("lic_licensedetail.remaincount", ">", (Object)0)});
            if (lics != null && lics.length == 1) {
                DynamicObject lic = lics[0];
                DynamicObjectCollection collection = lic.getDynamicObjectCollection("lic_licensedetail");
                if (collection != null && collection.size() > 0) {
                    int x = 0;
                    while (x < collection.size()) {
                        DynamicObject licDetail = ((DynamicObject)collection.get(x)).getDynamicObject("group");
                        SSOLoginPlugin.this.log.info("\u7528\u6237{}\u5206\u914d\u8bb8\u53ef{}", (Object)this.userName, (Object)licDetail.getString("name"));
                        LicenseServiceHelper.addUserListByGroupId((Object)licDetail.getPkValue(), userIds);
                        ++x;
                    }
                    LicenseServiceHelper.reLoadLicenseCache();
                }
            } else {
                SSOLoginPlugin.this.log.error("\u7528\u6237{}\u83b7\u53d6\u4e0d\u5230\u53ef\u7528\u8bb8\u53ef", (Object)this.userName);
            }
        }

        public boolean getUpdateFlag() {
            return this.updateFlag;
        }
    }
}

