/*
 * Decompiled with CFR 0.152.
 */
package kd.studio.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import kd.studio.util.HttpDelete;
import kd.studio.util.HttpGet;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpUtils {
    private static CloseableHttpClient httpClient;
    private static RequestConfig requestConfig;

    static {
        requestConfig = RequestConfig.custom().setSocketTimeout(100000).setConnectTimeout(100000).setConnectionRequestTimeout(100000).build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager();
        connManager.setMaxTotal(300);
        connManager.setDefaultMaxPerRoute(300);
        httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).build();
    }

    public static String get(String url) throws IOException {
        org.apache.http.client.methods.HttpGet httpget = new org.apache.http.client.methods.HttpGet(url);
        httpget.setConfig(requestConfig);
        Throwable throwable = null;
        Object var3_4 = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);){
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String get(String url, int timeout) throws IOException {
        org.apache.http.client.methods.HttpGet httpget = new org.apache.http.client.methods.HttpGet(url);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
        httpget.setConfig(requestConfig);
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);){
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String getByUseEntity(String url, Map<String, Object> body) throws IOException, URISyntaxException {
        return HttpUtils.getByUseEntity(url, null, body);
    }

    public static String getByUseEntity(String url, Map<String, String> headers, Map<String, Object> body) throws IOException, URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(url);
        LinkedList<BasicNameValuePair> list = new LinkedList<BasicNameValuePair>();
        for (Map.Entry<String, Object> entry : body.entrySet()) {
            String mapKey = entry.getKey();
            Object mapValue = entry.getValue();
            BasicNameValuePair param1 = new BasicNameValuePair(mapKey, mapValue.toString());
            list.add(param1);
            System.out.println(String.valueOf(mapKey) + ":" + mapValue + ";String: " + mapValue.toString());
        }
        uriBuilder.setParameters(list);
        org.apache.http.client.methods.HttpGet httpget = new org.apache.http.client.methods.HttpGet(uriBuilder.build());
        System.out.println(uriBuilder.build());
        if (headers != null) {
            for (String type : headers.keySet()) {
                httpget.setHeader(type, HttpUtils.urlEncode(headers.get(type)));
            }
        }
        httpget.setConfig(requestConfig);
        Object object = null;
        Iterator<String> iterator = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);){
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    public static String post(String url, String json) throws IOException {
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        HttpPost httpPost = new HttpPost(url);
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setConfig(requestConfig);
        Throwable throwable = null;
        Object var5_6 = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String post(String url, String json, Map<String, String> headers, Boolean isEncode) throws IOException {
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        HttpPost httpPost = new HttpPost(url);
        if (headers != null) {
            for (String type : headers.keySet()) {
                httpPost.setHeader(type, isEncode != false ? HttpUtils.urlEncode(headers.get(type)) : headers.get(type));
            }
        }
        httpPost.setEntity((HttpEntity)entity);
        httpPost.setConfig(requestConfig);
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);){
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String httpGet(String url, Map<String, String> headers, Map<String, Object> params) throws ClientProtocolException, IOException {
        StringBuffer urlBuffer = new StringBuffer(url);
        boolean start = true;
        for (String key : params.keySet()) {
            if (start) {
                urlBuffer.append("?");
                start = false;
            } else {
                urlBuffer.append("&");
            }
            urlBuffer.append(key).append("=").append(params.get(key));
        }
        org.apache.http.client.methods.HttpGet httpget = new org.apache.http.client.methods.HttpGet(urlBuffer.toString());
        if (headers != null) {
            for (String type : headers.keySet()) {
                httpget.setHeader(type, HttpUtils.urlEncode(headers.get(type)));
            }
        }
        httpget.setConfig(requestConfig);
        Object object = null;
        Iterator<String> iterator = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpget);){
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }

    public static String request(String url, String method, Map<String, String> headers, Map<String, Object> params, Boolean isEncode) throws IOException {
        return HttpUtils.getRequest(url, method, headers, params, isEncode);
    }

    public static String request(String url, String method, Map<String, String> headers, Map<String, Object> params) throws IOException {
        return HttpUtils.getRequest(url, method, headers, params, true);
    }

    private static String getRequest(String url, String method, Map<String, String> headers, Map<String, Object> params, Boolean isEncode) throws IOException {
        Map<String, Object> result = HttpUtils.httpRequest(url, method, headers, params, isEncode);
        if (result == null) {
            return "";
        }
        return (String)result.get("data");
    }

    public static Map<String, Object> httpRequest(String url, String method, Map<String, String> headers, Map<String, Object> params, Boolean isEncode) throws IOException {
        Object httpReq = null;
        if ("POST".equals(method)) {
            httpReq = new HttpPost(url);
        } else if ("PUT".equals(method)) {
            httpReq = new HttpPut(url);
        } else if ("DELETE".equals(method)) {
            httpReq = new HttpDelete(url);
        } else if ("GET".equals(method)) {
            httpReq = new HttpGet(url);
        }
        if (headers != null) {
            for (String type : headers.keySet()) {
                httpReq.setHeader(type, isEncode != false ? HttpUtils.urlEncode(headers.get(type)) : headers.get(type));
            }
        }
        if (params != null) {
            ArrayList<BasicNameValuePair> nameList = new ArrayList<BasicNameValuePair>();
            for (String key : params.keySet()) {
                String value = String.valueOf(params.get(key));
                nameList.add(new BasicNameValuePair(key, value));
            }
            UrlEncodedFormEntity urlEntity = new UrlEncodedFormEntity(nameList, StandardCharsets.UTF_8);
            httpReq.setEntity((HttpEntity)urlEntity);
        }
        httpReq.setConfig(requestConfig);
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpReq);){
            int code = response.getStatusLine().getStatusCode();
            String data = response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8) : "";
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("code", code);
            result.put("data", data);
            return result;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String uploadFile(String url, Map<String, String> headers, Map<String, Object> params) throws ClientProtocolException, IOException {
        HttpPost httpReq = new HttpPost(url);
        if (headers != null) {
            for (String type : headers.keySet()) {
                httpReq.setHeader(type, HttpUtils.urlEncode(headers.get(type)));
            }
        }
        if (params != null) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (String key : params.keySet()) {
                Object value = params.get(key);
                if (value instanceof File) {
                    builder.addPart("file", (ContentBody)new FileBody((File)value));
                    continue;
                }
                builder.addTextBody(key, String.valueOf(value), ContentType.APPLICATION_FORM_URLENCODED);
            }
            httpReq.setEntity(builder.build());
        }
        httpReq.setConfig(requestConfig);
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpReq);){
            return EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String post(String url, Map<String, Object> body) throws IOException, URISyntaxException {
        return HttpUtils.getByUseEntity(url, body);
    }

    public static Map<String, String> getHttpRequestHeader() {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-type", "application/x-www-form-urlencoded;charset=UTF-8");
        return header;
    }

    public static String urlEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (Exception exception) {
            return str;
        }
    }

    public static Map<String, JSONObject> httpGetRequest(String urlPath, Map<String, String> header) throws IOException {
        Map res = null;
        String response = HttpUtils.get(urlPath);
        res = (Map)JSON.parse((String)response);
        return res;
    }

    public static Map<String, Object> httpPostRequest(String urlPath, Map<String, String> header, Map<String, Object> body) {
        Map res = null;
        try {
            String response = HttpUtils.post(urlPath, body);
            Object resObject = JSON.parse((String)response);
            res = (Map)resObject;
        }
        catch (IOException | URISyntaxException exception) {
            // empty catch block
        }
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Map<String, String> postNotEncode(String url, Map<String, String> header) throws ParseException, IOException {
        HashMap<String, String> result = new HashMap<String, String>(2);
        HttpPost post = new HttpPost(url);
        if (header != null) {
            for (String key : header.keySet()) {
                post.setHeader(key, header.get(key));
            }
        }
        post.setConfig(requestConfig);
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try {
            CloseableHttpClient httpClient = HttpClients.custom().build();
            try {
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)post);){
                    int code = response.getStatusLine().getStatusCode();
                    result.put("status", String.valueOf(code));
                    HttpEntity entity = response.getEntity();
                    if (entity != null) {
                        result.put("msg", EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8));
                    }
                }
                if (httpClient == null) return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (httpClient == null) throw throwable;
                httpClient.close();
                throw throwable;
            }
            httpClient.close();
            return result;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getNotEncode(String url, Map<String, String> header) throws ParseException, IOException {
        org.apache.http.client.methods.HttpGet get = new org.apache.http.client.methods.HttpGet(url);
        if (header != null) {
            for (String key : header.keySet()) {
                get.setHeader(key, header.get(key));
            }
        }
        get.setConfig(requestConfig);
        HashMap<String, String> result = new HashMap<String, String>(2);
        Object object = null;
        Object var5_6 = null;
        try {
            CloseableHttpClient httpClient = HttpClients.custom().build();
            try {
                HashMap<String, String> hashMap;
                block17: {
                    CloseableHttpResponse response = httpClient.execute((HttpUriRequest)get);
                    try {
                        int code = response.getStatusLine().getStatusCode();
                        result.put("status", String.valueOf(code));
                        HttpEntity entity = response.getEntity();
                        if (entity != null) {
                            result.put("msg", EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8));
                        }
                        hashMap = result;
                        return hashMap;
                    }
                    finally {
                        if (response == null) break block17;
                        response.close();
                    }
                }
                if (httpClient != null) {
                    httpClient.close();
                }
                return hashMap;
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                } else if (object != throwable) {
                    ((Throwable)object).addSuppressed(throwable);
                }
                if (httpClient == null) throw object;
                httpClient.close();
                throw object;
            }
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
                throw object;
            }
            if (object == throwable) throw object;
            ((Throwable)object).addSuppressed(throwable);
            throw object;
        }
    }
}

