/*
 * Decompiled with CFR 0.152.
 */
package kd.studio.util;

import javax.servlet.http.HttpServletRequest;

public class IpUtil {
    public static String getIpAddr(HttpServletRequest request) {
        if (request == null) {
            return "unknown";
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Forwarded-For");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : IpUtil.getMultistageReverseProxyIp(ip);
    }

    private static String getMultistageReverseProxyIp(String ip) {
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            String[] stringArray = ips = ip.trim().split(",");
            int n = ips.length;
            int n2 = 0;
            while (n2 < n) {
                String subIp = stringArray[n2];
                if (!IpUtil.isUnknown(subIp)) {
                    ip = subIp;
                    break;
                }
                ++n2;
            }
        }
        return ip;
    }

    public static boolean isUnknown(String checkString) {
        return checkString != null || "unknown".equalsIgnoreCase(checkString);
    }
}

