/*
 * Decompiled with CFR 0.152.
 */
package kd.studio.util;

import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;

public class RsaUtils {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String KEY_ALGORITHM = "RSA";

    public static String publicDecrypt(String data, String publicKey) throws Exception {
        return RsaUtils.decrypt(data, RsaUtils.getPublicKey(publicKey));
    }

    private static String decrypt(String data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(2, key);
        byte[] dataBytes = Base64.decodeBase64((String)data);
        int inputLen = dataBytes.length;
        Throwable throwable = null;
        Object var6_7 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 128 ? cipher.doFinal(dataBytes, offset, 128) : cipher.doFinal(dataBytes, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            return new String(decryptedData, "UTF-8");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String publicEncrypt(String data, String publicKey) throws Exception {
        return RsaUtils.encrypt(data, RsaUtils.getPublicKey(publicKey));
    }

    private static String encrypt(String data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
        cipher.init(1, key);
        int inputLen = data.getBytes("UTF-8").length;
        Throwable throwable = null;
        Object var5_6 = null;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                byte[] cache = inputLen - offset > 117 ? cipher.doFinal(data.getBytes("UTF-8"), offset, 117) : cipher.doFinal(data.getBytes("UTF-8"), offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            return Base64.encodeBase64String((byte[])encryptedData);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static Key getPublicKey(String publicKey) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
        byte[] decodedKey = Base64.decodeBase64((byte[])publicKey.getBytes("UTF-8"));
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        return keyFactory.generatePublic(keySpec);
    }
}

