/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ts.taxrefund.bill.taxdeclare.dynamic;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Container;
import kd.bos.form.control.Button;
import kd.bos.form.control.Label;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import yem.base.common.utils.YEM;
import yem.wm.customs.common.utils.ComboItemUtils;
import yem.wm.ts.conmmon.webapi.constant.ChinaTaxLoginRoleEnum;
import yem.wm.ts.taxrefund.webapi.ApiCall;
import yem.wm.ts.taxrefund.webapi.declaration.taxlogin.ChinaTaxLoginReqVO;

public class ChinaTaxLoginFormPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Label label = (Label)this.getControl("yem_step");
        label.setText("\u767b\u5f55");
        this.setStep(null);
        this.hiddenByStep();
    }

    private void hiddenByStep() {
        IFormView view = this.getView();
        TextEdit account = (TextEdit)this.getControl("yem_account");
        TextEdit password = (TextEdit)this.getControl("yem_password");
        TextEdit smscode = (TextEdit)this.getControl("yem_smscode");
        ComboEdit role = (ComboEdit)this.getControl("yem_role");
        Container sms = (Container)this.getControl("yem_smsflex");
        Button sendcodeBtn = (Button)this.getControl("yem_sendcode");
        if (this.getStep() == null) {
            account.setMustInput(true);
            password.setMustInput(true);
            view.setVisible(Boolean.valueOf(false), new String[]{sms.getKey(), role.getKey()});
            return;
        }
        if ("1".equals(this.getStep())) {
            smscode.setMustInput(true);
            view.setEnable(Boolean.valueOf(false), new String[]{account.getKey(), password.getKey()});
            view.setVisible(Boolean.valueOf(true), new String[]{sms.getKey()});
            return;
        }
        if ("2".equals(this.getStep())) {
            role.setMustInput(true);
            view.setVisible(Boolean.valueOf(true), new String[]{role.getKey()});
            view.setEnable(Boolean.valueOf(false), new String[]{sms.getKey(), sendcodeBtn.getKey()});
            return;
        }
    }

    private void updateStep(String step) {
        Label label = (Label)this.getControl("yem_step");
        switch (step) {
            case "0": {
                label.setText("\u767b\u5f55\u6210\u529f\uff01");
                break;
            }
            case "1": {
                label.setText("\u8bf7\u8f93\u5165\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff01");
                break;
            }
            case "2": {
                label.setText("\u8bf7\u9009\u62e9\u8d23\u4efb\u4eba\uff01");
                break;
            }
        }
        this.setStep(step);
        this.hiddenByStep();
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("tr_sendsms");
        String operateKey = e.getOperateKey();
        IFormView view = this.getView();
        if ("exec".equals(operateKey)) {
            JSONObject response = null;
            try {
                response = ApiCall.chinaTaxLogin(this.collectFormData(), this.getStep());
            }
            catch (Exception ex) {
                throw new KDBizException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a" + ex.getMessage());
            }
            if (response.containsKey((Object)"stepCode")) {
                this.updateStep(response.getString("stepCode"));
            } else if (response.containsKey((Object)"code")) {
                String code = response.getString("code");
                if (response.containsKey((Object)"message")) {
                    String message = response.getString("message");
                    view.showErrorNotification("\u767b\u5f55\u5931\u8d25\uff1a" + code + " " + message);
                    return;
                }
            }
            if ("0".equals(this.getStep())) {
                view.showSuccessNotification("\u767b\u5f55\u6210\u529f\uff01");
                view.close();
            }
            if ("2".equals(this.getStep()) && response.containsKey((Object)"relation")) {
                String relationStr = response.getString("relation");
                HashSet<String> codeSet = new HashSet<String>();
                JSONArray jsonArray = JSON.parseArray((String)relationStr);
                for (int i = 0; i < jsonArray.size(); ++i) {
                    JSONObject jsonObject = jsonArray.getJSONObject(i);
                    String role = jsonObject.getString("zrrlx");
                    if (role == null) continue;
                    codeSet.add(role);
                }
                Map<String, String> map = ChinaTaxLoginRoleEnum.map();
                map = map.entrySet().stream().filter(entry -> codeSet.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
                ComboEdit role = (ComboEdit)this.getControl("yem_role");
                role.setComboItems(ComboItemUtils.buildEntryComboItems(map));
                view.showSuccessNotification("\u8bf7\u9009\u62e9\u8eab\u4efd\u7c7b\u578b\uff01");
            }
        }
        if ("send_code".equals(operateKey)) {
            JSONObject response;
            String sent = (String)cache.get("sent");
            if (YEM.isNotEmpty((Object)sent) && "1".equals(sent)) {
                view.showSuccessNotification("\u5df2\u53d1\u9001\uff0c60\u79d2\u4e4b\u540e\u53ef\u91cd\u65b0\u53d1\u9001\uff01");
                return;
            }
            this.updateStep("1");
            try {
                response = ApiCall.chinaTaxLogin(this.collectFormData(), this.getStep());
            }
            catch (Exception ex) {
                throw new KDBizException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a" + ex.getMessage());
            }
            if (response.containsKey((Object)"stepCode")) {
                this.updateStep(response.getString("stepCode"));
            }
            if ("3".equals(this.getStep())) {
                view.showSuccessNotification("\u5df2\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
                cache.put("sent", (Object)"1", 1, TimeUnit.MINUTES);
            }
        }
    }

    private ChinaTaxLoginReqVO collectFormData() {
        IDataModel model = this.getModel();
        String account = (String)model.getValue("yem_account");
        String password = (String)model.getValue("yem_password");
        String smscode = (String)model.getValue("yem_smscode");
        String role = (String)model.getValue("yem_role");
        return new ChinaTaxLoginReqVO(null, account, password, smscode, role, null);
    }

    private void setStep(String step) {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        cache.put("step", step);
    }

    private String getStep() {
        IFormView view = this.getView();
        IPageCache cache = view.getPageCache();
        return cache.get("step");
    }
}

