/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ts.taxrefund.bill.taxdeclare.dynamic;

import com.alibaba.fastjson.JSONObject;
import java.util.EventObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import yem.wm.ts.taxrefund.webapi.ApiCall;

public class ChinaTaxQrCodeLoginFormPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(ChinaTaxQrCodeLoginFormPlugin.class);

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        if (!this.checkIsLogin()) {
            this.refreshQrCode();
        } else {
            view.setVisible(Boolean.valueOf(true), new String[]{"yem_reloginflex"});
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_picture"});
        }
    }

    private void refreshQrCode() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String image = null;
        try {
            image = ApiCall.chinaTaxQrCodeLogin();
        }
        catch (Exception ex) {
            throw new KDBizException("\u83b7\u53d6\u767b\u5f55\u4e8c\u7ef4\u7801\u5931\u8d25\uff01");
        }
        model.setValue("yem_picture", (Object)image);
        view.setVisible(Boolean.valueOf(false), new String[]{"yem_reloginflex"});
        view.setVisible(Boolean.valueOf(true), new String[]{"yem_picture"});
        view.updateView("yem_picture");
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        IFormView view = this.getView();
        String operateKey = e.getOperateKey();
        if ("btnok".equals(operateKey)) {
            boolean isLogin;
            try {
                isLogin = ApiCall.checkLoginStatus();
            }
            catch (Exception ex) {
                throw new KDBizException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            if (isLogin) {
                view.showSuccessNotification("\u767b\u5f55\u6210\u529f\uff01");
                view.close();
            } else {
                view.showErrorNotification("\u672a\u767b\u5f55\uff01");
            }
        }
        if ("refresh".equals(operateKey)) {
            this.refreshQrCode();
            view.showSuccessNotification("\u4e8c\u7ef4\u7801\u5df2\u5237\u65b0\uff01");
        }
        if ("yem_relogin".equals(operateKey)) {
            view.setVisible(Boolean.valueOf(false), new String[]{"yem_reloginflex"});
            view.setVisible(Boolean.valueOf(true), new String[]{"yem_picture"});
            this.refreshQrCode();
        }
    }

    private boolean checkIsLogin() {
        JSONObject response = null;
        try {
            response = ApiCall.queryLoginStatus();
        }
        catch (Exception ex) {
            throw new KDBizException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
        }
        if (response.containsKey((Object)"code") && "0000".equals(response.getString("code"))) {
            return true;
        }
        return response.containsKey((Object)"login_type");
    }
}

