/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ts.taxrefund.bill.taxdeclare.from;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import yem.base.common.utils.YEM;
import yem.wm.customs.common.utils.AttachmentUtil;
import yem.wm.ts.conmmon.utils.api.DataRelationConvertUtil;
import yem.wm.ts.conmmon.webapi.constant.DeclarationTypeEnum;
import yem.wm.ts.taxrefund.webapi.ApiCall;
import yem.wm.ts.taxrefund.webapi.declaration.auditprohress.DeclarationAuditProgressRespVO;
import yem.wm.ts.taxrefund.webapi.declaration.datacheck.DeclarationDataCheckType;
import yem.wm.ts.taxrefund.webapi.declaration.filegen.DeclarationFileGenType;
import yem.wm.ts.taxrefund.webapi.declaration.status.DeclarationStatusRespVO;
import yem.wm.ts.taxrefund.webapi.declaration.taxrefund.TaxRefundRateQueryRespVO;

public class ExportTaxRebateBillPlugin
extends AbstractBillPlugIn {
    private static final Log log = LogFactory.getLog(ExportTaxRebateBillPlugin.class);

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        FormShowParameter parameter;
        super.afterDoOperation(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        String operateKey = e.getOperateKey();
        if ("yem_ckmx_datacheck".equals(operateKey)) {
            this.handleCheckDeclarationData(model, view, "yem_cktssb_ckmx", "yem_fstatus");
        }
        if ("yem_chmx_datacheck".equals(operateKey)) {
            this.handleCheckDeclarationData(model, view, "yem_cktssb_jhmx", "");
        }
        if ("yem_ckmx_genfile".equals(operateKey)) {
            this.handleGenerateReportFile(model, view);
        }
        if ("yem_ckmx_datapush".equals(operateKey)) {
            this.handlePushDeclarationData(model, view);
        }
        if ("yem_ckmx_taxlogin".equals(operateKey)) {
            parameter = new FormShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("yem_ts_chinataxlogin");
            parameter.setCustomParam("opType", (Object)operateKey);
            view.showForm(parameter);
        }
        if ("yem_ckmx_qrcodelogin".equals(operateKey)) {
            parameter = new FormShowParameter();
            parameter.setStatus(OperationStatus.ADDNEW);
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId("yem_ts_chinataxlogin_qr");
            parameter.setCustomParam("opType", (Object)operateKey);
            view.showForm(parameter);
        }
        if ("yem_ckmx_status".equals(operateKey)) {
            this.handleQueryDeclarationStatus(model, view);
        }
        if ("yem_ckmx_auditstatus".equals(operateKey)) {
            this.handleQueryDeclarationAuditStatus(model, view);
        }
        if ("yem_ckmx_querytaxrrate".equals(operateKey)) {
            this.handleQueryTaxRefundRate(model, view);
        }
    }

    private void handleCheckDeclarationData(IDataModel model, IFormView view, String entryId, String status) {
        DynamicObject d;
        EntryGrid entryControl = (EntryGrid)this.getControl(entryId);
        DynamicObject head = model.getDataEntity(true);
        DynamicObjectCollection entity = model.getEntryEntity(entryId);
        int[] rows = entryControl.getSelectRows();
        if (rows.length == 0) {
            view.showErrorNotification("\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\uff01");
            return;
        }
        DynamicObjectCollection relation = DataRelationConvertUtil.readFieldRelation((String)entryId);
        if (YEM.isEmpty((Object)relation)) {
            view.showErrorNotification("\u672a\u627e\u5230\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ef4\u62a4\u8be5\u5206\u5f55\u7684\u63a5\u53e3\u5b57\u6bb5\u4e2d\u95f4\u8868\uff01");
            return;
        }
        DeclarationDataCheckType type = null;
        if ("yem_cktssb_ckmx".equals(entryId)) {
            type = DeclarationDataCheckType.MTS_TSSB;
        }
        if ("yem_cktssb_jhmx".equals(entryId)) {
            type = DeclarationDataCheckType.MTS_TSJH;
        }
        if (type == null) {
            view.showErrorNotification("\u672a\u77e5\u5206\u5f55\u6807\u8bc6\uff01");
            return;
        }
        JSONArray array = new JSONArray();
        LinkedHashSet<Integer> passRow = new LinkedHashSet<Integer>();
        for (int row : rows) {
            d = (DynamicObject)entity.get(row);
            JSONObject convert = DataRelationConvertUtil.convertEntry2ApiObject((DynamicObject)head, (DynamicObjectCollection)relation, (DynamicObject)d);
            array.add((Object)convert);
            passRow.add(row);
        }
        JSONArray errors = new JSONArray();
        StringBuilder sb = new StringBuilder();
        try {
            errors = ApiCall.declarationDataCheck(array, type);
        }
        catch (Exception e) {
            sb.append(String.format("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", e.getMessage()));
        }
        for (Object error : errors) {
            JSONObject rowErr = (JSONObject)error;
            if (!rowErr.containsKey((Object)"index") || !rowErr.containsKey((Object)"error")) continue;
            Integer idx = rowErr.getInteger("index");
            JSONArray rowErrArr = rowErr.getJSONArray("error");
            int rowNo = rows[idx];
            passRow.remove(rowNo);
            sb.append(String.format("\u7b2c %s \u884c\u6570\u636e\u6821\u9a8c\u672a\u901a\u8fc7\uff0c\u9519\u8bef\uff1a\r\n", rowNo + 1));
            for (Object errMsg : rowErrArr) {
                sb.append(errMsg).append("\r\n");
            }
        }
        for (Integer row : passRow) {
            d = (DynamicObject)entity.get(row.intValue());
            d.set(status, (Object)"B");
        }
        if (sb.length() > 0) {
            view.showErrorNotification(sb.toString());
        }
        if (!passRow.isEmpty()) {
            view.showSuccessNotification(String.format("\u7b2c %s \u884c\u68c0\u67e5\u901a\u8fc7\uff0c\u672a\u53d1\u73b0\u9519\u8bef\uff01", Arrays.toString(passRow.stream().map(x -> x + 1).toArray(Integer[]::new))));
        }
        view.invokeOperation("save");
        view.invokeOperation("refresh");
    }

    private void handleGenerateReportFile(IDataModel model, IFormView view) {
        String importEntryId = "yem_cktssb_ckmx";
        String exportEntryId = "yem_cktssb_jhmx";
        EntryGrid importEntry = (EntryGrid)this.getControl("yem_cktssb_ckmx");
        DynamicObject head = model.getDataEntity(true);
        DynamicObjectCollection entity = model.getEntryEntity("yem_cktssb_ckmx");
        int[] rows = importEntry.getSelectRows();
        if (rows.length == 0) {
            view.showErrorNotification("\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\uff01");
            return;
        }
        DynamicObjectCollection importRelation = DataRelationConvertUtil.readFieldRelation((String)"yem_cktssb_ckmx");
        if (YEM.isEmpty((Object)importRelation)) {
            view.showErrorNotification("\u672a\u627e\u5230\u8fdb\u53e3\u660e\u7ec6\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ef4\u62a4\u8be5\u5206\u5f55\u7684\u63a5\u53e3\u5b57\u6bb5\u4e2d\u95f4\u8868\uff01");
            return;
        }
        DynamicObjectCollection exportRelation = DataRelationConvertUtil.readFieldRelation((String)"yem_cktssb_jhmx");
        if (YEM.isEmpty((Object)exportRelation)) {
            view.showErrorNotification("\u672a\u627e\u5230\u51fa\u8d27\u660e\u7ec6\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ef4\u62a4\u8be5\u5206\u5f55\u7684\u63a5\u53e3\u5b57\u6bb5\u4e2d\u95f4\u8868\uff01");
            return;
        }
        HashMap<String, JSONArray> data = new HashMap<String, JSONArray>();
        HashSet<String> relationNo = new HashSet<String>();
        JSONArray importData = new JSONArray();
        StringBuilder sb = new StringBuilder();
        for (int row : rows) {
            DynamicObject d = (DynamicObject)entity.get(row);
            String status = d.getString("yem_fstatus");
            if (!"B".equals(status)) {
                sb.append(String.format("\u7b2c %s \u884c\u672a\u68c0\u67e5\u901a\u8fc7\uff0c\u6216\u5df2\u751f\u6210\u7533\u62a5\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff01\r\n", row + 1));
            }
            relationNo.add(d.getString("yem_fglh"));
            JSONObject convert = DataRelationConvertUtil.convertEntry2ApiObject((DynamicObject)head, (DynamicObjectCollection)importRelation, (DynamicObject)d);
            importData.add((Object)convert);
        }
        if (sb.length() > 0) {
            view.showErrorNotification(sb.toString());
            return;
        }
        data.put(DeclarationFileGenType.MTS_TSSB.getCode(), importData);
        JSONArray exportData = new JSONArray();
        DynamicObjectCollection exportEntryData = model.getEntryEntity("yem_cktssb_jhmx");
        for (DynamicObject exdata : exportEntryData) {
            String fglhs = exdata.getString("yem_fglhs");
            if (!relationNo.contains(fglhs)) continue;
            JSONObject convert = DataRelationConvertUtil.convertEntry2ApiObject((DynamicObject)head, (DynamicObjectCollection)exportRelation, (DynamicObject)exdata);
            exportData.add((Object)convert);
        }
        data.put(DeclarationFileGenType.MTS_TSJH.getCode(), exportData);
        String fsbym = head.getString("yem_fsbym");
        String fsbpc = head.getString("yem_fsbpc");
        File file = null;
        try {
            file = ApiCall.declarationFileGen(DeclarationTypeEnum.WMSB.getCode(), fsbym, fsbpc, data);
        }
        catch (Exception e) {
            view.showErrorNotification(String.format("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", e.getMessage()));
        }
        DynamicObject attachment = null;
        if (file != null) {
            FormShowParameter fsp = view.getFormShowParameter();
            String appId = fsp.getAppId();
            try {
                attachment = AttachmentUtil.uploadAttachment((String)appId, (String)head.getDataEntityType().getName(), (String)head.getString("id"), (String)"attachmentpanel", (String)file.getName(), (String)file.getAbsolutePath());
            }
            catch (IOException e) {
                view.showErrorNotification(String.format("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", e.getMessage()));
            }
        }
        if (attachment != null) {
            String id = attachment.getString("id");
            for (int row : rows) {
                DynamicObject d = (DynamicObject)entity.get(row);
                d.set("yem_declardoc", (Object)id);
                d.set("yem_fstatus", (Object)"C");
            }
            view.invokeOperation("save");
            view.invokeOperation("refresh");
        }
    }

    private void handlePushDeclarationData(IDataModel model, IFormView view) {
        String entryId = "yem_cktssb_ckmx";
        EntryGrid entryControl = (EntryGrid)this.getControl("yem_cktssb_ckmx");
        DynamicObject head = model.getDataEntity(true);
        DynamicObjectCollection entity = model.getEntryEntity("yem_cktssb_ckmx");
        int[] rows = entryControl.getSelectRows();
        if (rows.length == 0) {
            view.showErrorNotification("\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\uff01");
            return;
        }
        DynamicObjectCollection relation = DataRelationConvertUtil.readFieldRelation((String)"yem_cktssb_ckmx");
        if (YEM.isEmpty((Object)relation)) {
            view.showErrorNotification("\u672a\u627e\u5230\u5bf9\u5e94\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u7ef4\u62a4\u8be5\u5206\u5f55\u7684\u63a5\u53e3\u5b57\u6bb5\u4e2d\u95f4\u8868\uff01");
            return;
        }
        StringBuilder sb = new StringBuilder();
        HashSet<String> fileIds = new HashSet<String>();
        for (int row : rows) {
            DynamicObject d = (DynamicObject)entity.get(row);
            String status = d.getString("yem_fstatus");
            String declardoc = d.getString("yem_declardoc");
            if (!"C".equals(status) || YEM.isEmpty((Object)declardoc)) {
                sb.append("\u7b2c %s \u884c\u6570\u636e\u4e3a\u627e\u5230\u7533\u62a5\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5\uff01\r\n");
            }
            fileIds.add(declardoc);
        }
        if (sb.length() > 0) {
            view.showErrorNotification(sb.toString());
            return;
        }
        if (fileIds.size() != 1) {
            view.showErrorNotification("\u53ea\u5141\u8bb8\u9009\u4e2d\u7533\u62a5\u6587\u4ef6\u76f8\u540c\u7684\u884c\uff01");
            return;
        }
        String fsbym = head.getString("yem_fsbym");
        String fsbpc = head.getString("yem_fsbpc");
        String flowId = null;
        try {
            flowId = ApiCall.declarationFilePush(fsbym, fsbpc, (String)fileIds.iterator().next());
        }
        catch (Exception e) {
            view.showErrorNotification("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (YEM.isNotEmpty((Object)flowId)) {
            for (int row : rows) {
                DynamicObject d = (DynamicObject)entity.get(row);
                d.set("yem_fstatus", (Object)"D");
                d.set("yem_lcslid", (Object)flowId);
            }
            view.invokeOperation("save");
            view.invokeOperation("refresh");
        }
    }

    private void handleQueryDeclarationStatus(IDataModel model, IFormView view) {
        int idx = model.getEntryCurrentRowIndex("yem_cktssb_ckmx");
        String flowId = (String)model.getValue("yem_lcslid", idx);
        if (YEM.isEmpty((Object)flowId)) {
            view.showErrorNotification("\u6240\u9009\u884c\u672a\u627e\u5230\u6709\u6548\u7684\u6d41\u7a0b\u5b9e\u4f8bID\uff01");
        }
        StringBuilder sb = new StringBuilder();
        try {
            List<DeclarationStatusRespVO> respVOS = ApiCall.declarationStatus(DeclarationTypeEnum.WMSB, flowId);
            for (DeclarationStatusRespVO respVO : respVOS) {
                String body = respVO.getBody();
                sb.append(body).append("\r\n");
            }
        }
        catch (Exception e) {
            throw new KDBizException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38" + e.getMessage());
        }
        view.showMessage(sb.toString());
    }

    private void handleQueryDeclarationAuditStatus(IDataModel model, IFormView view) {
        String date = (String)model.getValue("yem_fsbym");
        String no = (String)model.getValue("yem_fsbpc");
        if (YEM.isEmpty((Object)date) || YEM.isEmpty((Object)no)) {
            view.showErrorNotification("\u6240\u5c5e\u671f\u6216\u6279\u6b21\u53f7\u4f4d\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
        Object response = null;
        try {
            DeclarationAuditProgressRespVO declarationAuditProgressRespVO = ApiCall.declarationAuditStatus(date, no);
        }
        catch (Exception e) {
            view.showErrorNotification("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (YEM.isNotEmpty(response) && response.containsKey((Object)"activities")) {
            log.info(response.toJSONString());
        }
    }

    private void handleQueryTaxRefundRate(IDataModel model, IFormView view) {
        List<TaxRefundRateQueryRespVO> response;
        EntryGrid entryControl = (EntryGrid)this.getControl("yem_cktssb_ckmx");
        DynamicObjectCollection entity = model.getEntryEntity("yem_cktssb_ckmx");
        int[] rows = entryControl.getSelectRows();
        if (rows.length == 0) {
            view.showErrorNotification("\u8bf7\u9009\u62e9\u9700\u8981\u6267\u884c\u7684\u6570\u636e\uff01");
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int row : rows) {
            DynamicObject d = (DynamicObject)entity.get(row);
            String code = d.getString("yem_fcmcodes");
            sb.append(code).append(",");
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        try {
            response = ApiCall.queryTaxRefundRate(sb.toString(), null);
        }
        catch (Exception e) {
            throw new KDBizException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
        }
        Map<String, TaxRefundRateQueryRespVO> codeRateMap = response.stream().collect(Collectors.toMap(TaxRefundRateQueryRespVO::getCode, r -> r));
        int importEntryRowCount = model.getEntryRowCount("yem_cktssb_jhmx");
        for (int i = 0; i < importEntryRowCount; ++i) {
            String fcmcodes = (String)model.getValue("yem_fckspdms", i);
            if (!codeRateMap.containsKey(fcmcodes)) continue;
            TaxRefundRateQueryRespVO rate = codeRateMap.get(fcmcodes);
            model.setValue("yem_fzssl", (Object)rate.getLevyRate(), i);
            model.setValue("yem_ftsl", (Object)rate.getTaxRefundRate(), i);
        }
        view.updateView("yem_cktssb_jhmx");
    }
}

