/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ts.taxrefund.webapi;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import yem.base.common.utils.YEM;
import yem.wm.ts.conmmon.utils.api.ApiCallUtil;
import yem.wm.ts.conmmon.utils.api.ApiLogUtil;
import yem.wm.ts.conmmon.webapi.constant.DeclarationTypeEnum;
import yem.wm.ts.conmmon.webapi.constant.ErrorCodeEnum;
import yem.wm.ts.conmmon.webapi.constant.LoginMethodEnum;
import yem.wm.ts.conmmon.webapi.constant.RequestEntity;
import yem.wm.ts.taxrefund.webapi.declaration.auditprohress.DeclarationAuditProgressReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.auditprohress.DeclarationAuditProgressRespVO;
import yem.wm.ts.taxrefund.webapi.declaration.datacheck.DeclarationDataCheckReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.datacheck.DeclarationDataCheckType;
import yem.wm.ts.taxrefund.webapi.declaration.feedback.FeedBackDataQueryReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.filegen.DeclarationFileGenReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.filepush.DeclarationFilePushReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.register.CompanyRegisterReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.status.DeclarationStatusReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.status.DeclarationStatusRespVO;
import yem.wm.ts.taxrefund.webapi.declaration.taxlogin.ChinaTaxLoginReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.taxrefund.TaxRefundRateQueryReqVO;
import yem.wm.ts.taxrefund.webapi.declaration.taxrefund.TaxRefundRateQueryRespVO;

public class ApiCall {
    private static final Log log = LogFactory.getLog(ApiCall.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject execute(JSONObject originRequestContent, String url) throws Exception {
        Object decryptResponseContent;
        JSONObject originResponseContent;
        ApiLogUtil apiLog;
        block5: {
            block4: {
                JSONObject jSONObject;
                apiLog = new ApiLogUtil(url);
                RequestEntity cryptRequestContent = new RequestEntity(originRequestContent);
                HttpPost post = new HttpPost(url);
                post.setHeader("Content-Type", "application/json");
                post.setEntity((HttpEntity)new StringEntity(cryptRequestContent.jsonString(), StandardCharsets.UTF_8));
                apiLog.logRequest(originRequestContent.toJSONString(), cryptRequestContent.jsonString());
                originResponseContent = new JSONObject();
                decryptResponseContent = new Object();
                try {
                    originResponseContent = ApiCallUtil.doRequest((HttpUriRequest)post);
                    if (YEM.isEmpty((Object)decryptResponseContent)) {
                        ApiCallUtil.verifyStatusCode((JSONObject)originResponseContent, (boolean)ApiCall.isIgnore(url));
                    }
                    if (!((decryptResponseContent = ApiCallUtil.decryptResponseContent((JSONObject)originResponseContent)) instanceof JSONArray)) break block4;
                    JSONObject addExData = new JSONObject();
                    addExData.put("data", decryptResponseContent);
                    apiLog.logResponse(originResponseContent.toJSONString(), addExData.toJSONString());
                    jSONObject = addExData;
                }
                catch (Throwable throwable) {
                    apiLog.logResponse(originResponseContent.toJSONString(), YEM.isEmpty((Object)decryptResponseContent) ? "" : decryptResponseContent.toString());
                    throw throwable;
                }
                apiLog.logResponse(originResponseContent.toJSONString(), YEM.isEmpty((Object)decryptResponseContent) ? "" : decryptResponseContent.toString());
                return jSONObject;
            }
            if (!(decryptResponseContent instanceof JSONObject)) break block5;
            JSONObject content = (JSONObject)decryptResponseContent;
            apiLog.logResponse(originResponseContent.toJSONString(), content.toJSONString());
            JSONObject jSONObject = content;
            apiLog.logResponse(originResponseContent.toJSONString(), YEM.isEmpty((Object)decryptResponseContent) ? "" : decryptResponseContent.toString());
            return jSONObject;
        }
        apiLog.logResponse(originResponseContent.toJSONString(), YEM.isEmpty((Object)decryptResponseContent) ? "" : decryptResponseContent.toString());
        return new JSONObject();
    }

    private static boolean isIgnore(String url) {
        HashSet<String> set = new HashSet<String>();
        set.add("https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/dzswj-cxzt");
        int idx = url.lastIndexOf("/");
        String path = url.substring(idx, url.length() - 1);
        Iterator iterator = set.iterator();
        if (iterator.hasNext()) {
            String s = (String)iterator.next();
            return s.contains(path);
        }
        return false;
    }

    public static JSONArray declarationDataCheck(JSONArray data, DeclarationDataCheckType type) throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/ckts-jcsbsj";
        DeclarationDataCheckReqVO originRequestContent = new DeclarationDataCheckReqVO(type.getCode(), data);
        JSONObject response = ApiCall.execute(originRequestContent.jsonObject(), url);
        if (response.containsKey((Object)"errors")) {
            return response.getJSONArray("errors");
        }
        return new JSONArray();
    }

    public static File declarationFileGen(String declarationType, String date, String batch, Map<String, JSONArray> data) throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/ckts-scsbwj";
        DeclarationFileGenReqVO originRequestContent = new DeclarationFileGenReqVO(declarationType, date, batch, data);
        JSONObject response = ApiCall.execute(originRequestContent.jsonObject(), url);
        if (response.containsKey((Object)"sbwjData")) {
            response = response.getJSONObject("sbwjData");
        }
        if (response.containsKey((Object)"fileName") && response.containsKey((Object)"fileData")) {
            String fileName = response.getString("fileName");
            String fileData = response.getString("fileData");
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File outputFile = new File(tempDir, fileName);
            byte[] decodedBytes = Base64.getDecoder().decode(fileData);
            try (FileOutputStream fos = new FileOutputStream(outputFile);){
                fos.write(decodedBytes);
            }
            return outputFile;
        }
        throw new RuntimeException("\u54cd\u5e94\u4f53\u4e2d\u6ca1\u6709\u6709\u6548\u6570\u636e!");
    }

    public static String declarationFilePush(String date, String batch, String fileId) {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/ckts-bssbwj";
        AttachmentDto attDao = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)fileId);
        String fileUrl = attDao.getResourcePath();
        String filename = attDao.getFilename();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileServiceFactory.getAttachmentFileService().download(fileUrl, (OutputStream)out, null);
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        String base64 = null;
        try {
            base64 = ApiCallUtil.convertToBase64((InputStream)in);
        }
        catch (IOException e) {
            throw new RuntimeException("\u6587\u4ef6\u8fdb\u884cBase64\u7f16\u7801\u9519\u8bef\uff1a" + e.getMessage());
        }
        DeclarationFilePushReqVO originRequestContent = new DeclarationFilePushReqVO(DeclarationTypeEnum.WMSB, filename, base64);
        JSONObject response = null;
        try {
            response = ApiCall.execute(originRequestContent.jsonObject(), url);
        }
        catch (Exception e) {
            throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff1a" + e.getMessage());
        }
        if (response.containsKey((Object)"lcslid") && response.getString("lcslid") != null) {
            return response.getString("lcslid");
        }
        if (response.containsKey((Object)"code")) {
            String code = response.getString("code");
            if (response.containsKey((Object)"message")) {
                String message = response.getString("message");
                throw new RuntimeException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + code + message);
            }
            throw new RuntimeException("\u63a5\u53e3\u54cd\u5e94\u7801 " + code + ErrorCodeEnum.message((String)code));
        }
        throw new RuntimeException("\u63a5\u53e3\u54cd\u5e94\u4e2d\u672a\u53d1\u73b0\u6709\u6548\u6570\u636e\uff01");
    }

    public static JSONObject chinaTaxLogin(ChinaTaxLoginReqVO data, String step) throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/dzswj-kjdl";
        if (step == null) {
            step = "-1";
        }
        switch (step) {
            case "-1": {
                data.setStepName(LoginMethodEnum.LOGIN.getCode());
                break;
            }
            case "1": {
                data.setStepName(LoginMethodEnum.SEND_SMS.getCode());
                break;
            }
            case "2": {
                data.setStepName(LoginMethodEnum.SELECT_ROLE.getCode());
                break;
            }
            case "3": {
                data.setStepName(LoginMethodEnum.SMS_LOGIN.getCode());
            }
        }
        return ApiCall.execute(data.jsonObject(), url);
    }

    public static String chinaTaxQrCodeLogin() throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/dzswj-smdl";
        JSONObject data = new JSONObject();
        data.put("stepName", (Object)"create_qrcode");
        JSONObject response = ApiCall.execute(data, url);
        if (response.containsKey((Object)"qrImage")) {
            String qrImage = response.getString("qrImage");
            File file = ApiCall.convertBase64ToTempFile(qrImage);
            FileService imageFileService = FileServiceFactory.getImageFileService();
            FileItem fileItem = new FileItem(file.getAbsolutePath(), "/images/qrCodeTemporary/" + file.getName(), Files.newInputStream(file.toPath(), new OpenOption[0]));
            return imageFileService.upload(fileItem);
        }
        throw new RuntimeException("\u54cd\u5e94\u53c2\u6570\u4e2d\u6ca1\u6709\u6709\u6548\u6570\u636e\uff01");
    }

    public static boolean checkLoginStatus() throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/dzswj-smdl";
        JSONObject data = new JSONObject();
        data.put("stepName", (Object)"verify_qrcode");
        JSONObject response = ApiCall.execute(data, url);
        if (response.containsKey((Object)"stepCode")) {
            String code = response.getString("stepCode");
            return "0".equals(code);
        }
        return false;
    }

    private static File convertBase64ToTempFile(String base64Data) throws Exception {
        String[] parts = base64Data.split(",");
        String base64Content = parts.length > 1 ? parts[1] : parts[0];
        byte[] imageBytes = Base64.getDecoder().decode(base64Content);
        String fileName = ApiCall.generateMD5Hash(imageBytes) + ".png";
        Path tempDir = Files.createTempDirectory("temp_images", new FileAttribute[0]);
        File imageFile = new File(tempDir.toFile(), fileName);
        try (FileOutputStream fos = new FileOutputStream(imageFile);){
            fos.write(imageBytes);
        }
        return imageFile;
    }

    private static String generateMD5Hash(byte[] data) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] hash = md.digest(data);
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (Exception e) {
            throw new RuntimeException("\u751f\u6210MD5\u54c8\u5e0c\u5931\u8d25", e);
        }
    }

    public static List<DeclarationStatusRespVO> declarationStatus(DeclarationTypeEnum type, String flowId) throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/ckts-cxsbzt";
        ArrayList<DeclarationStatusRespVO> result = new ArrayList<DeclarationStatusRespVO>();
        DeclarationStatusReqVO originRequestContent = new DeclarationStatusReqVO(type.getCode(), flowId);
        JSONObject response = ApiCall.execute(originRequestContent.jsonObject(), url);
        if (response.containsKey((Object)"data") && !response.getJSONArray("data").isEmpty()) {
            JSONArray data = response.getJSONArray("data");
            for (int i = 0; i < data.size(); ++i) {
                JSONObject object = data.getJSONObject(i);
                DeclarationStatusRespVO respVO = (DeclarationStatusRespVO)object.toJavaObject(DeclarationStatusRespVO.class);
                result.add(respVO);
            }
            return result;
        }
        throw new RuntimeException("\u672a\u627e\u5230\u6709\u6548\u6570\u636e\uff01");
    }

    public static DeclarationAuditProgressRespVO declarationAuditStatus(String date, String no) throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/ckts-cxshjd";
        DeclarationAuditProgressReqVO originRequestContent = new DeclarationAuditProgressReqVO(date, no);
        JSONObject response = ApiCall.execute(originRequestContent.jsonObject(), url);
        return (DeclarationAuditProgressRespVO)response.toJavaObject(DeclarationAuditProgressRespVO.class);
    }

    public static List<TaxRefundRateQueryRespVO> queryTaxRefundRate(String code, String name) throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/tslwk";
        TaxRefundRateQueryReqVO originRequestContent = new TaxRefundRateQueryReqVO(code, name);
        JSONObject response = ApiCall.execute(originRequestContent.jsonObject(), url);
        ArrayList<TaxRefundRateQueryRespVO> result = new ArrayList<TaxRefundRateQueryRespVO>();
        if (response.containsKey((Object)"records")) {
            JSONArray records = response.getJSONArray("records");
            for (Object record : records) {
                JSONObject object = (JSONObject)record;
                String productCode = "";
                if (object.containsKey((Object)"spdm")) {
                    productCode = object.getString("spdm");
                }
                BigDecimal tsl = BigDecimal.ZERO;
                if (object.containsKey((Object)"tsl")) {
                    tsl = object.getBigDecimal("tsl");
                }
                BigDecimal zssl = BigDecimal.ZERO;
                if (object.containsKey((Object)"zssl")) {
                    zssl = object.getBigDecimal("zssl");
                }
                TaxRefundRateQueryRespVO data = new TaxRefundRateQueryRespVO(productCode, tsl, zssl);
                result.add(data);
            }
        }
        return result;
    }

    public static JSONObject queryFeedbackData(String flowId, String fileId) throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/ckts-cxfksj";
        FeedBackDataQueryReqVO originRequestContent = new FeedBackDataQueryReqVO(flowId, fileId);
        return ApiCall.execute(originRequestContent.jsonObject(), url);
    }

    public static JSONObject queryLoginStatus() throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/dzswj-cxzt";
        JSONObject originRequestContent = new JSONObject();
        originRequestContent.put("scope", (Object)"etax");
        return ApiCall.execute(originRequestContent, url);
    }

    public static boolean registerCompany(CompanyRegisterReqVO originRequestContent) throws Exception {
        String url = "https://supplychain-dev.chinackts.com/qst/enterprise/91370213MA3R0CR01P/sqqy";
        JSONObject response = ApiCall.execute(originRequestContent.jsonObject(), url);
        if (response.containsKey((Object)"success")) {
            Boolean success = response.getBoolean("success");
            if (success.booleanValue()) {
                return true;
            }
            if (response.containsKey((Object)"msg")) {
                String msg = response.getString("msg");
                throw new RuntimeException("\u6ce8\u518c\u5931\u8d25\uff1a" + msg);
            }
        }
        throw new RuntimeException("\u6ca1\u6709\u6709\u6548\u54cd\u5e94\u6570\u636e");
    }
}

