/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.ocr.common;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.imageio.ImageIO;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.PDFRenderer;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.YEM;

public class VoiceOcrUtil {
    public static final BigDecimal overSeconds = new BigDecimal("300");
    public static final BigDecimal avgSeconds = new BigDecimal("60");

    public static int getPercentInt(Date enddate, Date startdate) {
        BigDecimal passSeconds = VoiceOcrUtil.getPassSeconds(enddate, startdate);
        BigDecimal percent = BigDecimalUtils.div((BigDecimal)passSeconds, (BigDecimal)avgSeconds, (int)2).multiply(new BigDecimal("100"));
        int percentInt = percent.intValue();
        if (percentInt == 0) {
            percentInt = 1;
        }
        if (percentInt > 99) {
            percentInt = 99;
        }
        return percentInt;
    }

    public static BigDecimal getPassSeconds(Date enddate, Date startdate) {
        return BigDecimalUtils.toBigDecimal((Object)((double)(enddate.getTime() - startdate.getTime()) / 1000.0));
    }

    public static List<DynamicObject> splitPdf2Images(DynamicObject att, String billKey, Object billId, String attachmentKey, InputStream input) throws IOException {
        ArrayList<DynamicObject> atts = new ArrayList<DynamicObject>();
        try (PDDocument document = PDDocument.load((InputStream)input);){
            String pdfFileName = att.getString("FAttachmentName");
            pdfFileName = YEM.substringBeforeLast((String)pdfFileName, (String)".");
            PDFRenderer renderer = new PDFRenderer(document);
            for (int i = 0; i < document.getNumberOfPages(); ++i) {
                BufferedImage bufferedImage = renderer.renderImageWithDPI(i, 300.0f);
                String fileName = String.format("%s_page_%s.png", pdfFileName, i + 1);
                ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "png", byteOutputStream);
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(byteOutputStream.toByteArray());
                int available = byteInputStream.available();
                String path = "/" + fileName;
                FileService service = FileServiceFactory.getAttachmentFileService();
                FileItem fileItem = new FileItem(fileName, path, (InputStream)byteInputStream);
                fileItem.setCreateNewFileWhenExists(true);
                String fileId = service.upload(fileItem);
                DynamicObject newAtt = VoiceOcrUtil.saveAttachment(billKey, billId, attachmentKey, fileName, fileId, available);
                atts.add(newAtt);
            }
        }
        return atts;
    }

    public static List<DynamicObject> pdf2Image(DynamicObject att, String billKey, Object billId, String attachmentKey, InputStream input) throws IOException {
        String pdfFileName = att.getString("FAttachmentName");
        ArrayList<DynamicObject> atts = new ArrayList<DynamicObject>();
        ByteArrayInputStream byteInputStream = VoiceOcrUtil.pdf2Image(input);
        pdfFileName = YEM.substringBeforeLast((String)pdfFileName, (String)".");
        String fileName = String.format("%s.png", pdfFileName);
        int available = byteInputStream.available();
        String path = "/" + fileName;
        FileService service = FileServiceFactory.getAttachmentFileService();
        FileItem fileItem = new FileItem(fileName, path, (InputStream)byteInputStream);
        fileItem.setCreateNewFileWhenExists(true);
        String fileId = service.upload(fileItem);
        DynamicObject newAtt = VoiceOcrUtil.saveAttachment(billKey, billId, attachmentKey, fileName, fileId, available);
        atts.add(newAtt);
        return atts;
    }

    public static ByteArrayInputStream pdf2Image(InputStream input) throws IOException {
        PDDocument document = PDDocument.load((InputStream)input);
        int pages = document.getNumberOfPages();
        PDFRenderer renderer = new PDFRenderer(document);
        BufferedImage mergedImage = new BufferedImage(2560, 3840 * pages, 1);
        Graphics2D g = mergedImage.createGraphics();
        int x = 0;
        int y = 0;
        for (int i = 0; i < pages; ++i) {
            BufferedImage pageImage = renderer.renderImageWithDPI(i, 300.0f);
            g.drawImage((Image)pageImage, x, y, null);
            if (i < pages - 1) {
                y += pageImage.getHeight();
            }
            if (y <= mergedImage.getHeight()) continue;
            BufferedImage newMergedImage = new BufferedImage(mergedImage.getWidth(), mergedImage.getHeight() * 2, 1);
            Graphics2D ng = newMergedImage.createGraphics();
            ng.drawImage((Image)mergedImage, 0, 0, null);
            g.dispose();
            g = ng;
            mergedImage = newMergedImage;
        }
        g.dispose();
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)mergedImage, "png", byteOutputStream);
        return new ByteArrayInputStream(byteOutputStream.toByteArray());
    }

    public static List<DynamicObject> splitPdf2Pages(String billKey, Object billId, String attachmentKey, InputStream input) throws IOException {
        ArrayList<DynamicObject> atts = new ArrayList<DynamicObject>();
        try (PDDocument document = PDDocument.load((InputStream)input);){
            int totalPages = document.getNumberOfPages();
            for (int i = 0; i < totalPages; ++i) {
                PDDocument singlePageDoc = new PDDocument();
                singlePageDoc.addPage(document.getPage(i));
                String fileName = String.format("page_%s.pdf", i + 1);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                singlePageDoc.save((OutputStream)byteArrayOutputStream);
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                int available = byteInputStream.available();
                String path = "/" + fileName;
                FileService service = FileServiceFactory.getAttachmentFileService();
                FileItem fileItem = new FileItem(fileName, path, (InputStream)byteInputStream);
                fileItem.setCreateNewFileWhenExists(true);
                String fileId = service.upload(fileItem);
                singlePageDoc.close();
                DynamicObject att = VoiceOcrUtil.saveAttachment(billKey, billId, attachmentKey, fileName, fileId, available);
                atts.add(att);
            }
        }
        return atts;
    }

    public static DynamicObject saveAttachment(String billKey, Object billId, String attachmentKey, String fileName, String fileId, int available) throws UnsupportedEncodingException {
        DynamicObject bos_attachment = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
        Date today = new Date();
        long attId = ORM.create().genLongId("bos_attachment");
        String extName = (fileName = URLDecoder.decode(fileName, "utf-8")) != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
        bos_attachment.set("id", (Object)attId);
        bos_attachment.set("FNUMBER", (Object)("rc-upload-" + attId));
        bos_attachment.set("FBillType", (Object)billKey);
        bos_attachment.set("FInterID", billId);
        bos_attachment.set("FModifyTime", (Object)today);
        bos_attachment.set("fcreatetime", (Object)today);
        bos_attachment.set("FaliasFileName", (Object)fileName);
        bos_attachment.set("FAttachmentName", (Object)fileName);
        bos_attachment.set("FExtName", (Object)extName);
        bos_attachment.set("FATTACHMENTSIZE", (Object)available);
        bos_attachment.set("FCREATEMEN", (Object)RequestContext.get().getCurrUserId());
        bos_attachment.set("fattachmentpanel", (Object)attachmentKey);
        bos_attachment.set("fdescription", (Object)"");
        bos_attachment.set("FFileId", (Object)fileId);
        return bos_attachment;
    }
}

