/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pc.common.moudle.require.bill;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.SplitContainer;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sdk.plugin.Plugin;
import org.apache.commons.lang.text.StrBuilder;
import yem.base.common.utils.DynamicObjectUtil;
import yem.base.common.utils.YEM;
import yem.wm.pc.common.utils.PcRequestTaskUtil;

public class PcChangeBillPlugin
extends AbstractBillPlugIn
implements Plugin {
    private final String CHANGEBILL_ENTRY = "yem_pc_bgdj_bgfl";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_supplier"});
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        Boolean value;
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        if ("yem_close".equals(operateKey) || "yem_change".equals(operateKey)) {
            HashMap<String, String> failMsg;
            int rowIndex = model.getEntryCurrentRowIndex("yem_pc_bgdj_bgfl");
            DynamicObject object = (DynamicObject)model.getEntryEntity("yem_pc_bgdj_bgfl").get(rowIndex);
            if (this.canBeOperated(object, view, operateKey, true, failMsg = new HashMap<String, String>(), rowIndex)) {
                return;
            }
            model.setValue("yem_alreadydo", (Object)true, rowIndex);
            int newRow = model.insertEntryRow("yem_pc_bgdj_bgfl", rowIndex + 1);
            this.copyEntry(rowIndex, newRow);
            switch (operateKey) {
                case "yem_change": {
                    model.setValue("yem_requiretype", (Object)"C", newRow);
                    model.setValue("yem_alreadydo", (Object)true, newRow);
                    break;
                }
                case "yem_close": {
                    model.setValue("yem_requiretype", (Object)"D", newRow);
                    model.setValue("yem_linestate", (Object)"B", newRow);
                    model.setValue("yem_alreadydo", (Object)true, newRow);
                    this.lockEntryRow(newRow);
                    break;
                }
            }
        }
        if ("yem_allentryclose".equals(operateKey)) {
            DynamicObjectCollection billentry = model.getEntryEntity("yem_pc_bgdj_bgfl");
            EntryGrid control = (EntryGrid)view.getControl("yem_pc_bgdj_bgfl");
            int[] selectRows = control.getSelectRows();
            List collect = Arrays.stream(selectRows).boxed().collect(Collectors.toList());
            HashMap<String, String> failMsg = new HashMap<String, String>();
            for (int i2 = 0; i2 < collect.size(); ++i2) {
                Integer rowIndex = (Integer)collect.get(i2);
                DynamicObject object = (DynamicObject)billentry.get(rowIndex.intValue());
                if (!this.canBeOperated(object, view, "yem_close", false, failMsg, rowIndex)) continue;
                collect.remove(rowIndex);
                --i2;
            }
            int rowSeq = 0;
            for (int rowIndex = 0; rowIndex < billentry.size(); ++rowIndex) {
                if (!collect.contains(rowSeq++)) continue;
                model.setValue("yem_alreadydo", (Object)true, rowIndex);
                int newRow = model.insertEntryRow("yem_pc_bgdj_bgfl", rowIndex + 1);
                this.copyEntry(rowIndex, newRow);
                model.setValue("yem_requiretype", (Object)"D", newRow);
                model.setValue("yem_linestate", (Object)"B", newRow);
                model.setValue("yem_alreadydo", (Object)true, newRow);
                this.lockEntryRow(newRow);
                ++rowIndex;
            }
            if (!failMsg.isEmpty()) {
                this.showErrorMsg(failMsg, "\u65b0\u589e\u9700\u6c42\u65e0\u6cd5\u8fdb\u884c\u5173\u95ed\u64cd\u4f5c", view);
            } else {
                view.showSuccessNotification("\u884c\u5173\u95ed\u6210\u529f\uff01");
            }
        }
        if ("yem_allentrydate".equals(operateKey) || "yem_allchgreports".equals(operateKey)) {
            EntryGrid control = (EntryGrid)view.getControl("yem_pc_bgdj_bgfl");
            int[] entrySelectRows = control.getSelectRows();
            if (entrySelectRows != null && entrySelectRows.length > 0) {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setStatus(OperationStatus.ADDNEW);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("yem_pc_chgarrivedate");
                HashMap<String, String> value2 = new HashMap<String, String>();
                value2.put("operatekey", operateKey);
                showParameter.setCustomParams(value2);
                CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, operateKey);
                showParameter.setCloseCallBack(callBack);
                view.showForm(showParameter);
            } else {
                view.showTipNotification("\u8bf7\u9009\u4e2d\u884c\u540e\u64cd\u4f5c\uff01");
            }
        }
        if ("yem_newentry".equals(operateKey)) {
            String prNum = (String)model.getValue("yem_srcbillnum");
            int unique = (Integer)model.getValue("yem_orgentrynum");
            int entryRow = model.createNewEntryRow("yem_pc_bgdj_bgfl");
            model.setValue("yem_requiretype", (Object)"B", entryRow);
            model.setValue("yem_purchasecode", (Object)(prNum + "-" + (unique + 1)), entryRow);
            model.setValue("yem_orgentrynum", (Object)(unique + 1));
            model.setValue("yem_reportuser", model.getValue("yem_changesubmitter"), entryRow);
            model.setValue("yem_planareadetails", model.getValue("yem_planarea"), entryRow);
            model.setValue("yem_reqarrivaldate", model.getValue("yem_advicetime"), entryRow);
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            DynamicObjectCollection billentry = model.getEntryEntity("yem_pc_bgdj_bgfl");
            for (int i3 = 0; i3 < billentry.size(); ++i3) {
                DynamicObject entry = (DynamicObject)billentry.get(i3);
                String linetype = entry.getString("yem_requiretype");
                if (!"A".equals(linetype) && !"D".equals(linetype)) continue;
                this.lockEntryRow(i3);
            }
            if (args.getOperationResult().isSuccess()) {
                view.invokeOperation("refresh");
            }
        }
        if ("save".equals(operateKey) && !(value = (Boolean)model.getValue("yem_isupdateatt")).booleanValue()) {
            this.setAttachmentData();
            view.updateView("attachmentpanel");
        }
        if ("yem_delentry".equals(operateKey)) {
            DynamicObjectCollection billentry = model.getEntryEntity("yem_pc_bgdj_bgfl");
            EntryGrid control = (EntryGrid)view.getControl("yem_pc_bgdj_bgfl");
            int[] selectRows = control.getSelectRows();
            ArrayList<Integer> delEntries = new ArrayList<Integer>();
            StringBuilder sb = new StringBuilder();
            for (int selectRow : selectRows) {
                DynamicObject deleEntry = (DynamicObject)billentry.get(selectRow);
                boolean yemAlreadydo = deleEntry.getBoolean("yem_alreadydo");
                String linetype = deleEntry.getString("yem_requiretype");
                String purcode = deleEntry.getString("yem_purchasecode");
                if ("A".equals(linetype)) {
                    sb.append(selectRow + 1).append("\u3001");
                    continue;
                }
                if (yemAlreadydo) {
                    for (int i4 = 0; i4 < billentry.size(); ++i4) {
                        DynamicObject object = (DynamicObject)billentry.get(i4);
                        String tarcode = object.getString("yem_purchasecode");
                        if (!purcode.equals(tarcode)) continue;
                        model.setValue("yem_alreadydo", (Object)false, i4);
                    }
                }
                delEntries.add(selectRow);
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(sb.length() - 1);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5220\u9664\u5931\u8d25\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u539f\u9700\u6c42\u7c7b\u578b\u884c", (String)"PscChangeBillPlugin_5", (String)"yem-pur", (Object[])new Object[0]), sb));
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\uff01", (String)"PscChangeBillPlugin_6", (String)"yem-pur", (Object[])new Object[0]));
            }
            model.deleteEntryRows("yem_pc_bgdj_bgfl", delEntries.stream().filter(integer -> integer != null).mapToInt(i -> i).toArray());
        }
    }

    private boolean canBeOperated(DynamicObject object, IFormView view, String operateKey, boolean type, Map<String, String> failMsg, int i) {
        boolean yemAlreadydo = object.getBoolean("yem_alreadydo");
        String linetype = object.getString("yem_requiretype");
        String linestate = object.getString("yem_linestate");
        if (yemAlreadydo) {
            this.showTipNotification(type, view, ResManager.loadKDString((String)"\u5df2\u64cd\u4f5c\u8fc7\u8be5\u5217\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c", (String)"PscChangeBillPlugin_0", (String)"yem-pur", (Object[])new Object[0]));
            failMsg.put(String.valueOf(i + 1), "1");
            return true;
        }
        if ("B".equals(linestate)) {
            this.showTipNotification(type, view, ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u5df2\u5173\u95ed\u6570\u636e\uff01", (String)"PscChangeBillPlugin_1", (String)"yem-pur", (Object[])new Object[0]));
            failMsg.put(String.valueOf(i + 1), "2");
            return true;
        }
        if ("B".equals(linetype)) {
            this.showTipNotification(type, view, String.format(ResManager.loadKDString((String)"\u65b0\u589e\u9700\u6c42\u65e0\u6cd5\u8fdb\u884c%s\u64cd\u4f5c", (String)"PscChangeBillPlugin_2", (String)"yem-pur", (Object[])new Object[0]), "yem_close".equals(operateKey) ? ResManager.loadKDString((String)"\u5173\u95ed", (String)"PscChangeBillPlugin_3", (String)"yem-pur", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d8\u66f4", (String)"PscChangeBillPlugin_4", (String)"yem-pur", (Object[])new Object[0])));
            failMsg.put(String.valueOf(i + 1), "3");
            return true;
        }
        if ("yem_close".equals(operateKey)) {
            DynamicObject[] load;
            String yemPurchasecode = object.getString("yem_purchasecode");
            QFilter filter = new QFilter("yem_number", "=", (Object)yemPurchasecode);
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"yem_pc_reqpooltpl", (String)"yem_totalexcuteqty", (QFilter[])filter.toArray())) {
                BigDecimal yemTotalexcuteqty = dynamicObject.getBigDecimal("yem_totalexcuteqty");
                if (yemTotalexcuteqty.compareTo(BigDecimal.ZERO) <= 0) continue;
                this.showTipNotification(type, view, "\u5df2\u751f\u6210\u5bfb\u6e90\u6d41\u7a0b\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\uff0c\u5982\u9700\u5173\u95ed\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u5458\u5173\u95ed\u5bfb\u6e90\u540e\u64cd\u4f5c\uff01");
                failMsg.put(String.valueOf(i + 1), "4");
                return true;
            }
        }
        return false;
    }

    private void showTipNotification(boolean type, IFormView view, String msg) {
        if (type) {
            view.showTipNotification(msg);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        DynamicObject dataEntity = this.getView().getModel().getDataEntity(true);
        SplitContainer splitContainer = (SplitContainer)this.getView().getControl("yem_splitcontainerap");
        if (null != splitContainer) {
            // empty if block
        }
        DynamicObjectCollection yemEntryentity = this.getModel().getEntryEntity("yem_pc_bgdj_bgfl");
        for (int i = 0; i < yemEntryentity.size(); ++i) {
            DynamicObject entry = (DynamicObject)yemEntryentity.get(i);
            String linetype = entry.getString("yem_requiretype");
            if ("A".equals(linetype) || "D".equals(linetype)) {
                this.lockEntryRow(i);
            }
            if (!"B".equals(linetype)) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"yem_changecause"});
        }
        FormShowParameter fsp = this.getView().getFormShowParameter();
        OperationStatus status = fsp.getStatus();
        if (OperationStatus.ADDNEW == status) {
            // empty if block
        }
    }

    private void setAttachmentData() {
        DynamicObject[] Attachmentsch;
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject entity = model.getDataEntity(true);
        String selectfieldsFast = DynamicObjectUtil.getSelectfields((String)"bos_attachment");
        QFilter filterch = new QFilter("FInterID", "=", (Object)entity.getString("yem_srcbillid"));
        QFilter billtypefilterch = new QFilter("fbilltype", "=", (Object)"yem_pc_requirapplybill");
        QFilter panelfilterch = new QFilter("fattachmentpanel", "=", (Object)"attachmentpanel");
        for (DynamicObject attachment : Attachmentsch = BusinessDataServiceHelper.load((String)"bos_attachment", (String)selectfieldsFast, (QFilter[])new QFilter[]{filterch, billtypefilterch, panelfilterch})) {
            String fileName = (String)attachment.get("fattachmentname");
            DynamicObject newAtt = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            Long id = ORM.create().genLongId("bos_attachment");
            newAtt.set("id", (Object)id);
            String newAttUid = "upload_" + id;
            newAtt.set("fnumber", (Object)newAttUid);
            newAtt.set("fnumber", (Object)attachment.getString("fnumber"));
            newAtt.set("FBillType", (Object)"yem_pc_changebill");
            newAtt.set("FInterID", (Object)entity.getString("id"));
            newAtt.set("FModifyTime", attachment.get("fmodifytime"));
            newAtt.set("fcreatetime", attachment.get("fcreatetime"));
            newAtt.set("FaliasFileName", (Object)fileName);
            newAtt.set("FAttachmentName", (Object)fileName);
            newAtt.set("FFileId", attachment.get("ffileid"));
            newAtt.set("FExtName", attachment.get("fextname"));
            newAtt.set("FATTACHMENTSIZE", attachment.get("fattachmentsize"));
            newAtt.set("FCREATEMEN", attachment.get("fcreatemen"));
            newAtt.set("fattachmentpanel", (Object)"attachmentpanel");
            newAtt.set("fdescription", attachment.get("fdescription"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAtt});
        }
        model.setValue("yem_isupdateatt", (Object)true);
        OperationResult operationResult = view.invokeOperation("save", YEM.getOptionNoMsg());
        if (!operationResult.isSuccess()) {
            view.showTipNotification("\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + YEM.getOpMsg((OperationResult)operationResult));
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        FormShowParameter fsp = view.getFormShowParameter();
        OperationStatus status = fsp.getStatus();
        if (OperationStatus.ADDNEW == status) {
            FormShowParameter showParameter = view.getFormShowParameter();
            Map customParas = showParameter.getCustomParams();
            Object pkId = customParas.get("pkId");
            String editSource = (String)customParas.get("editsource");
            List entryIds = (List)customParas.get("entryIds");
            Map<String, BigDecimal> taskIdQty = null;
            Map<String, List<DynamicObject>> taskData = null;
            if (editSource != null) {
                if ("task".equals(editSource)) {
                    model.setValue("yem_editsource", (Object)"B");
                    String yemPlaninitiaid = (String)customParas.get("yem_planinitiaids");
                    if (YEM.isNotEmpty((Object)yemPlaninitiaid)) {
                        List taskIds;
                        ObjectMapper mapper = new ObjectMapper();
                        try {
                            taskIds = (List)mapper.readValue(yemPlaninitiaid, (TypeReference)new TypeReference<List<Long>>(){});
                        }
                        catch (JsonProcessingException ex) {
                            taskIds = null;
                        }
                        if (YEM.isNotEmpty(taskIds)) {
                            QFilter filter = new QFilter("id", "in", (Object)taskIds);
                            DynamicObject[] yemPscReqpooltpls = BusinessDataServiceHelper.load((String)"yem_pc_reqpooltpl", (String)"yem_srcentryid,yem_applyqty,yem_number,yem_overallcontroln,yem_planusern,yem_purteamleadern,yem_entryoperatorn", (QFilter[])filter.toArray());
                            taskData = Arrays.stream(yemPscReqpooltpls).collect(Collectors.groupingBy(s -> s.getString("yem_number")));
                            taskIdQty = Arrays.stream(yemPscReqpooltpls).collect(Collectors.groupingBy(s -> s.getString("yem_srcentryid"), Collectors.collectingAndThen(Collectors.toList(), value -> {
                                BigDecimal applyQty = BigDecimal.ZERO;
                                for (DynamicObject object : value) {
                                    applyQty = applyQty.add(object.getBigDecimal("yem_applyqty"));
                                }
                                return applyQty;
                            })));
                        }
                    }
                    model.setValue("yem_planinitiaids_tag", (Object)yemPlaninitiaid);
                } else {
                    List sourcedata = entryIds.stream().map(Object::toString).collect(Collectors.toList());
                    QFilter filter = new QFilter("yem_srcentryid", "in", sourcedata);
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"yem_pc_reqpooltpl", (String)"yem_number,yem_overallcontroln,yem_planusern,yem_purteamleadern,yem_entryoperatorn", (QFilter[])filter.toArray());
                    taskData = Arrays.stream(load).collect(Collectors.groupingBy(s -> s.getString("yem_number")));
                    model.setValue("yem_editsource", (Object)"A");
                }
            }
            DynamicObject selectData = BusinessDataServiceHelper.loadSingle(pkId, (String)"yem_pc_requirapplybill");
            model.setValue("yem_srcbillid", pkId);
            model.setValue("yem_srcbillnum", (Object)selectData.getString("billno"));
            model.setValue("yem_purname", (Object)selectData.getString("yem_purname"));
            model.setValue("yem_oldpurname", (Object)selectData.getString("yem_purname"));
            model.setValue("yem_changesubmitter", (Object)YEM.getCurrentUserId());
            model.setValue("yem_bizorg", selectData.get("yem_bizorg"));
            model.setValue("yem_planarea", selectData.get("yem_planarea"));
            model.setValue("yem_reqtype", selectData.get("yem_reqtype"));
            model.setValue("yem_reporting", selectData.get("yem_reporting"));
            model.setValue("yem_reportor", selectData.get("yem_reportor"));
            model.setValue("yem_reporting", selectData.get("yem_reporting"));
            model.setValue("org", selectData.get("org"));
            DynamicObject yemReqbilltype = selectData.getDynamicObject("yem_billtype");
            if (yemReqbilltype != null) {
                model.setValue("yem_reqbilltype", (Object)yemReqbilltype.getString("number"));
            }
            model.setValue("yem_advicetime", selectData.get("yem_advicetime"));
            DynamicObjectCollection billentry = selectData.getDynamicObjectCollection("yem_pc_xqsq_wlmx");
            int size = billentry.size();
            if (size == entryIds.size()) {
                model.setValue("yem_isallentrychg", (Object)true);
            }
            model.setValue("yem_orgentrynum", (Object)size);
            if (YEM.isNotEmpty((Object)entryIds)) {
                if (entryIds.size() == 1 && entryIds.get(0) == null) {
                    for (DynamicObject object : billentry) {
                        this.setChangeBillEntrtyData(object, model, taskData);
                    }
                } else {
                    for (DynamicObject object : billentry) {
                        if (!entryIds.contains(object.get("id"))) continue;
                        this.setChangeBillEntrtyData(object, model, taskData);
                    }
                }
            }
            if (taskIdQty != null) {
                DynamicObjectCollection entryEntity = model.getEntryEntity("yem_pc_bgdj_bgfl");
                for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
                    int newRow;
                    DynamicObject object = (DynamicObject)entryEntity.get(rowIndex);
                    model.setValue("yem_alreadydo", (Object)true, rowIndex);
                    String yemSrcbillentryid = object.getString("yem_srcbillentryid");
                    BigDecimal taskQty = taskIdQty.get(yemSrcbillentryid);
                    BigDecimal yemQty = object.getBigDecimal("yem_qty");
                    if (taskQty.compareTo(yemQty) == 0) {
                        newRow = model.insertEntryRow("yem_pc_bgdj_bgfl", rowIndex + 1);
                        this.copyEntry(rowIndex, newRow);
                        model.setValue("yem_requiretype", (Object)"D", newRow);
                        model.setValue("yem_linestate", (Object)"B", newRow);
                        model.setValue("yem_alreadydo", (Object)true, newRow);
                        ++rowIndex;
                        continue;
                    }
                    newRow = model.insertEntryRow("yem_pc_bgdj_bgfl", rowIndex + 1);
                    this.copyEntry(rowIndex, newRow);
                    model.setValue("yem_requiretype", (Object)"C", newRow);
                    model.setValue("yem_changecause", (Object)"\u8ba1\u5212\u9000\u56de\u53d8\u66f4", newRow);
                    model.setValue("yem_alreadydo", (Object)true, newRow);
                    model.setValue("yem_qty", (Object)yemQty.subtract(taskQty), newRow);
                    ++rowIndex;
                }
            }
        }
    }

    private void setChangeBillEntrtyData(DynamicObject entry, IDataModel model, Map<String, List<DynamicObject>> taskData) {
        int entryRow = model.createNewEntryRow("yem_pc_bgdj_bgfl");
        DynamicObjectCollection yemEntryentity = model.getEntryEntity("yem_pc_bgdj_bgfl");
        DynamicObject entryData = (DynamicObject)yemEntryentity.get(entryRow);
        model.setValue("yem_requiretype", (Object)"A", entryRow);
        String yemPurchasecode = entry.getString("yem_purchasecode");
        model.setValue("yem_purchasecode", (Object)yemPurchasecode, entryRow);
        model.setValue("yem_materialmasterid", entry.get("yem_materialmasterid"), entryRow);
        model.setValue("yem_materrname", entry.get("yem_materrname"), entryRow);
        model.setValue("yem_materdesc", entry.get("yem_materialdescribe"), entryRow);
        model.setValue("yem_materialdesc", entry.get("yem_materialdesc"), entryRow);
        model.setValue("yem_materialspeci", entry.get("yem_materialspeci"), entryRow);
        model.setValue("yem_reqdes", entry.get("yem_reqdes"), entryRow);
        model.setValue("yem_qty", entry.get("yem_qty"), entryRow);
        model.setValue("yem_unit", entry.get("yem_unit"), entryRow);
        model.setValue("yem_contractor", entry.get("yem_contractor"), entryRow);
        model.setValue("yem_reqarrivaldate", entry.get("yem_reqarrivaldate"), entryRow);
        model.setValue("yem_entrycomment", entry.get("yem_entrycomment"), entryRow);
        model.setValue("yem_reportuser", entry.get("yem_reportuser"), entryRow);
        model.setValue("yem_purcategory", entry.get("yem_purcategory"), entryRow);
        model.setValue("yem_planareadetails", entry.get("yem_planareadetails"), entryRow);
        model.setValue("yem_linetype", entry.get("yem_linetype"), entryRow);
        DynamicObjectCollection attachments = entry.getDynamicObjectCollection("yem_attachment");
        DynamicObjectCollection toAttachments = entryData.getDynamicObjectCollection("yem_attachment");
        this.uploadAttachmentField(attachments, toAttachments);
        if (taskData != null && YEM.isNotEmpty(taskData.get(yemPurchasecode))) {
            List<DynamicObject> dynamicObjects = taskData.get(yemPurchasecode);
            this.setMulityData(model, dynamicObjects, entryRow, "yem_overallcontroln");
            this.setMulityData(model, dynamicObjects, entryRow, "yem_planusern");
            this.setMulityData(model, dynamicObjects, entryRow, "yem_purteamleadern");
            this.setMulityData(model, dynamicObjects, entryRow, "yem_entryoperatorn");
        } else {
            PcRequestTaskUtil.selectDataToForm(entry, "yem_overallcontroln", entryRow, model);
            PcRequestTaskUtil.selectDataToForm(entry, "yem_planusern", entryRow, model);
            PcRequestTaskUtil.selectDataToForm(entry, "yem_purteamleadern", entryRow, model);
            PcRequestTaskUtil.selectDataToForm(entry, "yem_entryoperatorn", entryRow, model);
        }
        model.setValue("yem_attachname", entry.get("yem_attachname"), entryRow);
        model.setValue("yem_linestate", entry.get("yem_linestate"), entryRow);
        model.setValue("yem_srcbillentryid", entry.get("id"), entryRow);
        model.setValue("yem_reportingdetails", entry.get("yem_reportingdetails"), entryRow);
    }

    private void setMulityData(IDataModel model, List<DynamicObject> dynamicObjects, int entryRow, String yemOverallcontroln) {
        List distinctStrings = dynamicObjects.stream().flatMap(v -> v.getDynamicObjectCollection(yemOverallcontroln).stream()).distinct().collect(Collectors.toList());
        if (YEM.isNotEmpty(distinctStrings)) {
            model.setValue(yemOverallcontroln, (Object)Objects.requireNonNull(PcRequestTaskUtil.getObjectCollectionIds(distinctStrings)).toArray(), entryRow);
        }
    }

    private void uploadAttachmentField(DynamicObjectCollection attachments, DynamicObjectCollection toAttachments) {
        if (toAttachments != null) {
            toAttachments.clear();
            for (DynamicObject upfile : attachments) {
                DynamicObject bd = this.copyAttachBd(upfile.getDynamicObject("fbasedataid"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bd});
                DynamicObject attField = new DynamicObject(toAttachments.getDynamicObjectType());
                attField.set("fbasedataid", (Object)bd);
                attField.set("fbasedataid_id", bd.getPkValue());
                toAttachments.add((Object)attField);
            }
        }
    }

    private DynamicObject copyAttachBd(DynamicObject att_bd) {
        DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)att_bd.getDataEntityType().getName());
        DataEntityPropertyCollection properties = att_bd.getDataEntityType().getProperties();
        for (IDataEntityProperty p1 : properties) {
            if (p1.getName().equals("id") || p1.getName().equals("multilanguagetext")) continue;
            if (p1.getName().equals("uid")) {
                newObj.set("uid", (Object)DB.genLongId((String)""));
                continue;
            }
            Object value = att_bd.get(p1);
            newObj.set(p1, value);
        }
        return newObj;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
    }

    private void copyEntry(int copyRow, int newRow) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)view.getControl("yem_pc_bgdj_bgfl");
        List fieldEdits = entryGrid.getFieldEdits();
        DynamicObject copyEntry = (DynamicObject)this.getModel().getEntryEntity("yem_pc_bgdj_bgfl").get(copyRow);
        DynamicObject newEntry = (DynamicObject)this.getModel().getEntryEntity("yem_pc_bgdj_bgfl").get(newRow);
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getFieldKey();
            if ("yem_attachment".equals(fieldKey)) {
                DynamicObjectCollection toAtt = newEntry.getDynamicObjectCollection("yem_attachment");
                DynamicObjectCollection attachment = copyEntry.getDynamicObjectCollection("yem_attachment");
                this.uploadAttachmentField(attachment, toAtt);
                continue;
            }
            model.setValue(fieldKey, copyEntry.get(fieldKey), newRow);
        }
    }

    private void lockEntryRow(int i) {
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)view.getControl("yem_pc_bgdj_bgfl");
        List fieldEdits = entryGrid.getFieldEdits();
        for (FieldEdit fieldEdit : fieldEdits) {
            String fieldKey = fieldEdit.getFieldKey();
            view.setEnable(Boolean.valueOf(false), i, new String[]{fieldKey});
        }
    }

    public void click(EventObject evt) {
        String name;
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (name = c.getKey().toLowerCase()) {
            case "yem_supplier": {
                this.openSupplier();
            }
        }
    }

    private void openSupplier() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("bd_supplier");
        listShowParameter.setLookUp(true);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "bdsupplier"));
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(style);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("bos_basedatatreelistf7");
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        IDataModel model = this.getModel();
        EntryGrid entryGrid = (EntryGrid)this.getControl("yem_pc_bgdj_bgfl");
        int[] selectRows = entryGrid.getSelectRows();
        if (actionId.equals("bdsupplier") && returnData != null) {
            ListSelectedRowCollection selectedRows = (ListSelectedRowCollection)returnData;
            Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
            StrBuilder name = new StrBuilder();
            for (int i = 0; i < primaryKeyValues.length; ++i) {
                Object primaryKeyValue = primaryKeyValues[i];
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValue, (String)"bd_supplier");
                String value = dynamicObject.getString("name");
                name.append(value).append(",");
            }
            this.getModel().setValue("yem_supplier", (Object)name.deleteCharAt(name.length() - 1), selectRows[0]);
        }
        if ("yem_allentrydate".equals(actionId) || "yem_allchgreports".equals(actionId)) {
            IFormView view = this.getView();
            Map reData = (Map)e.getReturnData();
            if (reData != null) {
                Object yemReqarrivaldate = reData.get("yem_reqarrivaldate");
                Object reportuser = reData.get("yem_reportuser");
                Object yemChgCause = reData.get("yem_changecause");
                if (yemReqarrivaldate instanceof Date || reportuser instanceof DynamicObject) {
                    DynamicObjectCollection billentry = model.getEntryEntity("yem_pc_bgdj_bgfl");
                    EntryGrid control = (EntryGrid)view.getControl("yem_pc_bgdj_bgfl");
                    int[] entrySelectRows = control.getSelectRows();
                    if (entrySelectRows != null && entrySelectRows.length > 0) {
                        List collect = Arrays.stream(entrySelectRows).boxed().collect(Collectors.toList());
                        HashMap<String, String> failMsg = new HashMap<String, String>();
                        for (int i = 0; i < collect.size(); ++i) {
                            Integer rowIndex = (Integer)collect.get(i);
                            DynamicObject object = (DynamicObject)billentry.get(rowIndex.intValue());
                            if (!this.canBeOperated(object, view, "yem_change", false, failMsg, rowIndex)) continue;
                            collect.remove(rowIndex);
                            --i;
                        }
                        int rowSeq = 0;
                        for (int rowIndex = 0; rowIndex < billentry.size(); ++rowIndex) {
                            if (!collect.contains(rowSeq++)) continue;
                            model.setValue("yem_alreadydo", (Object)true, rowIndex);
                            int newRow = model.insertEntryRow("yem_pc_bgdj_bgfl", rowIndex + 1);
                            this.copyEntry(rowIndex, newRow);
                            model.setValue("yem_requiretype", (Object)"C", newRow);
                            model.setValue("yem_alreadydo", (Object)true, newRow);
                            if ("yem_allentrydate".equals(actionId)) {
                                model.setValue("yem_reqarrivaldate", yemReqarrivaldate, newRow);
                            } else {
                                model.setValue("yem_reportuser", reportuser, newRow);
                            }
                            model.setValue("yem_changecause", yemChgCause, newRow);
                            this.lockEntryRow(newRow);
                            ++rowIndex;
                        }
                        if (!failMsg.isEmpty()) {
                            this.showErrorMsg(failMsg, "\u65b0\u589e\u9700\u6c42\u65e0\u6cd5\u8fdb\u884c\u4fee\u6539\u64cd\u4f5c", view);
                        } else {
                            view.showSuccessNotification(String.format("\u6279\u91cf\u53d8\u66f4%s\u6210\u529f\uff01", "yem_allentrydate".equals(actionId) ? "\u5230\u8d27\u65f6\u95f4" : "\u8bf7\u8d2d\u4eba"));
                        }
                    }
                }
            }
        }
    }

    private void showErrorMsg(Map<String, String> failMsg, String msg, IFormView view) {
        StringBuilder sb = new StringBuilder();
        HashMap<String, String> summaryMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : failMsg.entrySet()) {
            String lineNumber = entry.getKey();
            String errorType = entry.getValue();
            if (summaryMap.containsKey(errorType)) {
                String existingLineNumbers = (String)summaryMap.get(errorType);
                summaryMap.put(errorType, existingLineNumbers + "\u3001" + lineNumber);
                continue;
            }
            summaryMap.put(errorType, lineNumber);
        }
        for (Map.Entry<String, String> entry : summaryMap.entrySet()) {
            sb.append("\u7b2c").append(entry.getValue()).append("\u884c\u64cd\u4f5c\u5931\u8d25\uff0c");
            switch (entry.getKey()) {
                case "1": {
                    sb.append("\u5df2\u64cd\u4f5c\u8fc7\u8be5\u5217\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c");
                    break;
                }
                case "2": {
                    sb.append("\u65e0\u6cd5\u64cd\u4f5c\u5df2\u5173\u95ed\u6570\u636e\uff01");
                    break;
                }
                case "3": {
                    sb.append(msg);
                    break;
                }
                case "4": {
                    sb.append("\u5df2\u751f\u6210\u5bfb\u6e90\u6d41\u7a0b\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\uff0c\u5982\u9700\u5173\u95ed\uff0c\u8bf7\u8054\u7cfb\u91c7\u8d2d\u5458\u5173\u95ed\u5bfb\u6e90\u540e\u64cd\u4f5c\uff01");
                    break;
                }
            }
            sb.append("\n");
        }
        sb.deleteCharAt(sb.length() - 1);
        view.showTipNotification(sb.toString());
    }
}

