/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pc.common.moudle.require.bill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.YEM;

public class PcTramitdetaisBillPlugin
extends AbstractBillPlugIn
implements Plugin {
    public static final String CHATDETAILS = "yem_pc_chatdetails";
    public static final String TRANSMITS = "yem_pc_transmit";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey().toLowerCase();
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        String yemPruniqecode = (String)model.getValue("yem_pruniqecode");
        switch (itemKey) {
            case "yem_clearup": {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("yemPurchasecode", yemPruniqecode);
                this.showForm(map, CHATDETAILS);
                break;
            }
            case "yem_clarrecord": {
                this.openViewProxy(yemPruniqecode);
                break;
            }
            case "yem_transmit": {
                this.showForm(new HashMap<String, Object>(), TRANSMITS);
            }
        }
    }

    private void showForm(Map<String, Object> map, String formid) {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(formid);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formid);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParams(map);
        view.showForm(showParameter);
    }

    private void openViewProxy(String yemPruniqecode) {
        IFormView view = this.getView();
        String pageId = view.getPageId();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        HashMap<String, Object> actionParam = new HashMap<String, Object>(8);
        actionParam.put("formId", "yem_pc_planchat");
        HashMap<String, Object> params = new HashMap<String, Object>();
        ArrayList<String> billNo = new ArrayList<String>();
        billNo.add(yemPruniqecode);
        params.put("pageId", pageId);
        params.put("billno", billNo);
        actionParam.put("params", params);
        proxy.addAction("showSlideBill", actionParam);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IDataModel model = this.getModel();
        String number = (String)model.getValue("billno");
        this.fixStatus(number);
    }

    private void fixStatus(String number) {
        DynamicObject[] load;
        for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"yem_pc_tramitdetais", (String)"yem_isread", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)})) {
            dynamicObject.set("yem_isread", (Object)"A");
        }
        SaveServiceHelper.update((DynamicObject[])load);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Map returnData = (Map)e.getReturnData();
        switch (actionId) {
            case "yem_pc_chatdetails": {
                this.getView().invokeOperation("refresh");
                break;
            }
            case "yem_pc_transmit": {
                if (!YEM.isNotEmpty((Object)returnData)) break;
                this.addPsscTramitDetails(returnData);
            }
        }
    }

    private void addPsscTramitDetails(Map returnData) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObjectCollection loads = (DynamicObjectCollection)returnData.get("yem_tramituser");
        long currentUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)String.valueOf(currentUserId));
        Object yemTramitdesc = returnData.get("yem_tramitdesc");
        for (DynamicObject load : loads) {
            DynamicObject tramitdetais = BusinessDataServiceHelper.newDynamicObject((String)"yem_pc_tramitdetais");
            tramitdetais.set("yem_pruniqecode", model.getValue("yem_pruniqecode"));
            tramitdetais.set("yem_tramituser", (Object)currentUser);
            tramitdetais.set("yem_betramituser", (Object)load.getDynamicObject(1));
            tramitdetais.set("yem_tramitmateriel", model.getValue("yem_tramitmateriel"));
            tramitdetais.set("yem_description", yemTramitdesc);
            tramitdetais.set("yem_isread", (Object)"B");
            tramitdetais.set("billstatus", (Object)"A");
            OperationServiceHelper.executeOperate((String)"save", (String)"yem_pc_tramitdetais", (DynamicObject[])new DynamicObject[]{tramitdetais});
        }
    }
}

