/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pc.common.moudle.task.bill;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.base.common.utils.YEM;

public class PcViewLogBillPlugin
extends AbstractBillPlugIn
implements HyperLinkClickListener {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        this.setSlideBill(proxy);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            IFormView view = this.getView();
            switch (operateKey) {
                case "yem_viewreqflow": {
                    break;
                }
                case "logquery": {
                    DynamicObject dataEntity = view.getModel().getDataEntity();
                    String billId = String.valueOf(dataEntity.getPkValue());
                    String billno = dataEntity.getString("yem_prnum");
                    IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
                    HashMap<String, Object> actionParam = new HashMap<String, Object>(8);
                    actionParam.put("formId", "yem_pc_log");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("pkId", billId);
                    params.put("billno", billno);
                    actionParam.put("params", params);
                    proxy.addAction("showSlideBill", actionParam);
                    break;
                }
            }
        }
    }

    private void setSlideBill(IClientViewProxy proxy) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("direction", "right");
        map.put("formId", "yem_pc_log");
        map.put("visualStyle", "newDesign");
        HashMap<String, Integer> offset = new HashMap<String, Integer>();
        offset.put("top", 82);
        map.put("offsetInAllDC", offset);
        HashMap<String, String> borderRadius = new HashMap<String, String>();
        borderRadius.put("borderRadius", "2px");
        borderRadius.put("boxShadow", "0px 9px 24px 6px rgb(0 0 0 / 10%)");
        borderRadius.put("height", "calc(100% - 82px)");
        map.put("style", borderRadius);
        proxy.addAction("setSlideBillFormId", map);
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getView().getControl("yem_pc_rwc_zxmx");
        entryGrid.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent arg) {
        IFormView view = this.getView();
        String fieldName = arg.getFieldName();
        if ("yem_oddnumber".equals(fieldName)) {
            IDataModel model = this.getModel();
            int rowIndex = model.getEntryCurrentRowIndex("yem_pc_rwc_zxmx");
            String oddNumber = (String)model.getValue("yem_oddnumber", rowIndex);
            DynamicObject pushbilltype = (DynamicObject)model.getValue("yem_pushbilltype", rowIndex);
            if (oddNumber != null && !oddNumber.isEmpty()) {
                QFilter filter = new QFilter("billno", "=", (Object)oddNumber);
                DynamicObject billData = BusinessDataServiceHelper.loadSingle((String)pushbilltype.getString("number"), (QFilter[])filter.toArray());
                if (!YEM.isEmpty((Object)billData)) {
                    BillShowParameter showParameter = new BillShowParameter();
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setFormId(pushbilltype.getString("number"));
                    showParameter.setPkId(billData.getPkValue());
                    view.showForm((FormShowParameter)showParameter);
                } else {
                    view.showTipNotification(String.format("\u672a\u627e\u5230\u5bf9\u5e94%s\u5355\u4fe1\u606f\uff01", pushbilltype.getString("name")));
                }
            }
        }
    }
}

