/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pc.common.moudle.task.list;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.portal.util.SerializationUtils;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.StringUtils;
import yem.base.common.utils.YEM;
import yem.wm.pc.common.utils.PcRequestTaskUtil;

public class PcMyReuireTaskListPlugin
extends AbstractListPlugin
implements Plugin {
    public static final String PSSCDETAILS = "yem_pc_chatdetails";
    public static final String TRANSMITS = "yem_pc_transmit";
    public static final String KEY_CHANGEBILL = "yem_pc_changebill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        this.setSlideBill(proxy);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName;
        IDataModel model = this.getModel();
        IListView view = (IListView)this.getView();
        switch (fieldName = args.getFieldName()) {
            case "yem_attachmentcount": {
                DynamicObject dataEntity;
                String yemSrcbillid;
                args.setCancel(true);
                ListSelectedRow curowselect = view.getCurrentSelectedRowInfo();
                Object pkId = curowselect.getPrimaryKeyValue();
                if (pkId == null || "0".equals(pkId.toString()) || (yemSrcbillid = (dataEntity = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"yem_pc_reqpooltpl")).getString("yem_srcbillid")) == null || "0".equals(yemSrcbillid)) break;
                DynamicObject reqBill = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(yemSrcbillid), (String)"yem_pc_requirapplybill");
                this.showForm(reqBill.getLong("id"));
                break;
            }
            case "yem_attachcount": 
            case "yem_attachname": 
            case "yem_clarifyrecordnum": 
            case "yem_rejectionsnum": {
                args.setCancel(true);
                IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
                HashMap<String, Object> actionParam = new HashMap<String, Object>(8);
                actionParam.put("formId", "yem_pc_planchat");
                HashMap<String, Object> params = new HashMap<String, Object>();
                ArrayList objects = new ArrayList();
                LinkedHashSet<String> billNo = new LinkedHashSet<String>();
                ListSelectedRow curowinfo = view.getCurrentSelectedRowInfo();
                Object billId = curowinfo.getPrimaryKeyValue();
                DynamicObject purObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"yem_pc_reqpooltpl");
                this.byBillDoAction(purObject, billNo, billId);
                if ("yem_rejectionsnum".equals(fieldName)) {
                    params.put("yem_chatdetailtype", "B");
                }
                params.put("pkId", objects);
                params.put("billno", billNo);
                actionParam.put("params", params);
                proxy.addAction("showSlideBill", actionParam);
            }
        }
    }

    private void showForm(Object billId) {
        IFormView view = this.getView();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss style = new StyleCss();
        style.setWidth("1000");
        style.setHeight("600");
        showParameter.getOpenStyle().setInlineStyleCss(style);
        showParameter.setFormId("yem_pc_reqattapanel");
        showParameter.setPkId(billId);
        view.showForm((FormShowParameter)showParameter);
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> purCodeIds = new HashMap<String, Object>();
        for (int i = 0; i < selectedRows.size(); ++i) {
            ListSelectedRow selectedRow = selectedRows.get(i);
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            map.put(String.valueOf(i), primaryKeyValue);
            DynamicObject purObject = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"yem_pc_reqpooltpl");
            if (purObject == null) continue;
            String number = purObject.getString("yem_number");
            map.put("yemPurchasecode", number);
            purCodeIds.put(number, primaryKeyValue);
        }
        if (map.size() > 0 && !StringUtils.isEmpty((String)(itemKey = evt.getItemKey().toLowerCase()))) {
            switch (itemKey) {
                case "yem_clearup": {
                    if (selectedRows.size() > 1) {
                        map.put("purCodeIds", purCodeIds);
                    }
                    this.showForm(map, PSSCDETAILS);
                    this.addDetails(map);
                    break;
                }
                case "yem_clarrecord": {
                    if (selectedRows.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u6f84\u6e05\u8bf4\u660e\uff01\uff01\uff01", (String)"PscMyReuireTaskListPlugin_1", (String)"yem-pur", (Object[])new Object[0]));
                        return;
                    }
                    this.openClarfication(selectedRows);
                    break;
                }
                case "yem_change": {
                    String taskIdString;
                    DynamicObject[] selectDatas = PcRequestTaskUtil.getSelectDatas(this.getView());
                    HashMap<String, Object> changeMap = new HashMap<String, Object>();
                    ArrayList<Long> billAndEntryIds = new ArrayList<Long>();
                    List taskBillIds = Arrays.stream(selectDatas).map(s -> s.getLong("id")).collect(Collectors.toList());
                    for (DynamicObject dynamicObject : selectDatas) {
                        if (dynamicObject.getBoolean("yem_taskclose")) continue;
                        String yemSrcbillid = dynamicObject.getString("yem_srcbillid");
                        String yemSrcentryid = dynamicObject.getString("yem_srcentryid");
                        Object id = changeMap.get("pkId");
                        if (id != null && !yemSrcbillid.equals(id.toString())) {
                            this.getView().showTipNotification("\u53ea\u80fd\u9009\u62e9\u540c\u4e00\u4e2a\u9700\u6c42\u6765\u6e90\u7684\u4efb\u52a1\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\uff01");
                            return;
                        }
                        billAndEntryIds.add(Long.parseLong(yemSrcentryid));
                        if (!changeMap.isEmpty()) continue;
                        changeMap.put("pkId", Long.parseLong(yemSrcbillid));
                    }
                    changeMap.put("entryIds", billAndEntryIds);
                    String pkId = String.valueOf(changeMap.get("pkId"));
                    QFilter filter = new QFilter("yem_srcbillid", "=", (Object)pkId);
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)KEY_CHANGEBILL, (String)"billstatus,yem_pc_bgdj_bgfl.yem_purchasecode,yem_pc_bgdj_bgfl.yem_srcbillentryid", (QFilter[])new QFilter[]{filter});
                    if (load != null) {
                        for (DynamicObject object : load) {
                            String billstatus = object.getString("billstatus");
                            if ("C".equals(billstatus)) continue;
                            DynamicObjectCollection yemPscBgdjBgfl = object.getDynamicObjectCollection("yem_pc_bgdj_bgfl");
                            Map<String, String> collect = yemPscBgdjBgfl.stream().collect(Collectors.toMap(v -> v.getString("yem_srcbillentryid"), s -> s.getString("yem_purchasecode"), (existing, replacement) -> existing));
                            Set<String> billEntryIds = collect.keySet();
                            StringBuilder sb = new StringBuilder();
                            for (Object e : billAndEntryIds) {
                                String entryId;
                                if (e == null || !billEntryIds.contains(entryId = e.toString())) continue;
                                sb.append(collect.get(entryId)).append("\u3001");
                            }
                            if (sb.length() <= 0) continue;
                            sb.deleteCharAt(sb.length() - 1);
                            this.getView().showTipNotification(String.format("\u9700\u6c42\u552f\u4e00\u7801\uff1a%s\u5df2\u7ecf\u5b58\u5728\u53d8\u66f4\u5355\uff0c\u65e0\u6cd5\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\uff01", sb));
                            return;
                        }
                    }
                    ObjectMapper objectMapper = new ObjectMapper();
                    try {
                        taskIdString = objectMapper.writeValueAsString(taskBillIds);
                    }
                    catch (JsonProcessingException e) {
                        taskIdString = "";
                    }
                    changeMap.put("yem_planinitiaids", taskIdString);
                    changeMap.put("editsource", "task");
                    this.showForm(changeMap);
                    break;
                }
                case "yem_changehistory": {
                    if (selectedRows.size() > 1) {
                        this.getView().showTipNotification("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u67e5\u770b\u53d8\u66f4\u8bb0\u5f55");
                        return;
                    }
                    DynamicObject[] viewSelectDatas = PcRequestTaskUtil.getSelectDatas(this.getView());
                    HashMap<String, Object> viewChangeMap = new HashMap<String, Object>();
                    for (DynamicObject selectData : viewSelectDatas) {
                        String yemSrcbillid = selectData.getString("yem_srcbillid");
                        viewChangeMap.put("pkId", Long.parseLong(yemSrcbillid));
                    }
                    PcRequestTaskUtil.openPurchaseList(this.getView(), viewChangeMap);
                    break;
                }
                case "yem_transmit": {
                    if (selectedRows.size() > 1) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u8f6c\u4ea4\u8bf4\u660e\uff01\uff01\uff01", (String)"PscMyReuireTaskListPlugin_2", (String)"yem-pur", (Object[])new Object[0]));
                        return;
                    }
                    this.showForm(new HashMap<String, Object>(), TRANSMITS);
                    break;
                }
            }
        }
    }

    private void showForm(Map<String, Object> map) {
        IFormView view = this.getView();
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(KEY_CHANGEBILL);
        showParameter.setCustomParams(map);
        view.showForm((FormShowParameter)showParameter);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return;
        }
        if ("yem_querywms".equals(operateKey) && operationResult.isSuccess()) {
            HashMap<String, Set> params = new HashMap<String, Set>();
            HashMap<String, Set> paramsName = new HashMap<String, Set>();
            for (ListSelectedRow selectedRow : selectedRows) {
                Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
                DynamicObject purObject = BusinessDataServiceHelper.loadSingleFromCache((Object)primaryKeyValue, (String)"yem_pc_reqpooltpl");
                if (purObject == null) continue;
                DynamicObject material = purObject.getDynamicObject("yem_material");
                DynamicObject org = purObject.getDynamicObject("yem_purorg");
                String materialDesc = purObject.getString("yem_materialdesc");
                if (org == null) continue;
                String number = org.getString("number");
                String orgType = "";
                if ("4030".equals(number)) {
                    orgType = "KFM";
                } else if ("CD01-T".equals(number)) {
                    orgType = "TFM";
                } else {
                    throw new KDBizException("\u7ec4\u7ec7\u8bf7\u9009\u62e94030\u6216CD01-T\uff01\uff01\uff01");
                }
                if (material != null) {
                    String string = material.getString("number");
                    Set orDefault = params.getOrDefault(orgType, new HashSet());
                    orDefault.add(string);
                    params.put(orgType, orDefault);
                }
                if (!YEM.isNotEmpty((Object)materialDesc)) continue;
                Set orDefault = paramsName.getOrDefault(orgType, new HashSet());
                orDefault.add(materialDesc);
                paramsName.put(orgType, orDefault);
            }
            if (YEM.isNotEmpty(params) || YEM.isNotEmpty(paramsName)) {
                ReportShowParameter formShowParameter = new ReportShowParameter();
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("params", (Object)SerializationUtils.toJsonString(params));
                formShowParameter.setCustomParam("paramsName", (Object)SerializationUtils.toJsonString(paramsName));
                formShowParameter.setFormId("yem_pc_queryquantity");
                StyleCss styleCss = new StyleCss();
                styleCss.setWidth("1000");
                styleCss.setHeight("600");
                formShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    private void openClarfication(ListSelectedRowCollection selectedRows) {
        IFormView view = this.getView();
        IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
        HashMap<String, Object> actionParam = new HashMap<String, Object>(8);
        actionParam.put("formId", "yem_pc_planchat");
        HashMap<String, AbstractCollection> params = new HashMap<String, AbstractCollection>();
        ArrayList<String> objects = new ArrayList<String>();
        LinkedHashSet<String> billNo = new LinkedHashSet<String>();
        for (int i = 0; i < selectedRows.size(); ++i) {
            Object billId = selectedRows.get(i).getPrimaryKeyValue();
            objects.add(String.valueOf(billId));
            DynamicObject purObject = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"yem_pc_reqpooltpl");
            this.byBillDoAction(purObject, billNo, billId);
        }
        params.put("pkId", objects);
        params.put("billno", billNo);
        actionParam.put("params", params);
        proxy.addAction("showSlideBill", actionParam);
    }

    private void byBillDoAction(DynamicObject purObject, Set<String> billNo, Object billId) {
        String number = purObject.getString("yem_number");
        billNo.add(number);
        DynamicObject[] load = BusinessDataServiceHelper.load((String)PSSCDETAILS, (String)"yem_specifics,creator,createtime", (QFilter[])new QFilter[]{new QFilter("yem_purchasecode", "=", (Object)number)});
        if (YEM.isEmpty((Object)load)) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)String.valueOf(billId), (String)"yem_pc_reqpooltpl");
            PcMyReuireTaskListPlugin.createChatDetail(dynamicObject, number);
        }
    }

    public static void createChatDetail(DynamicObject reqPoolData, String number) {
        DynamicObject yemReportuser = reqPoolData.getDynamicObject("yem_reportuser");
        DynamicObject creator = reqPoolData.getDynamicObject("creator");
        DynamicObject psscdetails = BusinessDataServiceHelper.newDynamicObject((String)PSSCDETAILS);
        psscdetails.set("billstatus", (Object)"A");
        psscdetails.set("createtime", reqPoolData.get("createtime"));
        if (YEM.isNotEmpty((Object)reqPoolData.get("yem_material"))) {
            psscdetails.set("yem_specifics", reqPoolData.get("yem_material.name"));
        } else {
            psscdetails.set("yem_specifics", reqPoolData.get("yem_materialdesc"));
        }
        psscdetails.set("yem_user", (Object)(yemReportuser == null ? creator : yemReportuser));
        psscdetails.set("yem_purchasecode", (Object)number);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{psscdetails});
        DynamicObjectCollection attacs = reqPoolData.getDynamicObjectCollection("yem_attachment");
        if (YEM.isNotEmpty((Object)attacs)) {
            for (DynamicObject attac : attacs) {
                DynamicObject fbasedataid = attac.getDynamicObject("fbasedataid");
                DynamicObject newAtt = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
                Long attaId = ORM.create().genLongId("bos_attachment");
                newAtt.set("fnumber", (Object)attaId);
                newAtt.set("FBillType", (Object)PSSCDETAILS);
                newAtt.set("FInterID", (Object)psscdetails.getLong("id"));
                newAtt.set("FModifyTime", fbasedataid.get("modifytime"));
                newAtt.set("finterid", psscdetails.getPkValue());
                newAtt.set("fcreatetime", fbasedataid.get("createtime"));
                newAtt.set("FaliasFileName", fbasedataid.get("name"));
                newAtt.set("FAttachmentName", fbasedataid.get("name"));
                newAtt.set("FFileId", fbasedataid.get("url"));
                newAtt.set("FExtName", fbasedataid.get("type"));
                newAtt.set("FATTACHMENTSIZE", fbasedataid.get("size"));
                newAtt.set("FCREATEMEN", fbasedataid.get("creator"));
                newAtt.set("fattachmentpanel", (Object)"attachmentpanel");
                newAtt.set("fdescription", fbasedataid.get("description"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAtt});
            }
        }
    }

    private void showForm(Map<String, Object> map, String formid) {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(formid);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, formid);
        showParameter.setCloseCallBack(closeCallBack);
        showParameter.setCustomParams(map);
        view.showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Map returnData = (Map)e.getReturnData();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        int rowKey = selectedRows.getRowKeys()[0];
        switch (actionId) {
            case "yem_pc_chatdetails": {
                break;
            }
            case "yem_pc_transmit": {
                if (!YEM.isNotEmpty((Object)returnData)) break;
                this.addPsscTramitDetails(returnData, rowKey);
            }
        }
    }

    private void addPsscTramitDetails(Map returnData, int rowKey) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        BillList billList = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        DynamicObjectCollection loads = (DynamicObjectCollection)returnData.get("yem_tramituser");
        long currentUserId = UserServiceHelper.getCurrentUserId();
        DynamicObject currentUser = UserServiceHelper.getCurrentUser((String)String.valueOf(currentUserId));
        Object yemTramitdesc = returnData.get("yem_tramitdesc");
        Object[] primaryKeyValues = selectedRows.getPrimaryKeyValues();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)primaryKeyValues[0], (String)"yem_pc_reqpooltpl");
        for (DynamicObject load : loads) {
            DynamicObject tramitdetais = BusinessDataServiceHelper.newDynamicObject((String)"yem_pc_tramitdetais");
            tramitdetais.set("yem_pruniqecode", (Object)dynamicObject.getString("yem_number"));
            tramitdetais.set("yem_tramituser", (Object)currentUser);
            tramitdetais.set("yem_betramituser", (Object)load.getDynamicObject(1));
            tramitdetais.set("yem_tramitmateriel", dynamicObject.get("yem_material"));
            tramitdetais.set("yem_description", yemTramitdesc);
            tramitdetais.set("yem_isread", (Object)"B");
            tramitdetais.set("billstatus", (Object)"A");
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"yem_pc_tramitdetais", (DynamicObject[])new DynamicObject[]{tramitdetais});
        }
    }

    private void addDetails(Map<String, Object> map) {
        Map purCodeIds = (Map)map.get("purCodeIds");
        if (purCodeIds != null) {
            for (Map.Entry entry : purCodeIds.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                this.addDetailsByCodeAndPkValue(key, value);
            }
        } else {
            String yemPurchasecode = String.valueOf(map.get("yemPurchasecode"));
            Object pk = map.get("0");
            this.addDetailsByCodeAndPkValue(yemPurchasecode, pk);
        }
    }

    private void addDetailsByCodeAndPkValue(String yemPurchasecode, Object pk) {
        DynamicObject[] load = BusinessDataServiceHelper.load((String)PSSCDETAILS, (String)"yem_specifics,creator,createtime", (QFilter[])new QFilter[]{new QFilter("yem_purchasecode", "=", (Object)yemPurchasecode)});
        if (YEM.isEmpty((Object)load) && load.length <= 0) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pk, (String)"yem_pc_reqpooltpl");
            PcMyReuireTaskListPlugin.createChatDetail(dynamicObject, dynamicObject.getString("yem_number"));
        }
    }

    private void setSlideBill(IClientViewProxy proxy) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put("direction", "right");
        map.put("formId", "yem_pc_planchat");
        map.put("visualStyle", "newDesign");
        HashMap<String, Integer> offset = new HashMap<String, Integer>();
        offset.put("top", 82);
        map.put("offsetInAllDC", offset);
        HashMap<String, String> borderRadius = new HashMap<String, String>();
        borderRadius.put("borderRadius", "2px");
        borderRadius.put("boxShadow", "0px 9px 24px 6px rgb(0 0 0 / 10%)");
        borderRadius.put("height", "calc(100% - 82px)");
        map.put("style", borderRadius);
        proxy.addAction("setSlideBillFormId", map);
    }
}

