/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pc.common.moudle.task.list;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.YEM;
import yem.wm.pc.common.utils.PcRequestTaskUtil;

public class PcReqpooltplListPlugin
extends AbstractListPlugin
implements Plugin {
    private static final Log log = LogFactory.getLog(PcReqpooltplListPlugin.class);
    private static final String PSC_EXECUTION = "yem_psc_execution";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"yem_confirmexe"});
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if ("yem_contractnum".equals(args.getFieldName()) && args.getHyperLinkClickEvent() instanceof BillListHyperLinkClickEvent) {
            IFormView view = this.getView();
            args.setCancel(true);
            BillListHyperLinkClickEvent linkClickEvent = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
            long pkId = (Long)linkClickEvent.getCurrentRow().getPrimaryKeyValue();
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)pkId, (String)"yem_psc_reqpooltpl");
            if (bill != null) {
                DynamicObject material = bill.getDynamicObject("yem_material");
                DynamicObject purorg = bill.getDynamicObject("yem_purorg");
                if (purorg != null && material != null) {
                    material = BusinessDataServiceHelper.loadSingle((Object)material.getPkValue(), (String)material.getDynamicObjectType().getName());
                    String orgNum = purorg.getString("number");
                    String jsonStr = material.getString("yem_contractnos_tag");
                    if (YEM.isNotEmpty((Object)jsonStr)) {
                        try {
                            JSONObject jsonObject = JSON.parseObject((String)jsonStr);
                            JSONArray jsonArray = jsonObject.getJSONArray("framebillno");
                            if (jsonArray != null && !jsonArray.isEmpty()) {
                                QFilter filter = new QFilter("billno", "in", (Object)jsonArray);
                                ListShowParameter showParameter = new ListShowParameter();
                                showParameter.setBillFormId("conm_purcontract");
                                showParameter.setFormId("bos_listf7");
                                showParameter.setStatus(OperationStatus.VIEW);
                                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                                showParameter.getListFilterParameter().getQFilters().add(filter);
                                view.showForm((FormShowParameter)showParameter);
                            }
                        }
                        catch (Exception e) {
                            log.error("\u5408\u540c\u8df3\u8f6c\u5f02\u5e38\uff1a", (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs e) {
        super.beforeCreateListDataProvider(e);
        e.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dynObjs = super.getData(start, limit);
                dynObjs.forEach(v -> {
                    String contractnos = v.getString("yem_material.yem_contractnos_t");
                    if (YEM.isNotEmpty((Object)contractnos)) {
                        v.set("yem_contractnum", (Object)contractnos);
                    }
                });
                return dynObjs;
            }
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        MessageBoxResult result = messageBoxClosedEvent.getResult();
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("srcDemandOrder".equals(callBackId) && result == MessageBoxResult.Yes) {
            this.getPageCache().put("isConfirmCallBackYes", "Y");
            this.getView().invokeOperation(this.getPageCache().get("operateKey"));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        IFormView view = this.getView();
        IDataModel model = view.getModel();
        DynamicObject[] selectDatas = PcRequestTaskUtil.getSelectDatas(this.getView());
        switch (operateKey) {
            case "yem_reqpoolcontract": 
            case "yem_reqordercontract": 
            case "yem_reqorderbulkcon": 
            case "contractquery": 
            case "push_source": {
                StringBuilder sb = new StringBuilder();
                for (DynamicObject entity : selectDatas) {
                    DynamicObject yemMaterial = entity.getDynamicObject("yem_material");
                    String yemNumber = entity.getString("yem_number");
                    String yemSrcentryid = entity.getString("yem_srcentryid");
                    if (!YEM.isNotEmpty((Object)yemSrcentryid)) continue;
                    QFilter filter = new QFilter("yem_src_wlsq_mxxx.yem_reqbillentryid", "=", (Object)Long.parseLong(yemSrcentryid));
                    filter.and("yem_src_wlsq_mxxx.yem_confrmstatus", "=", (Object)"A");
                    DynamicObject[] srcMaterialApply = BusinessDataServiceHelper.load((String)"yem_src_materialapply", (String)"billno", (QFilter[])filter.toArray());
                    if (yemMaterial != null && (srcMaterialApply == null || srcMaterialApply.length <= 0)) continue;
                    sb.append(yemNumber).append("\u3001");
                }
                if (sb.length() > 0) {
                    sb.deleteCharAt(sb.length() - 1);
                    if ("push_source".equals(operateKey) && !"Y".equals(this.getPageCache().get("isConfirmCallBackYes"))) {
                        this.getPageCache().put("operateKey", operate.getOperateKey());
                        ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener("srcDemandOrder", (IFormPlugin)this);
                        view.showConfirm(String.format("\u4efb\u52a1\u9700\u6c42\u552f\u4e00\u7801%s\uff0c\u7269\u6599\u7533\u8bf7\u5355 \u672a\u7533\u8bf7/\u672a\u786e\u8ba4\uff0c\u662f\u5426\u8fdb\u884c\u5bfb\u6e90\u7acb\u9879\uff1f", sb), MessageBoxOptions.YesNo, confirmCallBackListener);
                        args.setCancel(true);
                    } else if (!"push_source".equals(operateKey)) {
                        view.showTipNotification(String.format("\u4efb\u52a1\u9700\u6c42\u552f\u4e00\u7801%s\uff0c\u7269\u6599\u7533\u8bf7\u5355 \u672a\u7533\u8bf7/\u672a\u786e\u8ba4\uff0c\u8bf7\u5148\u8fdb\u884c\u7269\u6599\u7533\u8bf7\uff01", sb));
                        args.setCancel(true);
                    }
                }
                this.getPageCache().remove("isConfirmCallBackYes");
                break;
            }
            case "yem_confirmexe": {
                StringBuilder errors = new StringBuilder();
                for (DynamicObject selectBill : selectDatas) {
                    DynamicObjectCollection collection = selectBill.getDynamicObjectCollection("yem_psc_rwc_zxmx");
                    List collect = collection.stream().filter(s -> !"B".equals(s.getString("yem_excutestatus"))).collect(Collectors.toList());
                    if (!YEM.isNotEmpty(collect)) continue;
                    errors.append(selectBill.getString("yem_number")).append("\u3001");
                }
                if (errors.length() <= 0) break;
                errors.deleteCharAt(errors.length() - 1);
                view.showTipNotification(String.format("\u4efb\u52a1\u9700\u6c42\u552f\u4e00\u7801%s\uff0c\u5df2\u6709\u5411\u4e0b\u6267\u884c\uff0c\u65e0\u6cd5\u4fee\u6539\u6267\u884c\u65b9\u5f0f\uff01", errors));
                args.setCancel(true);
                break;
            }
            case "push_mall": {
                long count = Arrays.stream(selectDatas).map(v -> v.getDynamicObject("yem_purorg").getPkValue()).distinct().count();
                if (count == 1L) break;
                view.showTipNotification("\u9009\u4e2d\u6570\u636e\u6709\u4e0d\u540c\u9700\u6c42\u6765\u6e90\u7c7b\u578b\u6570\u636e\uff0c\u65e0\u6cd5\u4e0b\u63a8\u751f\u6210\u7535\u5546\u5408\u540c");
                args.setCancel(true);
                break;
            }
            case "yem_pushmallel": {
                List collect = Arrays.stream(selectDatas).filter(v -> !"mall".equals(v.getString("yem_purmethod"))).map(v -> v.getString("yem_number")).collect(Collectors.toList());
                if (!YEM.isNotEmpty(collect)) break;
                view.showTipNotification(String.format("\u9700\u6c42\u552f\u4e00\u7801\uff1a%s\uff0c\u6267\u884c\u65b9\u5f0f\u4e0d\u4e3a\u3010\u7535\u5546\u3011\uff0c\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", String.join((CharSequence)"\u3001", collect)));
                args.setCancel(true);
                break;
            }
            case "yem_frameorder": {
                List stringList = Arrays.stream(selectDatas).filter(v -> !"order".equals(v.getString("yem_purmethod"))).map(v -> v.getString("yem_number")).collect(Collectors.toList());
                if (!YEM.isNotEmpty(stringList)) break;
                view.showTipNotification(String.format("\u9700\u6c42\u552f\u4e00\u7801\uff1a%s\uff0c\u6267\u884c\u65b9\u5f0f\u4e0d\u4e3a\u3010\u6846\u67b6\u5408\u540c\u4e0b\u5355\u3011\uff0c\u6267\u884c\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5\uff01", String.join((CharSequence)"\u3001", stringList)));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        IFormView view = this.getView();
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        switch (operateKey) {
            case "yem_confirmexe": {
                if (this.isExcute(selectedRows, view, operationResult)) {
                    return;
                }
                this.showForm(new HashMap<String, Object>(), PSC_EXECUTION);
                break;
            }
            case "yem_sourcing": {
                if (this.isExcute(selectedRows, view, operationResult)) {
                    return;
                }
                this.openPurchaseList();
                break;
            }
            case "yem_reqpoolcontract": {
                if (this.isExcute(selectedRows, view, operationResult)) {
                    return;
                }
                this.reqPoolContract("yem_psc_reqpoolcontract", false);
                break;
            }
            case "yem_reqordercontract": {
                if (this.isExcute(selectedRows, view, operationResult)) {
                    return;
                }
                this.reqPoolContract("yem_psc_reqordercontract", false);
                break;
            }
            case "yem_reqorderbulkcon": {
                if (this.isExcute(selectedRows, view, operationResult)) {
                    return;
                }
                this.reqPoolContract("yem_psc_reqordercontract", true);
                break;
            }
            case "contractquery": {
                if (this.isExcute(selectedRows, view, operationResult)) {
                    return;
                }
                this.reqPoolContractExt();
                break;
            }
            case "yem_pushmallel": {
                if (this.isExcute(selectedRows, view, operationResult)) {
                    return;
                }
                this.reqPoolContract("yem_psc_reqordereltype", false);
                break;
            }
            case "yem_frameorder": {
                if (this.isExcute(selectedRows, view, operationResult)) {
                    return;
                }
                this.reqPoolContract("yem_psc_reqframeorder", false);
            }
        }
    }

    private boolean isExcute(ListSelectedRowCollection selectedRows, IFormView view, OperationResult operationResult) {
        if (selectedRows == null || selectedRows.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u52fe\u9009\u6570\u636e\u540e\u518d\u8fdb\u884c\u64cd\u4f5c", (String)"PscReqpooltplListPlugin_0", (String)"yem-pur", (Object[])new Object[0]));
            return true;
        }
        return !operationResult.isSuccess();
    }

    private void reqPoolContractExt() {
        IFormView view = this.getView();
        DynamicObject[] selectDatas = PcRequestTaskUtil.getSelectDatas(view);
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject selectData : selectDatas) {
            jsonArray.add(selectData.getPkValue());
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setCaption("\u6309\u5408\u540c\u67e5\u8be2");
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("yem_psc_reqpoolcontract");
        showParameter.setCustomParam("selectIds", (Object)jsonArray);
        showParameter.setCustomParam("xianshi", (Object)"xianshi");
        view.showForm(showParameter);
    }

    private void reqPoolContract(String entityName, boolean isBulk) {
        IFormView view = this.getView();
        DynamicObject[] selectDatas = PcRequestTaskUtil.getSelectDatas(view);
        JSONArray jsonArray = new JSONArray();
        for (DynamicObject selectData : selectDatas) {
            jsonArray.add(selectData.getPkValue());
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId(entityName);
        showParameter.setCustomParam("selectIds", (Object)jsonArray);
        showParameter.setCustomParam("isBulk", (Object)isBulk);
        view.showForm(showParameter);
    }

    private void showForm(Map<String, Object> map, String showFormKey) {
        IFormView view = this.getView();
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setStatus(OperationStatus.ADDNEW);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId(showFormKey);
        showParameter.setCustomParams(map);
        CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, showFormKey);
        showParameter.setCloseCallBack(callBack);
        view.showForm(showParameter);
    }

    private void openPurchaseList() {
        ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"src_demand", (boolean)false, (int)0, (boolean)true);
        listShowParameter.setBillFormId("src_demand");
        listShowParameter.setLookUp(true);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Map returnData = (Map)e.getReturnData();
        switch (actionId) {
            case "yem_psc_execution": {
                if (!YEM.isNotEmpty((Object)returnData)) break;
                this.getView().showSuccessNotification(String.format(ResManager.loadKDString((String)"\u786e\u8ba4\u6267\u884c\u65b9\u5f0f\u6210\u529f\uff01\u5904\u7406\u4efb\u52a1\u6570\uff1a%s", (String)"PscReqpooltplListPlugin_1", (String)"yem-pur", (Object[])new Object[0]), returnData.get("number")));
                this.getView().invokeOperation("refresh");
            }
        }
    }
}

