/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pc.common.moudle.task.list;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.YEM;
import yem.wm.pc.common.utils.Enum.PcDemandStateEnum;

public class PcTaskManageListPlugin
extends AbstractListPlugin
implements Plugin,
TabSelectListener {
    private static final String MINE_REQUIRE_TASK = "yem_pc_myrequiretask";
    private static final String REQUIRE_TASK_MANAGER = "yem_pc_requirtaskbill";
    private static final String PUR_TASK_MANAGER = "yem_pc_taskmanage";
    private static final String MINE_PUR_TASK_MANAGER = "yem_pc_mypurtask";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        IListView listView = (IListView)this.getView();
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        if ("yem_pending".equals(currentTab)) {
            listView.setEnable(Boolean.valueOf(false), new String[]{"yem_sources", "yem_reqpoolcontract", "push_project", "push_mall", "yem_pushmallel"});
        }
    }

    public void registerListener(EventObject e) {
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        BillList billlist = (BillList)this.getControl("billlistap");
        String entityId = billlist.getEntityId();
        Tab tab = (Tab)this.getControl("tabap");
        String currentTab = tab.getCurrentTab();
        IFormView view = this.getView();
        switch (entityId) {
            case "yem_pc_requirtaskbill": 
            case "yem_pc_myrequiretask": {
                view.setVisible(Boolean.valueOf(false), new String[]{"yem_alreject"});
                view.setVisible(Boolean.valueOf(false), new String[]{"yem_toallocate"});
                break;
            }
            case "yem_pc_taskmanage": {
                view.setVisible(Boolean.valueOf(false), new String[]{"yem_toallocate"});
                view.setVisible(Boolean.valueOf(false), new String[]{"yem_partorder"});
                break;
            }
            case "yem_pc_mypurtask": {
                view.setVisible(Boolean.valueOf(true), new String[]{"yem_toallocate"});
                view.setVisible(Boolean.valueOf(false), new String[]{"yem_partorder"});
                break;
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        BillList billlist = (BillList)this.getControl("billlistap");
        String entityId = billlist.getEntityId();
        List qFilters = e.getQFilters();
        Tab tab = (Tab)this.getView().getControl("tabap");
        String currentTab = tab.getCurrentTab();
        String defaultTabKey = currentTab != null && !currentTab.isEmpty() ? currentTab : "yem_pending";
        List<Object> states = new ArrayList();
        long currentUserId = YEM.getCurrentUserId();
        ArrayList<Long> administrators = new ArrayList<Long>();
        QFilter settingFilter = new QFilter("yem_issingle", "=", (Object)true);
        DynamicObject reqSet = BusinessDataServiceHelper.loadSingle((String)"yem_pc_servicepara", (String)"yem_reqtaskmanager", (QFilter[])new QFilter[]{settingFilter});
        if (reqSet != null) {
            DynamicObjectCollection yemReqtaskmanager = reqSet.getDynamicObjectCollection("yem_reqtaskmanager");
            for (DynamicObject manager : yemReqtaskmanager) {
                DynamicObject fbasedataid = manager.getDynamicObject("fbasedataid");
                if (fbasedataid == null) continue;
                administrators.add(fbasedataid.getLong("id"));
            }
        }
        QFilter filter = null;
        if ("yem_pending".equals(defaultTabKey)) {
            switch (entityId) {
                case "yem_pc_requirtaskbill": {
                    states = Collections.singletonList(PcDemandStateEnum.REQ_WAIT_DISTRIBUTED);
                    break;
                }
                case "yem_pc_myrequiretask": {
                    states = Collections.singletonList(PcDemandStateEnum.PLANNER_WAIT_DIS_PUR);
                    break;
                }
                case "yem_pc_taskmanage": {
                    states = Collections.singletonList(PcDemandStateEnum.PUR_WAIT_DIS_BUYER);
                    break;
                }
                case "yem_pc_mypurtask": {
                    states = Collections.singletonList(PcDemandStateEnum.PUR_WAIT_EXECU);
                    break;
                }
            }
        }
        if ("yem_processed".equals(defaultTabKey)) {
            switch (entityId) {
                case "yem_pc_requirtaskbill": {
                    states = Arrays.asList(PcDemandStateEnum.PLANNER_WAIT_DIS_PUR, PcDemandStateEnum.PUR_WAIT_DIS_BUYER, PcDemandStateEnum.PUR_WAIT_EXECU, PcDemandStateEnum.PUR_WAIT_HANDLE, PcDemandStateEnum.PUR_TASK_CANCEL_SCENE, PcDemandStateEnum.PUR_TASK_CANCEL_PLAN, PcDemandStateEnum.SRC_PENDING_TENDER, PcDemandStateEnum.SRC_CALIBRATION);
                    break;
                }
                case "yem_pc_myrequiretask": {
                    states = Arrays.asList(PcDemandStateEnum.PUR_WAIT_DIS_BUYER, PcDemandStateEnum.PUR_WAIT_EXECU, PcDemandStateEnum.PUR_WAIT_HANDLE, PcDemandStateEnum.PUR_TASK_CANCEL_SCENE, PcDemandStateEnum.PUR_TASK_CANCEL_PLAN, PcDemandStateEnum.SRC_PENDING_TENDER, PcDemandStateEnum.SRC_CALIBRATION);
                    break;
                }
                case "yem_pc_taskmanage": {
                    states = Arrays.asList(PcDemandStateEnum.PUR_WAIT_EXECU, PcDemandStateEnum.PUR_WAIT_HANDLE, PcDemandStateEnum.PUR_TASK_CANCEL_SCENE, PcDemandStateEnum.PUR_TASK_CANCEL_PLAN, PcDemandStateEnum.SRC_PENDING_TENDER, PcDemandStateEnum.SRC_CALIBRATION);
                    break;
                }
                case "yem_pc_mypurtask": {
                    states = Arrays.asList(PcDemandStateEnum.SRC_PENDING_TENDER, PcDemandStateEnum.SRC_CALIBRATION);
                    filter = new QFilter("yem_surplusqty", "=", (Object)BigDecimal.ZERO);
                    break;
                }
            }
        }
        if ("yem_toallocate".equals(defaultTabKey)) {
            switch (entityId) {
                case "yem_pc_mypurtask": {
                    states = Collections.singletonList(PcDemandStateEnum.PUR_WAIT_HANDLE);
                    filter = new QFilter("yem_surplusqty", ">", (Object)BigDecimal.ZERO);
                }
            }
        }
        if ("yem_partorder".equals(defaultTabKey)) {
            switch (entityId) {
                case "yem_pc_requirtaskbill": 
                case "yem_pc_myrequiretask": {
                    states = Collections.singletonList(PcDemandStateEnum.PUR_TASK_CANCEL_PLAN);
                }
            }
        }
        if ("yem_alfforward".equals(defaultTabKey)) {
            switch (entityId) {
                case "yem_pc_requirtaskbill": {
                    if (administrators.contains(currentUserId)) {
                        filter = new QFilter("yem_controltransfer.fbasedataid", "!=", null);
                        break;
                    }
                    filter = new QFilter("yem_controltransfer.fbasedataid.operatorid.id", "=", (Object)currentUserId);
                    break;
                }
                case "yem_pc_myrequiretask": {
                    if (administrators.contains(currentUserId)) {
                        filter = new QFilter("yem_plannertransfer.fbasedataid", "!=", null);
                        break;
                    }
                    filter = new QFilter("yem_plannertransfer.fbasedataid.operatorid.id", "=", (Object)currentUserId);
                    break;
                }
                case "yem_pc_taskmanage": {
                    if (administrators.contains(currentUserId)) {
                        filter = new QFilter("yem_purleadertransfer.fbasedataid", "!=", null);
                        break;
                    }
                    filter = new QFilter("yem_purleadertransfer.fbasedataid.operatorid.id", "=", (Object)currentUserId);
                    break;
                }
                case "yem_pc_mypurtask": {
                    filter = administrators.contains(currentUserId) ? new QFilter("yem_purusertransfer.fbasedataid", "!=", null) : new QFilter("yem_purusertransfer.fbasedataid.operatorid.id", "=", (Object)currentUserId);
                }
            }
        }
        if ("yem_alreject".equals(defaultTabKey)) {
            switch (entityId) {
                case "yem_pc_requirtaskbill": {
                    break;
                }
                case "yem_pc_myrequiretask": {
                    if (administrators.contains(currentUserId)) {
                        filter = new QFilter("yem_plannerreject.fbasedataid", "!=", null);
                        break;
                    }
                    filter = new QFilter("yem_plannerreject.fbasedataid.operatorid.id", "=", (Object)currentUserId);
                    break;
                }
                case "yem_pc_taskmanage": {
                    if (administrators.contains(currentUserId)) {
                        filter = new QFilter("yem_purleaderreject.fbasedataid", "!=", null);
                        break;
                    }
                    filter = new QFilter("yem_purleaderreject.fbasedataid.operatorid.id", "=", (Object)currentUserId);
                    break;
                }
                case "yem_pc_mypurtask": {
                    filter = administrators.contains(currentUserId) ? new QFilter("yem_puruserreject.fbasedataid", "!=", null) : new QFilter("yem_puruserreject.fbasedataid.operatorid.id", "=", (Object)currentUserId);
                }
            }
        }
        this.setFilter(states, qFilters, defaultTabKey, filter);
    }

    private void setFilter(List<PcDemandStateEnum> states, List<QFilter> qFilters, String defaultTabKey, QFilter filter) {
        if (("yem_alfforward".equals(defaultTabKey) || "yem_alreject".equals(defaultTabKey)) && filter != null) {
            qFilters.add(filter);
            return;
        }
        List strings = states.stream().map(PcDemandStateEnum::getStatus).collect(Collectors.toList());
        if ("yem_pending".equals(defaultTabKey)) {
            qFilters.add(new QFilter("yem_newdemandstate", "in", strings).and(new QFilter("yem_taskclose", "=", (Object)false)));
        }
        if ("yem_processed".equals(defaultTabKey)) {
            qFilters.add(new QFilter("yem_newdemandstate", "in", strings));
        }
        if ("yem_toallocate".equals(defaultTabKey)) {
            qFilters.add(new QFilter("yem_newdemandstate", "in", strings).and(new QFilter("yem_taskclose", "=", (Object)false)));
        }
        if ("yem_partorder".equals(defaultTabKey)) {
            qFilters.add(new QFilter("yem_newdemandstate", "in", strings));
        }
        if (filter != null) {
            qFilters.add(filter);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String tabKey = tabSelectEvent.getTabKey();
        BillList billlist = (BillList)this.getControl("billlistap");
        String entityId = billlist.getEntityId();
        this.changeListView(entityId, tabKey);
        IListView listView = (IListView)this.getView();
        listView.setEnable(Boolean.valueOf("yem_pending".equals(tabKey)), new String[]{"yem_merge", "yem_split", "yem_rejectop", "yem_oversplit", "yem_oversplitclose", "yem_sources", "yem_reqpoolcontract", "yem_confirmexe", "yem_change", "yem_planadjusturgency", "push_mall", "yem_pushmallel", "push_project", "yem_reqordercontract"});
        listView.setEnable(Boolean.valueOf(!"yem_alfforward".equals(tabKey) && !"yem_alreject".equals(tabKey) && !"yem_partorder".equals(tabKey)), new String[]{"yem_distribution", "yem_newdistribution", "yem_forward"});
        if ("yem_toallocate".equals(tabKey)) {
            listView.setEnable(Boolean.valueOf(true), new String[]{"yem_sources", "yem_reqpoolcontract", "yem_confirmexe", "yem_split", "yem_forward", "yem_rejectop", "push_mall", "yem_pushmallel", "push_project", "yem_reqordercontract"});
        }
        if (MINE_REQUIRE_TASK.equals(entityId) && "yem_processed".equals(tabKey)) {
            listView.setEnable(Boolean.valueOf(true), new String[]{"yem_planadjusturgency"});
        }
        if ("yem_pending".equals(tabKey)) {
            listView.setEnable(Boolean.valueOf(false), new String[]{"yem_sources", "yem_reqpoolcontract", "push_mall", "yem_pushmallel", "push_project", "yem_reqordercontract"});
        }
        if ("yem_alfforward".equals(tabKey) || "yem_alreject".equals(tabKey) || "yem_partorder".equals(tabKey)) {
            listView.setEnable(Boolean.valueOf(false), new String[]{"yem_pushtaskcg"});
        } else {
            listView.setEnable(Boolean.valueOf(true), new String[]{"yem_pushtaskcg"});
        }
        this.getView().invokeOperation("refresh");
    }

    private void changeListView(String entityId, String tabKey) {
        IListView listView = (IListView)this.getView();
        String viewId = "";
        if ("yem_pending".equals(tabKey)) {
            viewId = entityId;
        }
        if ("yem_processed".equals(tabKey)) {
            switch (entityId) {
                case "yem_pc_requirtaskbill": {
                    viewId = "yem_pc_requirtask_fin";
                    break;
                }
                case "yem_pc_myrequiretask": {
                    viewId = "yem_pc_myrequiret_fin";
                    break;
                }
                case "yem_pc_taskmanage": {
                    viewId = "yem_pc_taskmanage_fin";
                    break;
                }
                case "yem_pc_mypurtask": {
                    viewId = "yem_pc_mypurtask_fin";
                    break;
                }
            }
        }
        if ("yem_toallocate".equals(tabKey)) {
            switch (entityId) {
                case "yem_pc_mypurtask": {
                    viewId = "yem_pc_mypurtask_han";
                }
            }
        }
        if (YEM.isNotEmpty((Object)viewId)) {
            listView.changeListView(viewId);
        }
    }
}

