/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.pc.common.moudle.task.list;

import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.wm.pc.common.utils.PcRequestTaskUtil;

public class PcViewLogListPlugin
extends AbstractListPlugin
implements Plugin {
    public void beforeBindData(EventObject evt) {
        super.beforeBindData(evt);
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        this.setSlideBill(proxy, "yem_pc_log");
        this.setSlideBill(proxy, "yem_pc_approvelog");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (operationResult != null && operationResult.isSuccess()) {
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            IFormView view = this.getView();
            DynamicObject[] selectDatas = PcRequestTaskUtil.getSelectDatas(view);
            Set idSet = Arrays.stream(selectDatas).map(s -> s.getLong("id")).collect(Collectors.toSet());
            switch (operateKey) {
                case "yem_viewreqflow": {
                    if (idSet.size() <= 1) break;
                    this.getView().showTipNotification("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u9700\u6c42\u6d41\u7a0b\u56fe\u3002");
                    return;
                }
                case "logquery": {
                    if (idSet.size() > 1) {
                        this.getView().showMessage(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u64cd\u4f5c\u8bb0\u5f55\u3002", (String)"PscViewLogListPlugin_0", (String)"yem-pur", (Object[])new Object[0]));
                        return;
                    }
                    String billno = "";
                    for (Long billId : idSet) {
                        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"yem_pc_reqpooltpl");
                        billno = object.getString("yem_prnum");
                    }
                    String billId = "";
                    for (Long id : idSet) {
                        billId = String.valueOf(id);
                    }
                    IClientViewProxy proxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
                    HashMap<String, Object> actionParam = new HashMap<String, Object>(8);
                    actionParam.put("formId", "yem_pc_log");
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("pkId", billId);
                    params.put("billno", billno);
                    actionParam.put("params", params);
                    proxy.addAction("showSlideBill", actionParam);
                    break;
                }
                case "reqapprovelog": {
                    if (idSet.size() > 1) {
                        this.getView().showMessage("\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u67e5\u770b\u5ba1\u6279\u8bb0\u5f55\u3002");
                        return;
                    }
                    String approveId = "";
                    for (Long taskId : idSet) {
                        approveId = String.valueOf(taskId);
                    }
                    IClientViewProxy approveProxy = (IClientViewProxy)view.getService(IClientViewProxy.class);
                    HashMap<String, Object> aParam = new HashMap<String, Object>(8);
                    aParam.put("formId", "yem_pc_approvelog");
                    HashMap<String, String> approveParams = new HashMap<String, String>();
                    approveParams.put("pkId", approveId);
                    aParam.put("params", approveParams);
                    approveProxy.addAction("showSlideBill", aParam);
                    break;
                }
            }
        }
    }

    private void setSlideBill(IClientViewProxy proxy, String formId) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put("direction", "right");
        map.put("formId", formId);
        map.put("visualStyle", "newDesign");
        HashMap<String, Integer> offset = new HashMap<String, Integer>();
        offset.put("top", 82);
        map.put("offsetInAllDC", offset);
        HashMap<String, String> borderRadius = new HashMap<String, String>();
        borderRadius.put("borderRadius", "2px");
        borderRadius.put("boxShadow", "0px 9px 24px 6px rgb(0 0 0 / 10%)");
        borderRadius.put("height", "calc(100% - 82px)");
        map.put("style", borderRadius);
        proxy.addAction("setSlideBillFormId", map);
    }
}

