/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.bill.customeraccess.from;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.wm.cs.trade.common.YEM;

public class CustomerAccessBillPlugin
extends AbstractBillPlugIn
implements Plugin,
BeforeF7SelectListener {
    public void itemClick(ItemClickEvent evt) {
        IDataModel model = this.getModel();
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("yem_checkrisk".equals(itemKey)) {
            FormShowParameter fsp = new FormShowParameter();
            String[] purpose = (String[])Arrays.stream(String.valueOf(model.getValue("yem_moreclienttype")).split(",")).map(String::trim).filter(s -> !s.isEmpty()).toArray(String[]::new);
            String companyName = String.valueOf(model.getValue("yem_merchantstname"));
            if (purpose.length == 0) {
                this.getView().showMessage("\u5ba2\u5546\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (companyName.trim().isEmpty()) {
                this.getView().showMessage("\u5ba2\u5546\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            fsp.setCustomParam("companyName", (Object)companyName);
            fsp.setCustomParam("purpose", (Object)purpose);
            fsp.setFormId("yem_cs_customerdynamic");
            StyleCss css = new StyleCss();
            css.setHeight("90%");
            css.setWidth("80%");
            fsp.getOpenStyle().setInlineStyleCss(css);
            fsp.getOpenStyle().setShowType(ShowType.Modal);
            fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "entityData"));
            this.getView().showForm(fsp);
        }
    }

    public void registerListener(EventObject e) {
        Control location;
        Control affiliationDep;
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_reasonspeauthorizat", "yem_reasonexemption"});
        this.addItemClickListeners(new String[]{"yem_checkrisk"});
        Control affiliationOrg = this.getView().getControl("yem_affiliationorg");
        if (null != affiliationOrg) {
            BasedataEdit basedataEdit = (BasedataEdit)affiliationOrg;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (affiliationDep = this.getView().getControl("yem_affiliationdep"))) {
            BasedataEdit basedataEdit = (BasedataEdit)affiliationDep;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
        if (null != (location = this.getView().getControl("yem_bdlocaiton"))) {
            BasedataEdit basedataEdit = (BasedataEdit)location;
            basedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String chose;
        ListShowParameter show = (ListShowParameter)evt.getFormShowParameter();
        ArrayList<QFilter> qf = new ArrayList<QFilter>();
        switch (chose = evt.getProperty().getName()) {
            case "yem_affiliationdep": {
                DynamicObject currentOrg = ((DynamicObject)this.getModel().getEntryEntity("yem_kszr_ssfw").get(this.getModel().getEntryCurrentRowIndex("yem_kszr_ssfw"))).getDynamicObject("yem_affiliationorg");
                if (!YEM.isEmpty(currentOrg)) {
                    List<Long> allSubIdOrgList = this.getSubordinateList(currentOrg);
                    qf.add(new QFilter("id", "in", allSubIdOrgList));
                    qf.add(new QFilter("orgpattern.number", "=", (Object)"Orgform06"));
                    show.getListFilterParameter().setQFilters(qf);
                } else {
                    qf.add(new QFilter("id", "=", null));
                }
                show.getListFilterParameter().setQFilters(qf);
                break;
            }
            case "yem_affiliationorg": {
                List<Long> allSubIdOrgList = this.getSubordinateList((DynamicObject)this.getModel().getValue("org"));
                qf.add(new QFilter("id", "in", allSubIdOrgList));
                qf.add(new QFilter("orgpattern.number", "!=", (Object)"Orgform06"));
                show.getListFilterParameter().setQFilters(qf);
                break;
            }
            case "yem_bdlocaiton": {
                int cwRow = this.getModel().getEntryCurrentRowIndex("yem_cs_kszr_ckxx");
                DynamicObject bdWarehouse = ((DynamicObject)this.getModel().getEntryEntity("yem_cs_kszr_ckxx").get(cwRow)).getDynamicObject("yem_warehouse");
                if (null == bdWarehouse) break;
                bdWarehouse = BusinessDataServiceHelper.loadSingle((String)"bd_warehouse", (QFilter[])new QFilter[]{new QFilter("id", "=", bdWarehouse.getPkValue())});
                DynamicObjectCollection bdDc = bdWarehouse.getDynamicObjectCollection("entryentity");
                ArrayList arrayList = bdDc.stream().map(row -> row.getDynamicObject("location").getString("number")).collect(Collectors.toCollection(ArrayList::new));
                qf.add(new QFilter("number", "in", (Object)arrayList));
                show.getListFilterParameter().setQFilters(qf);
            }
        }
    }

    private List<Long> getSubordinateList(DynamicObject org) {
        ArrayList<Long> orgList = new ArrayList<Long>();
        orgList.add((Long)org.get("id"));
        return OrgUnitServiceHelper.getAllSubordinateOrgs((Long)1L, orgList, (boolean)false);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId;
        super.closedCallBack(e);
        switch (actionId = e.getActionId()) {
            case "tpyy": {
                if (e.getReturnData() == null || !(e.getReturnData() instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection result = (ListSelectedRowCollection)e.getReturnData();
                if (result.size() > 1) {
                    this.getView().showErrorNotification("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e \u7981\u6b62\u591a\u9009");
                    break;
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"yem_cs_approval", (QFilter[])new QFilter[]{new QFilter("id", "=", result.get(0).getPrimaryKeyValue())});
                this.getModel().setValue("yem_reasonspeauthorizat", (Object)dynamicObject.getString("yem_causedescription"));
                break;
            }
            case "hmyy": {
                if (e.getReturnData() == null || !(e.getReturnData() instanceof ListSelectedRowCollection)) break;
                ListSelectedRowCollection result = (ListSelectedRowCollection)e.getReturnData();
                if (result.size() > 1) {
                    this.getView().showErrorNotification("\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u6570\u636e \u7981\u6b62\u591a\u9009");
                    break;
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"yem_cs_exempt", (QFilter[])new QFilter[]{new QFilter("id", "=", result.get(0).getPrimaryKeyValue())});
                this.getModel().setValue("yem_reasonexemption", (Object)dynamicObject.getString("yem_causedescription"));
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object source = evt.getSource();
        if (source instanceof TextEdit) {
            TextEdit source1 = (TextEdit)source;
            String key = source1.getKey();
            ListShowParameter lsp = new ListShowParameter();
            switch (key) {
                case "yem_reasonspeauthorizat": {
                    this.constructListShowParameter(lsp, "\u7279\u6279\u539f\u56e0", "yem_cs_approval", "tpyy");
                    this.getView().showForm((FormShowParameter)lsp);
                    break;
                }
                case "yem_reasonexemption": {
                    this.constructListShowParameter(lsp, "\u8c41\u514d\u539f\u56e0", "yem_cs_exempt", "hmyy");
                    this.getView().showForm((FormShowParameter)lsp);
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "yem_isdefault_bank": {
                this.onlyDefaultRow(e, "yem_cs_kszr_yhzhxx", key);
                break;
            }
            case "yem_isdefault_linkman": {
                this.onlyDefaultRow(e, "yem_cs_kszr_lxrxx", key);
                break;
            }
            case "yem_warehouse": {
                this.autoBringWarehouse();
            }
        }
    }

    private void autoBringWarehouse() {
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex("yem_cs_kszr_ckxx");
        DynamicObject warehouse = ((DynamicObject)this.getModel().getEntryEntity("yem_cs_kszr_ckxx").get(currentRowIndex)).getDynamicObject("yem_warehouse");
        if (YEM.isEmpty(warehouse)) {
            return;
        }
        DynamicObject bdWarehouse = BusinessDataServiceHelper.loadSingle((String)"bd_warehouse", (QFilter[])new QFilter[]{new QFilter("id", "=", warehouse.getPkValue())});
        this.getModel().setValue("yem_warehousename", (Object)bdWarehouse.getString("name"), currentRowIndex);
        this.getModel().setValue("yem_warehousegroup", (Object)bdWarehouse.getDynamicObject("group"), currentRowIndex);
        this.getModel().setValue("yem_contact", (Object)bdWarehouse.getDynamicObject("principal"), currentRowIndex);
        this.getModel().setValue("yem_warehousetel", (Object)bdWarehouse.getString("telephone"), currentRowIndex);
        this.getModel().setValue("yem_citycounty", bdWarehouse.get("address"), currentRowIndex);
        this.getModel().setValue("yem_address", (Object)bdWarehouse.getString("detailaddress"), currentRowIndex);
        DynamicObjectCollection bdCwDc = bdWarehouse.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < bdCwDc.size(); ++i) {
            this.getModel().createNewEntryRow("yem_cs_kszr_cwxx");
            this.getModel().setValue("yem_bdlocaiton", (Object)((DynamicObject)bdCwDc.get(i)).getDynamicObject("location"), i);
        }
    }

    private void onlyDefaultRow(PropertyChangedArgs e, String entity, String key) {
        DynamicObjectCollection linkmanDc = this.getModel().getEntryEntity(entity);
        ChangeData changeSet = e.getChangeSet()[0];
        if (((Boolean)changeSet.getNewValue()).booleanValue()) {
            linkmanDc.stream().filter(row -> {
                int currentRowIndex = this.getModel().getEntryCurrentRowIndex(entity);
                int i = linkmanDc.indexOf(row);
                return i != currentRowIndex;
            }).forEach(row -> this.getModel().setValue(key, (Object)false, linkmanDc.indexOf(row)));
        }
    }

    private void constructListShowParameter(ListShowParameter lsp, String title, String billFormId, String actionId) {
        lsp.setCaption(title);
        lsp.setBillFormId(billFormId);
        StyleCss css = new StyleCss();
        css.setHeight("50%");
        css.setWidth("50%");
        lsp.getOpenStyle().setInlineStyleCss(css);
        lsp.getOpenStyle().setShowType(ShowType.Modal);
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        lsp.setLookUp(true);
    }
}

