/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.bill.customeraccess.opplugin.op;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.basedata.AssignQueryResponse;
import kd.bos.entity.basedata.BaseDataResponse;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import yem.wm.cs.trade.common.DynamicObjectUtil;
import yem.wm.cs.trade.common.YEM;

public class CustomerAccessAuditOpPlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.addAll(DynamicObjectUtil.addFieldKey("yem_cs_customeraccess", true));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject datum : dataEntities = e.getDataEntities()) {
            DynamicObject affiliation;
            boolean isSupplier;
            boolean isCustomer;
            Long datumId = datum.getLong("id");
            DynamicObject customer = BusinessDataServiceHelper.loadSingle((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("yem_customeraccessid", "=", (Object)datumId)});
            DynamicObject supplier = BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("yem_customeraccessid", "=", (Object)datumId)});
            String[] clientType = datum.getString("yem_moreclienttype").split(",");
            Set merchant = Arrays.stream(clientType).filter(s -> !s.trim().isEmpty()).collect(Collectors.toSet());
            DynamicObject classIfCustomer = datum.getDynamicObject("yem_classifycustomer");
            boolean bl = isCustomer = merchant.contains("A") && YEM.isNotEmpty(classIfCustomer);
            if (isCustomer) {
                this.creatBaseData(customer, datum, true);
            }
            DynamicObject classIfSupplier = datum.getDynamicObject("yem_classifysupplier");
            boolean bl2 = isSupplier = merchant.contains("A") && merchant.size() > 1 || !merchant.isEmpty() && !merchant.contains("A") && YEM.isNotEmpty(classIfSupplier);
            if (isSupplier) {
                this.creatBaseData(supplier, datum, false);
            }
            if (null != (affiliation = datum.getDynamicObject("yem_affentry"))) {
                CustomerAccessAuditOpPlugin.affiliationDecide(datum, affiliation, datumId);
            }
            this.createOrUpdateWarehouse(datum);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{datum});
        }
    }

    private void creatBaseData(DynamicObject baseData, DynamicObject datum, Boolean flag) {
        if (null != baseData) {
            this.updateBaseData(datum, baseData, flag);
        } else {
            this.createBaseData(datum, flag);
        }
    }

    private void updateBaseData(DynamicObject datum, DynamicObject bdData, Boolean flag) {
        String entityName = flag != false ? "bd_customer" : "bd_supplier";
        this.createBdHead(bdData, datum, flag);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{bdData});
        DynamicObjectCollection bdBankDc = bdData.getDynamicObjectCollection("entry_bank");
        bdBankDc.clear();
        DynamicObjectCollection datumLinkmanDc = datum.getDynamicObjectCollection("yem_cs_kszr_lxrxx");
        this.deleteCustomerLinkman(datumLinkmanDc, bdData);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bdData});
        DynamicObject baseData = BusinessDataServiceHelper.loadSingle((String)entityName, (QFilter[])new QFilter[]{new QFilter("yem_customeraccessid", "=", (Object)datum.getLong("id"))});
        this.constructClientBank(datum, baseData);
        DynamicObjectCollection baseLinkmanDc = baseData.getDynamicObjectCollection("entry_linkman");
        for (DynamicObject datumLinkmanRow : datumLinkmanDc) {
            for (DynamicObject bdLinkmanRow : baseLinkmanDc) {
                DynamicObject address;
                long bdLinkmanDcId;
                long datumLinkmanRowId = datumLinkmanRow.getLong("id");
                if (datumLinkmanRowId != (bdLinkmanDcId = bdLinkmanRow.getLong("yem_linkmaninfoid"))) continue;
                String relationAdd = datumLinkmanRow.getString("yem_addressac");
                if (relationAdd.trim().isEmpty()) {
                    address = null;
                    datumLinkmanRow.set("yem_bdaddressid", address);
                    DynamicObject associateAddr = bdLinkmanRow.getDynamicObject("associatedaddress");
                    if (!YEM.isEmpty(associateAddr)) {
                        bdLinkmanRow.set("associatedaddress", (Object)address);
                        DeleteServiceHelper.delete((String)"bd_address", (QFilter[])new QFilter[]{new QFilter("id", "=", associateAddr.getPkValue())});
                    }
                } else {
                    address = this.createAddress(baseData, datumLinkmanRow, flag);
                    bdLinkmanRow.set("associatedaddress", (Object)address);
                    datumLinkmanRow.set("yem_bdaddressid", (Object)address);
                }
                this.constructBdLinkmanDc(bdLinkmanRow, datumLinkmanRow, address);
            }
        }
        List baseLinkmanSourceId = baseLinkmanDc.stream().map(row -> row.getLong("yem_linkmaninfoid")).collect(Collectors.toList());
        List notExistBase = datumLinkmanDc.stream().filter(dtRow -> !baseLinkmanSourceId.contains(dtRow.getLong("id"))).collect(Collectors.toList());
        for (DynamicObject datumLinkmanRow : notExistBase) {
            String relationAdd = datumLinkmanRow.getString("yem_addressac");
            DynamicObject address = null;
            if (!relationAdd.trim().isEmpty()) {
                address = this.createAddress(baseData, datumLinkmanRow, flag);
                datumLinkmanRow.set("yem_bdaddressid", (Object)address);
            }
            DynamicObject customerNewRow = baseLinkmanDc.addNew();
            this.constructBdLinkmanDc(customerNewRow, datumLinkmanRow, address);
        }
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{datum});
        this.operation("save", entityName, new DynamicObject[]{baseData});
        this.operation("submit", entityName, new DynamicObject[]{baseData});
        this.operation("audit", entityName, new DynamicObject[]{baseData});
        this.updateStrategy(baseData, datum, entityName);
    }

    public void updateStrategy(DynamicObject client, DynamicObject datum, String entityTag) {
        int assign = client.getInt("ctrlstrategy");
        if (!(assign != 1 && assign != 2 || YEM.isEmpty(datum.get("yem_kszr_ssfw")))) {
            BaseDataResponse assignUpdate;
            Long entityId = (Long)client.getPkValue();
            long orgPkValue = (Long)client.getDynamicObject("createorg").getPkValue();
            AssignQueryResponse assignQueryResponse = BaseDataServiceHelper.assignQueryByData(Collections.singletonList(entityId), (String)entityTag, (Long)orgPkValue, (String)"basedata");
            if (!assignQueryResponse.isSuccess()) {
                throw new KDBizException("\u67e5\u8be2\u63a7\u5236\u7b56\u7565\u5931\u8d25\t\u5931\u8d25\u539f\u56e0:" + assignQueryResponse.getErrorMsg());
            }
            Map data = assignQueryResponse.getData();
            List oldOrgIds = (List)data.get(entityId);
            HashSet oldOrgIdsCopy = new HashSet(oldOrgIds);
            DynamicObjectCollection ownershipScope = datum.getDynamicObjectCollection("yem_kszr_ssfw");
            ArrayList<Long> newOrgIds = new ArrayList<Long>();
            for (DynamicObject ownershipScopeRow : ownershipScope) {
                Long affiliationOrgId = ownershipScopeRow.getDynamicObject("yem_affiliationorg").getLong("id");
                newOrgIds.add(affiliationOrgId);
            }
            if (oldOrgIdsCopy.removeAll(newOrgIds) && !oldOrgIdsCopy.isEmpty()) {
                List cancelAssign = BaseDataServiceHelper.cancelAssign((String)entityTag, new HashSet<Long>(Collections.singleton(entityId)), oldOrgIdsCopy);
                cancelAssign.forEach(e -> {
                    if (!e.isSuccess()) {
                        throw new KDBizException("\u53d6\u6d88\u5206\u914d\u7b56\u7565\u5931\u8d25\t\u5931\u8d25\u539f\u56e0:" + e.getErrorMsg());
                    }
                });
            }
            if (newOrgIds.removeAll(oldOrgIds) && !newOrgIds.isEmpty() && !(assignUpdate = BaseDataServiceHelper.assign((String)entityTag, (Long)orgPkValue, (String)"basedata", new HashSet<Long>(Collections.singleton(entityId)), new HashSet(newOrgIds))).isSuccess()) {
                throw new KDBizException("\u5206\u914d\u7ec4\u7ec7\u5931\u8d25\t\u5931\u8d25\u539f\u56e0:" + assignUpdate.getErrorMsg());
            }
        }
    }

    public void controlStrategy(DynamicObject customerOrSupplier, DynamicObject datum, String entityTag) {
        int assign = customerOrSupplier.getInt("ctrlstrategy");
        if (!(assign != 1 && assign != 2 || YEM.isEmpty(datum.get("yem_kszr_ssfw")))) {
            Long entityId = (Long)customerOrSupplier.getPkValue();
            DynamicObject org = customerOrSupplier.getDynamicObject("createorg");
            Long orgPkValue = (Long)org.getPkValue();
            HashSet<Long> orgIds = new HashSet<Long>();
            DynamicObjectCollection ownershipScope = datum.getDynamicObjectCollection("yem_kszr_ssfw");
            for (DynamicObject ownershipScopeRow : ownershipScope) {
                Long affiliationOrgId = ownershipScopeRow.getDynamicObject("yem_affiliationorg").getLong("id");
                orgIds.add(affiliationOrgId);
            }
            HashSet<Long> dataIds = new HashSet<Long>();
            dataIds.add(entityId);
            BaseDataResponse assignResult = BaseDataServiceHelper.assign((String)entityTag, (Long)orgPkValue, (String)"basedata", dataIds, orgIds);
            if (!assignResult.isSuccess()) {
                throw new KDBizException("\u5206\u914d\u7b56\u7565\u5931\u8d25,\u5931\u8d25\u539f\u56e0:" + assignResult.getErrorMsg());
            }
        }
    }

    private void createBaseData(DynamicObject datum, boolean flag) {
        String entityName = flag ? "bd_customer" : "bd_supplier";
        DynamicObject baseData = BusinessDataServiceHelper.newDynamicObject((String)entityName);
        this.createBdHead(baseData, datum, flag);
        String strategy = BaseDataServiceHelper.getBdCtrlStrgy((String)entityName, (String)datum.getDynamicObject("org").getString("id"));
        baseData.set("ctrlstrategy", (Object)strategy);
        this.operation("save", entityName, new DynamicObject[]{baseData});
        DynamicObjectCollection datumLinkmanDc = datum.getDynamicObjectCollection("yem_cs_kszr_lxrxx");
        DynamicObjectCollection customerDc = baseData.getDynamicObjectCollection("entry_linkman");
        DynamicObject address = null;
        for (DynamicObject datumLinkDcRow : datumLinkmanDc) {
            String linkmanAddress = datumLinkDcRow.getString("yem_addressac");
            if (!linkmanAddress.trim().isEmpty()) {
                address = this.createAddress(baseData, datumLinkDcRow, flag);
                datumLinkDcRow.set("yem_bdaddressid", (Object)address);
            }
            DynamicObject customerNewRow = customerDc.addNew();
            this.constructBdLinkmanDc(customerNewRow, datumLinkDcRow, address);
        }
        this.constructClientBank(datum, baseData);
        SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{datum});
        this.operation("save", entityName, new DynamicObject[]{baseData});
        this.operation("submit", entityName, new DynamicObject[]{baseData});
        this.operation("audit", entityName, new DynamicObject[]{baseData});
        this.controlStrategy(baseData, datum, entityName);
    }

    private void createOrUpdateWarehouse(DynamicObject datum) {
        DynamicObjectCollection ckDc = datum.getDynamicObjectCollection("yem_cs_kszr_ckxx");
        for (DynamicObject ckDcRow : ckDc) {
            DynamicObject warehouse = ckDcRow.getDynamicObject("yem_warehouse");
            if (YEM.isEmpty(warehouse)) {
                this.createWarehouse(datum, ckDcRow);
                continue;
            }
            this.updateWarehouse(datum, ckDcRow);
        }
    }

    private void operation(String operationKey, String entityNumber, DynamicObject[] dynamicObjects) {
        OperationResult op = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (DynamicObject[])dynamicObjects, (OperateOption)OperateOption.create());
        if (!op.isSuccess()) {
            throw new KDBizException(YEM.getOpMsg(op));
        }
    }

    public void updateWarehouse(DynamicObject datum, DynamicObject ckDcRow) {
        DynamicObject bdWarehouse = CustomerAccessAuditOpPlugin.constructBdWarehouse(datum, ckDcRow, false);
        this.operation("save", "bd_warehouse", new DynamicObject[]{bdWarehouse});
        CustomerAccessAuditOpPlugin.writeBack(datum, ckDcRow, bdWarehouse);
        this.operation("save", "bd_warehouse", new DynamicObject[]{bdWarehouse});
        this.operation("submit", "bd_warehouse", new DynamicObject[]{bdWarehouse});
        this.operation("audit", "bd_warehouse", new DynamicObject[]{bdWarehouse});
    }

    public void createWarehouse(DynamicObject datum, DynamicObject ckDcRow) {
        DynamicObject bdWarehouse = CustomerAccessAuditOpPlugin.constructBdWarehouse(datum, ckDcRow, true);
        this.operation("save", "bd_warehouse", new DynamicObject[]{bdWarehouse});
        CustomerAccessAuditOpPlugin.writeBack(datum, ckDcRow, bdWarehouse);
        this.operation("submit", "bd_warehouse", new DynamicObject[]{bdWarehouse});
        this.operation("audit", "bd_warehouse", new DynamicObject[]{bdWarehouse});
    }

    private static DynamicObject constructBdWarehouse(DynamicObject datum, DynamicObject ckDcRow, Boolean flag) {
        DynamicObject bdWarehouse;
        QFilter[] whF = new QFilter[]{new QFilter("name", "=", (Object)ckDcRow.getString("yem_warehousename")), new QFilter("createorg.id", "=", datum.getDynamicObject("org").getPkValue())};
        if (flag.booleanValue()) {
            if (QueryServiceHelper.exists((String)"bd_location", (QFilter[])whF)) {
                throw new KDBizException("\u521b\u5efa\u7ec4\u7ec7\u5df2\u7ecf\u6709\u8fd9\u4e2a\u540d\u79f0\u7684\u4ed3\u5e93 \u8bf7\u91cd\u65b0\u53d6\u540d\u540e\u521b\u5efa");
            }
            bdWarehouse = BusinessDataServiceHelper.newDynamicObject((String)"bd_warehouse");
            DynamicObjectCollection bdWarehouseDc = bdWarehouse.getDynamicObjectCollection("entryentity");
            if (datum.getBoolean("yem_enableposition")) {
                Map<Long, DynamicObject> locationMap = CustomerAccessAuditOpPlugin.constructLocation(ckDcRow);
                locationMap.forEach((k, v) -> {
                    DynamicObject dynamicObject = (DynamicObject)locationMap.get(k);
                    DynamicObject warehouseDcNewRow = bdWarehouseDc.addNew();
                    warehouseDcNewRow.set("location", (Object)dynamicObject);
                });
            }
        } else {
            bdWarehouse = BusinessDataServiceHelper.loadSingle((String)"bd_warehouse", (QFilter[])new QFilter[]{new QFilter("id", "=", ckDcRow.getDynamicObject("yem_warehouse").getPkValue())});
            DynamicObjectCollection bdWarehouseDc = bdWarehouse.getDynamicObjectCollection("entryentity");
            if (datum.getBoolean("yem_enableposition")) {
                Map<Long, DynamicObject> locationList = CustomerAccessAuditOpPlugin.constructLocation(ckDcRow);
                bdWarehouseDc.clear();
                locationList.forEach((k, v) -> {
                    DynamicObject newBdWarehousRow = bdWarehouseDc.addNew();
                    newBdWarehousRow.set("location", v);
                });
            }
        }
        bdWarehouse.set("createorg", datum.get("org"));
        bdWarehouse.set("name", ckDcRow.get("yem_warehousename"));
        bdWarehouse.set("isopenlocation", (Object)true);
        bdWarehouse.set("group", ckDcRow.get("yem_warehousegroup"));
        bdWarehouse.set("enable", (Object)"1");
        bdWarehouse.set("creator", datum.get("creator"));
        bdWarehouse.set("status", (Object)"A");
        bdWarehouse.set("useorg", datum.get("org"));
        bdWarehouse.set("org", datum.get("org"));
        bdWarehouse.set("yem_customeraccessid", datum.getPkValue());
        bdWarehouse.set("address", ckDcRow.get("yem_citycounty"));
        bdWarehouse.set("detailaddress", ckDcRow.get("yem_address"));
        bdWarehouse.set("principal", ckDcRow.get("yem_contact"));
        bdWarehouse.set("telephone", ckDcRow.get("yem_warehousetel"));
        return bdWarehouse;
    }

    private static Map<Long, DynamicObject> constructLocation(DynamicObject ckDcRow) {
        DynamicObjectCollection locationDc = ckDcRow.getDynamicObjectCollection("yem_cs_kszr_cwxx");
        HashMap<Long, DynamicObject> locationMap = new HashMap<Long, DynamicObject>();
        for (DynamicObject locationRow : locationDc) {
            DynamicObject bdLocation;
            DynamicObject mainLocation = locationRow.getDynamicObject("yem_bdlocaiton");
            String locationNum = locationRow.getString("yem_positioncode");
            String locationName = locationRow.getString("yem_positionname");
            String locationDesc = locationRow.getString("yem_positiondesc");
            QFilter[] qfLocation = new QFilter[]{new QFilter("number", "=", (Object)locationNum), new QFilter("name", "=", (Object)locationName)};
            if (YEM.isEmpty(mainLocation)) {
                bdLocation = BusinessDataServiceHelper.newDynamicObject((String)"bd_location");
                if (QueryServiceHelper.exists((String)"bd_location", (QFilter[])qfLocation)) {
                    throw new KDBizException("\u7b2c{\u884c\u53f7}\u884c\u4ed3\u4f4d\u4fe1\u606f\u51b2\u7a81 \u8bf7\u91cd\u65b0\u914d\u7f6e\u540d\u79f0\u4e0e\u7f16\u7801".replace("{\u884c\u53f7}", String.valueOf(locationDc.indexOf((Object)locationRow) + 1)));
                }
            } else {
                bdLocation = BusinessDataServiceHelper.loadSingle((String)"bd_location", (QFilter[])new QFilter[]{new QFilter("id", "=", mainLocation.getPkValue())});
            }
            bdLocation.set("number", (Object)locationNum);
            bdLocation.set("name", (Object)locationName);
            bdLocation.set("descrioption", (Object)locationDesc);
            bdLocation.set("enable", (Object)"1");
            bdLocation.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            bdLocation.set("createtime", (Object)System.currentTimeMillis());
            OperationResult saveOpBdLocation = OperationServiceHelper.executeOperate((String)"save", (String)"bd_location", (DynamicObject[])new DynamicObject[]{bdLocation}, null);
            if (!saveOpBdLocation.isSuccess()) {
                throw new KDBizException(YEM.getOpMsg(saveOpBdLocation));
            }
            locationRow.set("yem_bdlocaiton", (Object)bdLocation);
            locationMap.put(bdLocation.getLong("id"), bdLocation);
        }
        return locationMap;
    }

    private static void writeBack(DynamicObject datum, DynamicObject datumWarehouseRow, DynamicObject bdWarehouse) {
        boolean notIncludeClient;
        datumWarehouseRow.set("yem_warehouse", (Object)bdWarehouse);
        String[] clientType = datum.getString("yem_moreclienttype").split(",");
        Set merchant = Arrays.stream(clientType).filter(s -> !s.trim().isEmpty()).collect(Collectors.toSet());
        boolean includeClient = merchant.contains("A") && merchant.size() > 1;
        boolean bl = notIncludeClient = merchant.contains("A") && merchant.size() > 1;
        if (includeClient || notIncludeClient) {
            bdWarehouse.set("yem_typeofclient", (Object)"bd_supplier");
            bdWarehouse.set("yem_nameofclient", (Object)BusinessDataServiceHelper.loadSingle((String)"bd_supplier", (QFilter[])new QFilter[]{new QFilter("yem_customeraccessid", "=", datum.getPkValue())}));
        } else {
            bdWarehouse.set("yem_typeofclient", (Object)"bd_customer");
            bdWarehouse.set("yem_nameofclient", (Object)BusinessDataServiceHelper.loadSingle((String)"bd_customer", (QFilter[])new QFilter[]{new QFilter("yem_customeraccessid", "=", datum.getPkValue())}));
        }
    }

    private static void affiliationDecide(DynamicObject datum, DynamicObject affiliation, Long merchantApplyId) {
        DynamicObject bd_affiliation = BusinessDataServiceHelper.loadSingle((String)"yem_cs_affiliations", (QFilter[])new QFilter[]{new QFilter("id", "=", affiliation.getPkValue())});
        DynamicObjectCollection companyDetailsDC = bd_affiliation.getDynamicObjectCollection("yem_cs_lsgx_gsmx");
        Optional<DynamicObject> row = companyDetailsDC.stream().filter(rows -> rows.getLong("yem_merchantid") == merchantApplyId.longValue()).findFirst();
        if (row.isPresent()) {
            DynamicObject dynamicObject = row.get();
            dynamicObject.set("yem_merchname", (Object)datum.getString("yem_merchantstname"));
        } else {
            DynamicObject newRow = companyDetailsDC.addNew();
            newRow.set("yem_merchname", (Object)datum.getString("yem_merchantstname"));
            newRow.set("yem_merchantid", (Object)merchantApplyId);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bd_affiliation});
    }

    private void constructClientBank(DynamicObject datum, DynamicObject baseData) {
        DynamicObjectCollection datumBankDc = datum.getDynamicObjectCollection("yem_cs_kszr_yhzhxx");
        DynamicObjectCollection bdBankDc = baseData.getDynamicObjectCollection("entry_bank");
        bdBankDc.clear();
        for (DynamicObject datumBankRow : datumBankDc) {
            DynamicObject bdBankNewRow = bdBankDc.addNew();
            bdBankNewRow.set("isdefault_bank", datumBankRow.get("yem_isdefault_bank"));
            bdBankNewRow.set("bankaccount", datumBankRow.get("yem_bankaccount"));
            bdBankNewRow.set("accountname", datumBankRow.get("yem_accountname"));
            bdBankNewRow.set("iban", datumBankRow.get("yem_swfitcode"));
            bdBankNewRow.set("bank", datumBankRow.get("yem_bank"));
            bdBankNewRow.set("currency", datumBankRow.get("yem_currency"));
        }
    }

    private DynamicObject createAddress(DynamicObject client, DynamicObject datumLinkDcRow, boolean flag) {
        DynamicObject address = datumLinkDcRow.getDynamicObject("yem_bdaddressid");
        address = YEM.isEmpty(address) ? BusinessDataServiceHelper.newDynamicObject((String)"bd_address") : BusinessDataServiceHelper.loadSingle((Object)address.getPkValue(), (String)"bd_address");
        if (flag) {
            address.set("iscustomeradd", (Object)true);
            address.set("customer", (Object)client);
            address.set("customerid", client.get("id"));
        } else {
            address.set("issupplieradd", (Object)true);
            address.set("supplier", (Object)client);
            address.set("supplierid", client.get("id"));
        }
        address.set("name", (Object)datumLinkDcRow.getString("yem_name"));
        address.set("detailaddress", datumLinkDcRow.get("yem_addressac"));
        address.set("linkman", datumLinkDcRow.get("yem_fax"));
        address.set("phone", datumLinkDcRow.get("yem_phone"));
        address.set("addemail", datumLinkDcRow.get("yem_email"));
        address.set("zipcode", datumLinkDcRow.get("yem_zipcode"));
        address.set("status", (Object)"C");
        address.set("admindivisiondata", null);
        address.set("enable", (Object)"1");
        this.operation("save", "bd_address", new DynamicObject[]{address});
        return address;
    }

    private void constructBdLinkmanDc(DynamicObject newRow, DynamicObject datumLinkDcRow, DynamicObject address) {
        newRow.set("contactperson", (Object)datumLinkDcRow.getString("yem_name"));
        newRow.set("phone", datumLinkDcRow.get("yem_phone"));
        newRow.set("fax", datumLinkDcRow.get("yem_fax"));
        newRow.set("email", datumLinkDcRow.get("yem_email"));
        newRow.set("isdefault_linkman", datumLinkDcRow.get("yem_isdefault_linkman"));
        newRow.set("yem_linkmaninfoid", datumLinkDcRow.getPkValue());
        if (!YEM.isEmpty(address)) {
            newRow.set("associatedaddress", (Object)address);
        }
    }

    private void createBdHead(DynamicObject baseData, DynamicObject datum, Boolean flag) {
        long userId = UserServiceHelper.getCurrentUserId();
        baseData.set("creator", (Object)userId);
        Boolean isInternal = (Boolean)datum.get("yem_internal");
        if (isInternal.booleanValue()) {
            baseData.set("internal_company", datum.get("org"));
        }
        baseData.set("name", (Object)datum.getString("yem_merchantstname"));
        baseData.set("createorg", datum.get("org"));
        baseData.set("org", datum.get("org"));
        baseData.set("enable", (Object)"1");
        baseData.set("status", (Object)"A");
        baseData.set("yem_customeraccessid", datum.get("id"));
        DynamicObject groupDefaultRow = baseData.getDynamicObjectCollection("entry_groupstandard").addNew();
        baseData.set("country", datum.get("yem_country"));
        baseData.set("societycreditcode", datum.get("yem_societycreditcode"));
        baseData.set("tx_register_no", datum.get("yem_registerno"));
        baseData.set("artificialperson", datum.get("yem_artificialperson"));
        baseData.set("bizpartner_address", datum.get("yem_businessaddress"));
        baseData.set("businessscope", datum.get("yem_businessscope"));
        if (flag.booleanValue()) {
            DynamicObject customerStatus = BusinessDataServiceHelper.loadSingle((String)"bd_customerstatus", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ZSKH")});
            baseData.set("customerstatus", (Object)customerStatus);
            baseData.set("group", datum.get("yem_classifycustomer"));
            groupDefaultRow.set("standardid", (Object)BusinessDataServiceHelper.loadSingle((String)"bd_customergroupstandard", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"JBFLBZ")}));
            baseData.set("group", datum.get("yem_classifycustomer"));
            groupDefaultRow.set("groupid", (Object)datum.getDynamicObject("yem_classifycustomer"));
        } else {
            DynamicObject supplierStatus = BusinessDataServiceHelper.loadSingle((String)"bd_supplierstatus", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"ZCGYS")});
            baseData.set("supplier_status", (Object)supplierStatus);
            groupDefaultRow.set("standardid", (Object)BusinessDataServiceHelper.loadSingle((String)"bd_suppliergroupstandard", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)"JBFLBZ")}));
            baseData.set("group", datum.get("yem_classifysupplier"));
            groupDefaultRow.set("groupid", (Object)datum.getDynamicObject("yem_classifysupplier"));
        }
        DynamicObject payCurrency = datum.getDynamicObjectCollection("yem_cs_kszr_yhzhxx").stream().filter(row -> row.getBoolean("yem_isdefault_bank")).findFirst().orElse(null);
        baseData.set("paymentcurrency", (Object)payCurrency);
        DynamicObject defaultLinkman = datum.getDynamicObjectCollection("yem_cs_kszr_lxrxx").stream().filter(row -> row.getBoolean("yem_isdefault_linkman")).findFirst().orElse(null);
        if (defaultLinkman != null) {
            baseData.set("linkman", (Object)defaultLinkman.getString("yem_name"));
            baseData.set("bizpartner_phone", defaultLinkman.get("yem_phone"));
            baseData.set("bizpartner_fax", defaultLinkman.get("yem_fax"));
            baseData.set("postal_code", defaultLinkman.get("yem_email"));
            baseData.set("bizpartner_address", defaultLinkman.get("yem_addressac"));
        }
    }

    private void deleteCustomerLinkman(DynamicObjectCollection datumLinkmanDc, DynamicObject bdData) {
        List datumLinkmanRowId = datumLinkmanDc.stream().map(row -> row.getLong("id")).collect(Collectors.toList());
        DynamicObjectCollection customerLinkmanDc = bdData.getDynamicObjectCollection("entry_linkman");
        ArrayList<String> deleteAddress = new ArrayList<String>();
        Iterator iterator = customerLinkmanDc.iterator();
        while (iterator.hasNext()) {
            DynamicObject customerRow = (DynamicObject)iterator.next();
            long customerRowSourceId = customerRow.getLong("yem_linkmaninfoid");
            if (datumLinkmanRowId.contains(customerRowSourceId)) continue;
            iterator.remove();
            DynamicObject associatedAddress = customerRow.getDynamicObject("associatedaddress");
            if (YEM.isEmpty(associatedAddress)) continue;
            deleteAddress.add(associatedAddress.getString("number"));
        }
        DeleteServiceHelper.delete((String)"bd_address", (QFilter[])new QFilter[]{new QFilter("number", "in", deleteAddress)});
    }
}

