/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.bill.customeraccess.opplugin.op;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.sdk.plugin.Plugin;
import yem.wm.cs.trade.common.DynamicObjectUtil;
import yem.wm.cs.trade.common.StringUtils;
import yem.wm.cs.trade.qcc.invoke.BusinessInfo;
import yem.wm.cs.trade.qcc.invoke.EnterpriseQuaInfo;
import yem.wm.cs.trade.qcc.invoke.FinanceTax;
import yem.wm.cs.trade.qcc.invoke.JudicialInfo;
import yem.wm.cs.trade.qcc.invoke.ManagementInfo;
import yem.wm.cs.trade.qcc.invoke.PersonInfo;

public class CustomerAccessInvokeOpPlugin
extends AbstractOperationServicePlugIn
implements Plugin {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities1;
                for (ExtendedDataEntity extendedDataEntity : dataEntities1 = this.getDataEntities()) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    String name = dataEntity.getString("yem_merchantstname");
                    String code = dataEntity.getString("yem_societycreditcode");
                    if (!StringUtils.isEmpty(name) || !StringUtils.isEmpty(code)) continue;
                    this.addErrorMessage(extendedDataEntity, "\u540d\u79f0\u6216\u7edf\u4e00\u793e\u4f1a\u4fe1\u7528\u4ee3\u7801\u5fc5\u987b\u586b\u5199\u540e\u624d\u80fd\u67e5\u8be2");
                }
            }
        });
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(DynamicObjectUtil.addFieldKey("yem_cs_customeraccess", true));
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities1;
        super.beforeExecuteOperationTransaction(e);
        for (DynamicObject dynamicObject : dataEntities1 = e.getDataEntities()) {
            String name = dynamicObject.getString("yem_merchantstname").trim();
            String code = dynamicObject.getString("yem_societycreditcode").trim();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("name", name);
            param.put("code", code);
            BusinessInfo.createBusinessInfo(param);
            FinanceTax.createFinanceTax(param);
            JudicialInfo.createFinanceTax(param);
            ManagementInfo.createFinanceTax(param);
            PersonInfo.createPersonIfo(param);
            EnterpriseQuaInfo.createInfo(param);
        }
    }
}

