/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.bill.customeraccess.opplugin.validator;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import yem.wm.cs.trade.common.YEM;

public class CustomerAccessValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        if (!"submit".equals(this.getOperateKey())) {
            return;
        }
        for (ExtendedDataEntity client : dataEntities = this.getDataEntities()) {
            DynamicObject datum = client.getDataEntity();
            DynamicObjectCollection linkmanDc = datum.getDynamicObjectCollection("yem_cs_kszr_lxrxx");
            DynamicObjectCollection bankDc = datum.getDynamicObjectCollection("yem_cs_kszr_yhzhxx");
            this.uniqueMerchantsName(client, datum);
            this.uniqueOrgBaseData(client, datum);
            this.uniqueBankCountName(client, bankDc);
            DynamicObjectCollection warehouseDc = this.validateWarehouseUnique(client, datum);
            this.validateLocationUnique(client, warehouseDc);
            this.includeDefault(linkmanDc, "yem_isdefault_linkman", client);
            this.includeDefault(bankDc, "yem_isdefault_bank", client);
            this.linkmanValidate(client, linkmanDc);
            this.dangerousRelationAtt(client);
        }
    }

    private void uniqueBankCountName(ExtendedDataEntity client, DynamicObjectCollection bankDc) {
        HashSet<String> bankCount = new HashSet<String>();
        for (DynamicObject dynamicObject : bankDc) {
            String bankAccount = dynamicObject.getString("yem_bankaccount");
            if (bankCount.add(bankAccount)) continue;
            this.addErrorMessage(client, "\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u76f8\u540c");
        }
    }

    private void uniqueOrgBaseData(ExtendedDataEntity client, DynamicObject datum) {
        DynamicObject org = datum.getDynamicObject("org");
        DynamicObject yemClassifySupplier = datum.getDynamicObject("yem_classifysupplier");
        DynamicObject classIfyCustomer = datum.getDynamicObject("yem_classifycustomer");
        QFilter qfName = new QFilter("name", "=", (Object)datum.getString("yem_merchantstname"));
        QFilter qfDatumId = new QFilter("yem_customeraccessid", "!=", datum.getPkValue());
        QFilter qfOrg = new QFilter("org.id", "=", org.getPkValue());
        QFilter qfCreateOrg = new QFilter("createorg.id", "=", org.getPkValue());
        if (null != classIfyCustomer && QueryServiceHelper.exists((String)"bd_customer", (QFilter[])new QFilter[]{qfName, qfOrg, qfCreateOrg, qfDatumId})) {
            this.addErrorMessage(client, "\u7ec4\u7ec7\u4e0b\u8be5\u5ba2\u6237\u5df2\u5b58\u5728\t\u5207\u6362\u7ec4\u7ec7\u6216\u8005\u91cd\u65b0\u8f93\u5165\u5ba2\u5546\u540d\u79f0");
        }
        if (null != yemClassifySupplier && QueryServiceHelper.exists((String)"bd_supplier", (QFilter[])new QFilter[]{qfName, qfOrg, qfCreateOrg, qfDatumId})) {
            this.addErrorMessage(client, "\u7ec4\u7ec7\u4e0b\u8be5\u4f9b\u5e94\u5546\u5df2\u5b58\u5728\t\u5207\u6362\u7ec4\u7ec7\u6216\u8005\u91cd\u65b0\u8f93\u5165\u5ba2\u5546\u540d\u79f0");
        }
    }

    private void linkmanValidate(ExtendedDataEntity client, DynamicObjectCollection linkmanDc) {
        String email;
        DynamicObject linkmanDcRow;
        String phone;
        Iterator iterator = linkmanDc.iterator();
        while (iterator.hasNext() && !(phone = (linkmanDcRow = (DynamicObject)iterator.next()).getString("yem_phone")).trim().isEmpty() && !(email = linkmanDcRow.getString("yem_email")).trim().isEmpty()) {
            if (!email.trim().equals(phone.trim())) continue;
            this.addErrorMessage(client, String.format("\u8054\u7cfb\u4eba\u5206\u5f55\u7b2c%d\u884c\u8054\u7cfb\u7535\u8bdd\u548c\u90ae\u7bb1\u91cd\u590d\t\u91cd\u65b0\u63d0\u4ea4\u7535\u8bdd\u548c\u90ae\u7bb1", linkmanDc.indexOf((Object)linkmanDcRow) + 1));
        }
    }

    private void validateLocationUnique(ExtendedDataEntity client, DynamicObjectCollection warehouseDc) {
        for (DynamicObject warehouseDcRow : warehouseDc) {
            DynamicObjectCollection locationDc = warehouseDcRow.getDynamicObjectCollection("yem_cs_kszr_cwxx");
            for (DynamicObject locationRow : locationDc) {
                DynamicObject locationMain = locationRow.getDynamicObject("yem_bdlocaiton");
                if (!YEM.isEmpty(locationMain)) continue;
                String locationRowName = locationRow.getString("yem_positionname");
                QFilter qfLocationName = new QFilter("name", "=", (Object)locationRowName);
                if (QueryServiceHelper.exists((String)"bd_location", (QFilter[])new QFilter[]{qfLocationName})) {
                    this.addErrorMessage(client, String.format("\u4ed3\u5e93\u4fe1\u606f\u7684%d\u884c\u7684\u4ed3\u4f4d\u4fe1\u606f%d\u540d\u79f0\u91cd\u590d\t\u91cd\u65b0\u7f16\u8f91\u540d\u79f0", warehouseDc.indexOf((Object)warehouseDcRow) + 1, locationDc.indexOf((Object)locationRow)));
                }
                String locationNum = locationRow.getString("yem_positioncode");
                QFilter qfLocationNum = new QFilter("number", "=", (Object)locationNum);
                if (!QueryServiceHelper.exists((String)"bd_location", (QFilter[])new QFilter[]{qfLocationNum})) continue;
                this.addErrorMessage(client, String.format("\u4ed3\u5e93\u4fe1\u606f\u7684%d\u884c\u7684\u4ed3\u4f4d\u4fe1\u606f%d\u7f16\u7801\u91cd\u590d\t\u91cd\u65b0\u7f16\u8f91\u7f16\u7801", warehouseDc.indexOf((Object)warehouseDcRow) + 1, locationDc.indexOf((Object)locationRow)));
            }
        }
    }

    private DynamicObjectCollection validateWarehouseUnique(ExtendedDataEntity client, DynamicObject datum) {
        DynamicObjectCollection warehouseDc = datum.getDynamicObjectCollection("yem_cs_kszr_ckxx");
        DynamicObject createOrg = datum.getDynamicObject("org");
        QFilter qfWarehouse = new QFilter("createorg.id", "=", createOrg.getPkValue());
        for (DynamicObject warehouseRow : warehouseDc) {
            DynamicObject mainWarehouseRow = warehouseRow.getDynamicObject("yem_warehouse");
            if (!YEM.isEmpty(mainWarehouseRow)) continue;
            String warehouseRowName = warehouseRow.getString("yem_warehousename");
            qfWarehouse.and("name", "=", (Object)warehouseRowName);
            if (!QueryServiceHelper.exists((String)"bd_warehouse", (QFilter[])new QFilter[]{qfWarehouse})) continue;
            this.addErrorMessage(client, "\u7ec4\u7ec7\u4e0b\u5df2\u6709\u8fd9\u4e2a\u4ed3\u5e93 ");
        }
        return warehouseDc;
    }

    private void uniqueMerchantsName(ExtendedDataEntity client, DynamicObject datum) {
        String merchantsName = datum.getString("yem_merchantstname");
        boolean onlyClientName = QueryServiceHelper.exists((String)"yem_cs_customeraccess", (QFilter[])new QFilter[]{new QFilter("yem_merchantstname", "=", (Object)merchantsName), new QFilter("id", "!=", datum.getPkValue())});
        if (onlyClientName) {
            this.addErrorMessage(client, "\u5ba2\u5546\u540d\u79f0\u5df2\u5b58\u5728,\u8bf7\u4fee\u6539\u5ba2\u5546\u59d3\u540d\u540e\u91cd\u65b0\u63d0\u4ea4");
        }
    }

    private void includeDefault(DynamicObjectCollection dc, String defaultValue, ExtendedDataEntity client) {
        Set includeDefault;
        if (!YEM.isEmpty(dc) && (includeDefault = dc.stream().filter(e -> {
            e.getBoolean(defaultValue);
            return e.getBoolean(defaultValue);
        }).collect(Collectors.toSet())).isEmpty() && !dc.isEmpty()) {
            switch (defaultValue) {
                case "yem_isdefault_linkman": {
                    this.addErrorMessage(client, "\u586b\u5199\u8054\u7cfb\u4eba\u5fc5\u987b\u8bbe\u7f6e\u4e00\u884c\u4e3a\u9ed8\u8ba4\u884c,\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u8054\u7cfb\u4eba\n");
                    break;
                }
                case "yem_isdefault_bank": {
                    this.addErrorMessage(client, "\u586b\u5199\u94f6\u884c\u4fe1\u606f\u5fc5\u987b\u8bbe\u7f6e\u4e00\u884c\u4e3a\u9ed8\u8ba4\u884c,\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u94f6\u884c\u4fe1\u606f\u884c\n");
                }
            }
        }
    }

    private void dangerousRelationAtt(ExtendedDataEntity client) {
        String attachment;
        Object billPkId;
        List yemCsCustomeraccess;
        Boolean dangerous = (Boolean)client.getValue("yem_dangerous");
        if (dangerous.booleanValue() && (yemCsCustomeraccess = AttachmentServiceHelper.getAttachments((String)"yem_cs_customeraccess", (Object)(billPkId = client.getBillPkId()), (String)(attachment = "attachmentpanel"), (boolean)false)).isEmpty()) {
            this.addErrorMessage(client, "\u5371\u5316\u54c1\u88ab\u9009\u4e2d\u5fc5\u987b\u8981\u4e0a\u4f20\u76f8\u5e94\u7684\u9644\u4ef6");
        }
    }
}

