/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.common;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.framework.core.exception.BizException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import yem.wm.cs.trade.common.QccData;
import yem.wm.cs.trade.common.UriInfo;

public class QCCUtil {
    static final String KEY = "89f3473bf8bd46a1ac8b48810cfa55c4";
    static final String SECRET_KEY = "89f3473bf8bd46a1ac8b48810cfa55c4";

    public static Map<String, String> getQccHeaders() {
        String timeSpan = String.valueOf(System.currentTimeMillis() / 1000L);
        String TOKEN = DigestUtils.md5Hex((String)"89f3473bf8bd46a1ac8b48810cfa55c4".concat(timeSpan).concat("89f3473bf8bd46a1ac8b48810cfa55c4")).toUpperCase();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Token", TOKEN);
        headers.put("Timespan", timeSpan);
        return headers;
    }

    public static JSONObject queryQcc(String flag, String baseUri, Map<String, String> requestParam) {
        String jsonString = "";
        HttpHead httpHead = QCCUtil.constructorUri(baseUri, requestParam);
        switch (flag) {
            case "BusinessInformation": {
                jsonString = QccData.BUSINESS_INFORMATION.getData();
                break;
            }
            case "HistoryRecord": {
                jsonString = QccData.HISTORY_RECORD.getData();
                break;
            }
            case "ExceptionCheck": {
                jsonString = QccData.EXCEPTION_CHECK.getData();
                break;
            }
            case "ShareHolder": {
                jsonString = QccData.SHAREHOLDER.getData();
                break;
            }
            case "EQUITY_THROUGH": {
                jsonString = QccData.EQUITY_THROUGH.getData();
                break;
            }
            case "AnnualReport": {
                jsonString = QccData.ANNUAL_REPORT.getData();
                break;
            }
            case "TaxOweNoticeCheck": {
                jsonString = QccData.TAX_OWE_NOTICE_CHECK.getData();
                break;
            }
            case "TaxIllegalCheck": {
                jsonString = QccData.TAX_ILLEGAL_CHECK.getData();
                break;
            }
            case "JudicialAuction": {
                jsonString = QccData.JUDICIAL_AUCTION.getData();
                break;
            }
            case "SUMPTUARY_CHECK": {
                jsonString = QccData.SUMPTUARY_CHECK.getData();
                break;
            }
            case "SeriousViolation": {
                jsonString = QccData.SERIOUS_VIOLATION.getData();
                break;
            }
            case "Enforcement": {
                jsonString = QccData.ENFORCEMENT_CHECK.getData();
                break;
            }
            case "JudicialDocument": {
                jsonString = QccData.JUDICIAL_DOCUMENT.getData();
                break;
            }
            case "PenaltyDecision": {
                jsonString = QccData.PENALTY_DECISION.getData();
                break;
            }
            case "EnvPunish": {
                jsonString = QccData.ENV_PUNISH.getData();
                break;
            }
            case "BankruptcyCheck": {
                jsonString = QccData.BANKRUPTCY_CHECK.getData();
                break;
            }
            case "CreditorBreach": {
                jsonString = QccData.CREDITOR_BREACH.getData();
                break;
            }
            case "Liquidation": {
                jsonString = QccData.LIQUIDATION.getData();
                break;
            }
            case "EMPLOYEE": {
                jsonString = QccData.EMPLOYEE.getData();
                break;
            }
            case "SX_CHECK": {
                jsonString = QccData.SX_CHECK.getData();
                break;
            }
            case "CERTIFICATION": {
                jsonString = QccData.CERTIFICATION.getData();
            }
        }
        Object rp = null;
        CloseableHttpClient pl = HttpClients.createDefault();
        JSONObject data = JSON.parseObject((String)jsonString);
        DynamicObject invokeLog = BusinessDataServiceHelper.newDynamicObject((String)"yem_invokelog");
        invokeLog.set("yem_desc", (Object)UriInfo.getTitleByUri(baseUri));
        invokeLog.set("yem_uri", (Object)baseUri);
        invokeLog.set("yem_keyword", (Object)requestParam.get("keyword"));
        invokeLog.set("yem_status", data.get((Object)"Status"));
        invokeLog.set("yem_message", data.get((Object)"Message"));
        invokeLog.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        invokeLog.set("createtime", (Object)System.currentTimeMillis());
        if (jsonString.length() > 2000) {
            jsonString = jsonString.substring(0, 2000);
        }
        invokeLog.set("yem_source", (Object)jsonString);
        invokeLog.set("yem_issucceed", (Object)(data.getIntValue("yem_success") == 200 ? 1 : 0));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{invokeLog});
        return data;
    }

    private static HttpHead constructorUri(String baseUrl, Map<String, String> rqParam) {
        HttpHead reqHeader = new HttpHead();
        Map<String, String> headers = QCCUtil.getQccHeaders();
        reqHeader.setHeader("Token", headers.get("Token"));
        reqHeader.setHeader("Timespan", headers.get("Timespan"));
        String queryString = rqParam.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (String)entry.getValue()).collect(Collectors.joining("&"));
        String fullUrl = baseUrl + (baseUrl.contains("?") ? "&" : "?") + queryString;
        reqHeader.setURI(URI.create(fullUrl));
        return reqHeader;
    }

    public static void parseJsonCommon(JSONObject rp) {
        String status = rp.getString("Status");
        if (!status.equals("200")) {
            throw new BizException("\u8c03\u7528\u63a5\u53e3\u5931\u8d25");
        }
    }

    public static HashMap<Object, Object> getRsData(String flag, HashMap<String, String> req, String uri) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        JSONObject rp = QCCUtil.queryQcc(flag, uri, req);
        map.put("rp", rp);
        QCCUtil.parseJsonCommon(rp);
        Object rs = rp.get((Object)"Result");
        if (rs instanceof JSONArray) {
            map.put("rs", rs);
            Object page = rp.get((Object)"Paging");
            map.put("page", page);
            return map;
        }
        JSONObject rs1 = rp.getJSONObject("Result");
        int verifyResult = rs1.getIntValue("VerifyResult");
        if (verifyResult != 0 || rs1.get((Object)"VerifyResult") == null) {
            map.put("rs", rs1);
            Object data = rs1.get((Object)"Data");
            map.put("data", data);
            Object page = rp.get((Object)"Paging");
            map.put("page", page);
        }
        return map;
    }

    public static DynamicObject setCommonFiled(String newEntity, String companyName) {
        DynamicObject certificateInfo = BusinessDataServiceHelper.newDynamicObject((String)newEntity);
        QFilter[] qfByName = new QFilter[]{new QFilter("name", "=", (Object)companyName)};
        DynamicObject businessInfo = BusinessDataServiceHelper.loadSingle((String)"yem_cs_businessinfo", (QFilter[])qfByName);
        certificateInfo.set("number", (Object)businessInfo.getString("number"));
        certificateInfo.set("name", (Object)businessInfo.getString("name"));
        return certificateInfo;
    }
}

