/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.common;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;

public class StringUtils {
    public static boolean isEmpty(String string) {
        return StringUtils.isNull(string) || StringUtils.isBlank(string);
    }

    public static boolean isNotEmpty(String string) {
        return !StringUtils.isEmpty(string);
    }

    public static String getEmpty() {
        return "";
    }

    public static boolean isNull(String string) {
        return string == null;
    }

    public static boolean isNotNull(String string) {
        return !StringUtils.isNull(string);
    }

    public static boolean isBlank(String string) {
        return StringUtils.isNotNull(string) && string.trim().length() == 0;
    }

    public static String trim(String string) {
        return StringUtils.isNull(string) ? StringUtils.getEmpty() : string.trim();
    }

    public static String formatMessage(String msg, Object[] params) {
        return MessageFormat.format(msg, params);
    }

    public static String setToString(Set valueSet) {
        StringBuffer returnValue = new StringBuffer("(");
        if (valueSet != null && valueSet.size() != 0) {
            Iterator it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? (String)obj : obj.toString();
                if (tempValue == null || tempValue.trim().length() == 0) continue;
                if (flag) {
                    returnValue.append(",");
                }
                returnValue.append("'");
                returnValue.append(tempValue);
                returnValue.append("'");
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(")");
        return returnValue.toString();
    }

    public static String setToString(DynamicObjectCollection value, String field) {
        StringBuffer returnValue = new StringBuffer("(");
        if (value != null && value.size() != 0) {
            boolean flag = false;
            for (DynamicObject obj : value) {
                if (flag) {
                    returnValue.append(",");
                }
                returnValue.append("'");
                returnValue.append(obj.getString(field));
                returnValue.append("'");
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(")");
        return returnValue.toString();
    }

    public static String splitString(String number, int step, String split) {
        String value = null;
        if (!StringUtils.isEmpty(number)) {
            while (number.length() > 0) {
                int cutStep = step;
                if (cutStep > number.length()) {
                    cutStep = number.length();
                }
                value = StringUtils.isEmpty(value) ? number.substring(0, cutStep) : value + split + number.substring(0, cutStep);
                number = number.substring(cutStep);
            }
        }
        return value;
    }

    public static String listToString(List<String> fliedList) {
        StringBuffer sb = new StringBuffer();
        if (fliedList.size() == 0) {
            throw new IllegalArgumentException("intList.size cannot be 0!");
        }
        if (fliedList.size() == 1) {
            sb.append(fliedList.get(0));
        } else {
            Iterator<String> it = fliedList.iterator();
            int n = fliedList.size();
            for (int i = 0; i < n - 1; ++i) {
                sb.append(it.next()).append(", ");
            }
            sb.append(it.next());
        }
        return sb.toString();
    }

    public static Object[] getPks(DynamicObject[] objArray) {
        if (objArray == null || objArray.length == 0) {
            return new Object[0];
        }
        Object[] pks = new Object[objArray.length];
        for (int i = 0; i < objArray.length; ++i) {
            pks[i] = objArray[i].getPkValue();
        }
        return pks;
    }

    public static Object[] getPks(DynamicObjectCollection objArray) {
        if (objArray == null || objArray.size() == 0) {
            return new Object[0];
        }
        Object[] pks = new Object[objArray.size()];
        for (int i = 0; i < objArray.size(); ++i) {
            pks[i] = ((DynamicObject)objArray.get(i)).getPkValue();
        }
        return pks;
    }

    public static <T> List<T> makeList(T ... e) {
        ArrayList<T> statusList = new ArrayList<T>();
        for (int i = 0; i < e.length; ++i) {
            statusList.add(e[i]);
        }
        return statusList;
    }

    public static String setToSelectorString(Set<String> valueSet) {
        StringBuffer returnValue = new StringBuffer("");
        if (valueSet != null && valueSet.size() != 0) {
            Iterator<String> it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            String obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? obj : obj.toString();
                if (tempValue == null || tempValue.trim().length() == 0) continue;
                if (flag) {
                    returnValue.append(",");
                }
                returnValue.append(tempValue);
                flag = true;
            }
        }
        return returnValue.toString();
    }

    public static String padLeft(String src, int len, char ch) {
        int diff = len - src.length();
        if (diff <= 0) {
            return src;
        }
        char[] charr = new char[len];
        System.arraycopy(src.toCharArray(), 0, charr, 0, src.length());
        for (int i = src.length(); i < len; ++i) {
            charr[i] = ch;
        }
        return new String(charr);
    }

    public static String padRight(String src, int len, char ch) {
        int diff = len - src.length();
        if (diff <= 0) {
            return src;
        }
        char[] charr = new char[len];
        System.arraycopy(src.toCharArray(), 0, charr, diff, src.length());
        for (int i = 0; i < diff; ++i) {
            charr[i] = ch;
        }
        return new String(charr);
    }
}

