/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.common;

public enum UriInfo {
    ECI_V4("\u4f01\u4e1a\u5de5\u5546\u4fe1\u606f", "https://api.qichacha.com/ECIV4/GetBasicDetailsByName", "key"),
    HISTORY_ECI("\u5386\u53f2\u5de5\u5546\u4fe1\u606f\u6838\u67e5", "https://api.qichacha.com/HistoryEciCheck/GetInfo", "key"),
    EXCEPTION_CHECK("\u7ecf\u8425\u5f02\u5e38\u6838\u67e5", "https://api.qichacha.com/ExceptionCheck/GetList", "key"),
    ECI_PARTNER("\u80a1\u4e1c\u4fe1\u606f(\u5de5\u5546\u767b\u8bb0)", "https://api.qichacha.com/ECIPartner/GetList", "key"),
    EQUITY_THROUGH("\u80a1\u6743\u7a7f\u900f", "https://api.qichacha.com/EquityThrough/GetEquityThrough", "key"),
    ECI_CERTIFICATION("\u8d44\u8d28\u8bc1\u4e66", "https://api.qichacha.com/ECICertification/SearchCertification", "key"),
    ANNUAL_REPORT("\u4f01\u4e1a\u5e74\u62a5", "https://api.qichacha.com/AR/GetAnnualReport", "key"),
    TAX_OWE_NOTICE("\u6b20\u7a0e\u516c\u544a\u6838\u67e5", "https://api.qichacha.com/TaxOweNoticeCheck/GetList", "key"),
    TAX_ILLEGAL("\u7a0e\u6536\u8fdd\u6cd5\u6838\u67e5", "https://api.qichacha.com/TaxIllegalCheck/GetList", "key"),
    JUDICIAL_SALE("\u53f8\u6cd5\u62cd\u5356\u6838\u67e5", "https://api.qichacha.com/JudicialSaleCheck/GetList", "key"),
    SERIOUS_ILLEGAL("\u4e25\u91cd\u8fdd\u6cd5\u6838\u67e5", "https://api.qichacha.com/SeriousIllegalCheck/GetList", "key"),
    SUMPTUARY("\u9650\u5236\u9ad8\u6d88\u8d39\u6838\u67e5", "https://api.qichacha.com/SumptuaryCheck/GetList", "key"),
    PERSON_ENFORCEMENT("\u88ab\u6267\u884c\u4eba\u6838\u67e5", "https://api.qichacha.com/ZhixingCheck/GetList", "key"),
    JUDGMENT_DOC("\u88c1\u5224\u6587\u4e66\u6838\u67e5", "https://api.qichacha.com/JudgmentDocCheck/GetList", "key"),
    ADMIN_PENALTY("\u884c\u653f\u5904\u7f5a\u6838\u67e5", "https://api.qichacha.com/AdminPenaltyCheck/GetList", "key"),
    ENV_PUNISHMENT("\u73af\u4fdd\u5904\u7f5a\u6838\u67e5", "https://api.qichacha.com/EnvPunishmentCheck/GetList", "key"),
    BANKRUPTCY("\u7834\u4ea7\u91cd\u6574", "https://api.qichacha.com/BankruptcyCheck/GetList", "key"),
    CREDITOR_BREACH("\u8fdd\u7ea6\u4e8b\u9879\u6838\u67e5", "https://api.qichacha.com/CreditorBreachCheck/GetList", "key"),
    LIQUIDATION("\u6e05\u7b97\u6838\u67e5", "https://api.qichacha.com/LiquidationCheck/GetDetail", "key"),
    ECI_EMPLOYEE("\u4e3b\u8981\u4eba\u5458", "https://api.qichacha.com/ECIEmployee/GetList", "key"),
    HIS_SX("\u8463\u76d1\u9ad8\u5931\u4fe1", "https://api.qichacha.com/PersonHisSXCheck/GetList", "key");

    private final String title;
    private final String uri;
    private final String key;

    private UriInfo(String title, String url, String key) {
        this.title = title;
        this.uri = url;
        this.key = key;
    }

    public static String getTitleByUri(String uri) {
        UriInfo[] values;
        for (UriInfo uriInfo : values = UriInfo.values()) {
            if (!uriInfo.getUri().contains(uri)) continue;
            return uriInfo.getTitle();
        }
        return null;
    }

    public static String getKeyByUri(String key) {
        UriInfo[] values;
        for (UriInfo uriInfo : values = UriInfo.values()) {
            if (!uriInfo.getKey().equals(key)) continue;
            return uriInfo.getKey();
        }
        return null;
    }

    public String getKey() {
        return this.key;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUri() {
        return this.uri;
    }
}

