/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.qcc.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.wm.cs.trade.common.QCCUtil;
import yem.wm.cs.trade.common.StringUtils;

public class BusinessInfo {
    private static final String BUSINESS_INFORMATION = "https://api.qichacha.com/ECIV4/GetBasicDetailsByName";
    private static final String HISTORY_RECORD = "https://api.qichacha.com/HistoryEciCheck/GetInfo";
    private static final String EXCEPTION_CHECK = "https://api.qichacha.com/ExceptionCheck/GetList";
    private static final String SHARE_HOLDER = "https://api.qichacha.com/ECIPartner/GetList";
    private static final String EQUITY_THROUGH = "https://api.qichacha.com/EquityThrough/GetEquityThrough";

    public static void createBusinessInfo(HashMap<String, String> param) {
        DynamicObject businessInfo = BusinessDataServiceHelper.newDynamicObject((String)"yem_cs_businessinfo");
        BusinessInfo.constructHead(businessInfo, param.get("name"));
        BusinessInfo.queryShareHolder(businessInfo, param.get("name"));
        BusinessInfo.queryEquityThrough(businessInfo, param.get("name"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{businessInfo});
    }

    private static void constructHead(DynamicObject businessInfo, final String companyName) {
        String flag = "BusinessInformation";
        HashMap<String, String> req = new HashMap<String, String>(){
            {
                this.put("key", "\u6682\u5b9a");
                this.put("keyword", companyName);
            }
        };
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, BUSINESS_INFORMATION);
        if (!map.containsKey("rs")) {
            return;
        }
        BusinessInfo.parseJsonBusinessInfo((JSONObject)map.get("rs"), businessInfo, companyName);
    }

    private static void queryEquityThrough(DynamicObject businessInfo, final String companyName) {
        HashMap<String, String> req = new HashMap<String, String>(){
            {
                this.put("key", "\u80a1\u6743\u7a7f\u900fAPIKEY");
                this.put("keyword", companyName);
            }
        };
        String flag = "EQUITY_THROUGH";
        HashMap<Object, Object> map = QCCUtil.getRsData("EQUITY_THROUGH", req, EQUITY_THROUGH);
        if (!map.containsKey("rs")) {
            return;
        }
        DynamicObjectCollection equityDc = businessInfo.getDynamicObjectCollection("yem_cs_gsxx_gqct");
        equityDc.clear();
        JSONObject rs = (JSONObject)map.get("rs");
        JSONArray children = rs.getJSONArray("Children");
        BusinessInfo.parseEquityThrough(children, equityDc);
    }

    private static void parseEquityThrough(JSONArray children, DynamicObjectCollection equityDc) {
        for (int i = 0; i < children.size(); ++i) {
            DynamicObject row = equityDc.addNew();
            JSONObject jo = children.getJSONObject(i);
            row.set("yem_companynamerow", (Object)jo.getString("Name"));
            row.set("yem_type", (Object)BusinessInfo.getType(jo.getString("Category")));
            String fundedRatio = jo.getString("FundedRatio");
            if (!StringUtils.isEmpty(fundedRatio)) {
                fundedRatio = fundedRatio.replace("%", "");
            }
            row.set("yem_investment", (Object)fundedRatio);
            row.set("yem_subscription", (Object)jo.getString("ShouldCapi"));
            row.set("yem_shareholding", (Object)jo.getString("StockRightNum"));
            row.set("yem_status", (Object)jo.getString("ShortStatus"));
            JSONArray children1 = jo.getJSONArray("Children");
            if (children1 == null || children1.isEmpty()) continue;
            BusinessInfo.parseEquityThrough(children1, equityDc);
        }
    }

    private static void queryShareHolder(DynamicObject businessInfo, final String companyName) {
        String flag = "ShareHolder";
        HashMap<String, String> req = new HashMap<String, String>(){
            {
                this.put("key", "\u80a1\u4e1c\u4fe1\u606fAPIKEY");
                this.put("keyword", companyName);
                this.put("pageSize", "20");
            }
        };
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, SHARE_HOLDER);
        if (!map.containsKey("rs")) {
            return;
        }
        JSONArray rs = (JSONArray)map.get("rs");
        DynamicObjectCollection shareHolderBody = businessInfo.getDynamicObjectCollection("yem_cs_gsxx_gdxx");
        shareHolderBody.clear();
        for (Object r : rs) {
            JSONObject jo = (JSONObject)r;
            DynamicObject row = shareHolderBody.addNew();
            row.set("yem_shareholdname", (Object)jo.getString("StockName"));
            row.set("yem_investortype", (Object)jo.getString("StockType"));
            row.set("yem_shareholdingratio", (Object)jo.getString("StockPercent").replace("%", ""));
            row.set("yem_shareholdingratio", jo.get((Object)"ShouldCapi"));
            row.set("yem_fundingtime", (Object)jo.getDate("ShoudDate"));
            row.set("yem_participationdate", (Object)jo.getDate("StakeDate"));
            row.set("yem_state", (Object)jo.getString("StakeDate"));
        }
    }

    private static void parseJsonBusinessInfo(JSONObject rs, DynamicObject businessInfo, String companyName) {
        Long revokeDate;
        businessInfo.set("name", (Object)rs.getString("Name"));
        businessInfo.set("yem_legalrepresenta", (Object)rs.getString("OperName"));
        businessInfo.set("number", (Object)rs.getString("CreditCode"));
        businessInfo.set("yem_registrationum", (Object)rs.getString("No"));
        businessInfo.set("yem_datestablishment", (Object)rs.getDate("StartDate"));
        businessInfo.set("yem_registecapital", (Object)rs.getString("RegistCapi"));
        businessInfo.set("yem_paidin", (Object)rs.getString("RecCap"));
        businessInfo.set("yem_reduceamount", (Object)BusinessInfo.getHistoryRecord(companyName));
        businessInfo.set("yem_anomchecking", (Object)BusinessInfo.getExceptionCheck(companyName));
        JSONObject revokeInfo = rs.getJSONObject("RevokeInfo");
        Date cancelDate = revokeInfo.getDate("CancelDate");
        if (cancelDate != null) {
            businessInfo.set("yem_logout", (Object)true);
            businessInfo.set("yem_logoutdate", (Object)cancelDate);
            businessInfo.set("yem_logoutreason", (Object)revokeInfo.getString("CancelReason"));
        }
        if ((revokeDate = revokeInfo.getLong("RevokeDate")) != null) {
            businessInfo.set("yem_revoked", (Object)true);
            businessInfo.set("yem_revokedate", (Object)revokeDate);
            businessInfo.set("yem_revokedreason", (Object)revokeInfo.getString("RevokeReason"));
        }
        businessInfo.set("yem_businesscope", (Object)rs.getString("Scope"));
    }

    private static int getExceptionCheck(final String companyName) {
        String flag = "ExceptionCheck";
        HashMap<String, String> req = new HashMap<String, String>(){
            {
                this.put("key", "\u6682\u5b9a");
                this.put("keyword", companyName);
            }
        };
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, EXCEPTION_CHECK);
        JSONObject rs = (JSONObject)map.get("rs");
        int verifyResult = rs.getIntValue("VerifyResult");
        if (verifyResult == 1) {
            return rs.getJSONArray("Data").size();
        }
        return verifyResult;
    }

    private static Double getHistoryRecord(final String companyName) {
        String flag = "HistoryRecord";
        HashMap<String, String> req = new HashMap<String, String>(){
            {
                this.put("key", "\u6682\u5b9a");
                this.put("keyword", companyName);
            }
        };
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, HISTORY_RECORD);
        if (!map.containsKey("rs")) {
            return Double.NaN;
        }
        return BusinessInfo.parseJsonChangeRecord((JSONObject)map.get("rp"));
    }

    private static double parseJsonChangeRecord(JSONObject rp) {
        JSONObject rs = rp.getJSONObject("Result");
        Integer verifyResult = rs.getInteger("VerifyResult");
        JSONObject data = rs.getJSONObject("Data");
        if (verifyResult == 0) {
            return 0.0;
        }
        JSONArray registerCapitalList = data.getJSONArray("RegistCapiList");
        double changeMoney = registerCapitalList.stream().mapToDouble(e -> {
            String oldValue = ((JSONObject)e).getString("Oldvalue").replace("\u4e07\u5143", "").trim();
            return Double.parseDouble(oldValue);
        }).sum();
        if (changeMoney >= 0.0) {
            return 0.0;
        }
        return changeMoney;
    }

    private static String getType(String type) {
        switch (type) {
            case "0": {
                type = "\u516c\u53f8";
                break;
            }
            case "1": {
                type = "\u793e\u4f1a\u7ec4\u7ec7";
                break;
            }
            case "2": {
                type = "\u81ea\u7136\u4eba";
                break;
            }
            case "3": {
                type = "\u9999\u6e2f\u516c\u53f8";
                break;
            }
            case "4": {
                type = "\u653f\u5e9c\u673a\u6784\u548c\u5b66\u6821";
                break;
            }
            case "5": {
                type = "\u53f0\u6e7e\u516c\u53f8";
                break;
            }
            case "6": {
                type = "\u79c1\u52df\u57fa\u91d1\u4ea7\u54c1";
                break;
            }
            case "7": {
                type = "\u533b\u9662";
                break;
            }
            case "8": {
                type = "\u6d77\u5916\u516c\u53f8";
                break;
            }
            case "-1": {
                type = "\u65e0\u6cd5\u5224\u65ad\u4eba\u6216\u516c\u53f8";
                break;
            }
            case "-2": {
                type = "\u5176\u4ed6(\u6ca1\u6709Id\u7684\u4eba)";
                break;
            }
            case "-3": {
                type = "\u5176\u4ed6";
            }
        }
        return type;
    }
}

