/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.qcc.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.wm.cs.trade.common.QCCUtil;
import yem.wm.cs.trade.common.YEM;

public class FinanceTax {
    private static final String ANNUAL_REPORT = "https://api.qichacha.com/AR/GetAnnualReport";
    private static final String TAX_OWE = "https://api.qichacha.com/TaxOweNoticeCheck/GetList";
    private static final String TAX_ILL = "https://api.qichacha.com/TaxIllegalCheck/GetList";

    public static void createFinanceTax(HashMap<String, String> param) {
        DynamicObject financeTax = QCCUtil.setCommonFiled("yem_cs_financetaxinfo", param.get("name"));
        FinanceTax.constructAnnualReport(financeTax, param);
        FinanceTax.constructTaxOwe(financeTax, param);
        FinanceTax.constructTaxIll(financeTax, param);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{financeTax});
    }

    private static void constructTaxIll(DynamicObject financeTax, final HashMap<String, String> param) {
        String flag;
        HashMap<Object, Object> map;
        JSONObject rs;
        String verifyResult;
        HashMap<String, String> req = new HashMap<String, String>(){
            {
                this.put("key", "\u7a0e\u6536\u8fdd\u6cd5\u6838\u67e5APIKEY");
                this.put("keyword", param.get("name"));
            }
        };
        if (param.containsKey("pageIndex")) {
            req.put("pageIndex", param.get("pageIndex"));
        }
        if ("0".equals(verifyResult = (rs = (JSONObject)(map = QCCUtil.getRsData(flag = "TaxIllegalCheck", req, TAX_ILL)).get("rs")).getString("VerifyResult"))) {
            return;
        }
        JSONArray data = (JSONArray)map.get("data");
        DynamicObjectCollection taxIllDc = financeTax.getDynamicObjectCollection("yem_cs_csxx_sswf");
        taxIllDc.clear();
        for (Object datum : data) {
            DynamicObject row = taxIllDc.addNew();
            JSONObject dataObj = (JSONObject)datum;
            row.set("yem_releasedates", (Object)dataObj.getDate("PublishDate"));
            row.set("yem_naturecase", dataObj.get((Object)"CaseNature"));
            row.set("yem_belongsorgan", dataObj.get((Object)"TaxGov"));
            row.set("yem_illegalfacts", dataObj.get((Object)"IllegalContent"));
            row.set("yem_penalties", dataObj.get((Object)"PunishContent"));
        }
        JSONObject page = (JSONObject)map.get("page");
        int totalRecords = page.getIntValue("TotalRecords");
        financeTax.set("yem_taxarrears", (Object)totalRecords);
    }

    private static void constructTaxOwe(DynamicObject financeTax, final HashMap<String, String> param) {
        String flag = "TaxOweNoticeCheck";
        HashMap<String, String> req = new HashMap<String, String>(){
            {
                this.put("key", "\u6b20\u7a0eAPIKEY");
                this.put("keyword", param.get("name"));
            }
        };
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, TAX_OWE);
        JSONObject rs = (JSONObject)map.get("rs");
        String verifyResult = rs.getString("VerifyResult");
        if ("0".equals(verifyResult)) {
            return;
        }
        JSONArray data = rs.getJSONArray("Data");
        DynamicObjectCollection taxOweDc = financeTax.getDynamicObjectCollection("yem_cs_csxx_qsgg");
        taxOweDc.clear();
        for (Object datum : data) {
            DynamicObject row = taxOweDc.addNew();
            JSONObject dataObj = (JSONObject)datum;
            row.set("yem_taxesowed", dataObj.get((Object)"Title"));
            row.set("yem_taxbalance", dataObj.get((Object)"Amount"));
            row.set("yem_balanceowed", dataObj.get((Object)"NewAmount"));
            row.set("yem_releasedate", (Object)dataObj.getDate("PublishDate"));
            row.set("yem_issuedby", dataObj.get((Object)"IssuedBy"));
        }
        JSONObject page = (JSONObject)map.get("page");
        int totalRecords = page.getIntValue("TotalRecords");
        financeTax.set("yem_taxarrears", (Object)totalRecords);
    }

    private static void constructAnnualReport(DynamicObject financeTax, final HashMap<String, String> param) {
        DynamicObjectCollection annualReportDc = financeTax.getDynamicObjectCollection("yem_cs_csxx_qynb");
        annualReportDc.clear();
        HashMap<String, String> req = new HashMap<String, String>(){
            {
                this.put("key", "\u5e74\u62a5APIKEY");
                this.put("keyword", param.get("name"));
            }
        };
        String flag = "AnnualReport";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, ANNUAL_REPORT);
        JSONArray rs = (JSONArray)map.get("rs");
        if (!rs.isEmpty()) {
            JSONObject rsDatum = (JSONObject)rs.get(0);
            financeTax.set("yem_recentyears", (Object)rsDatum.getString("Year"));
            JSONObject assetsData = rsDatum.getJSONObject("AssetsData");
            financeTax.set("yem_recentyearasset", (Object)assetsData.getString("TotalAssets"));
            financeTax.set("yem_recentyearsbusiness", (Object)assetsData.getString("GrossTradingIncome"));
            financeTax.set("yem_recentyearsprofit", (Object)assetsData.getString("TotalProfit"));
            financeTax.set("yem_recentyearsnetprofit", (Object)assetsData.getString("NetProfit"));
            financeTax.set("yem_recentyearsliability", (Object)assetsData.getString("TotalLiabilities"));
        }
        for (Object r : rs) {
            JSONObject jo = (JSONObject)r;
            JSONObject assetsData = jo.getJSONObject("AssetsData");
            DynamicObject row = annualReportDc.addNew();
            financeTax.set("yem_recentyears", (Object)jo.getString("Year"));
            row.set("yem_year", (Object)jo.getString("Year"));
            row.set("yem_totalassets", (Object)YEM.convertStringToNumber(assetsData.getString("TotalAssets")));
            row.set("yem_totalassets", (Object)YEM.convertStringToNumber(assetsData.getString("TotalOwnersEquity")));
            row.set("yem_operatingincome", (Object)YEM.convertStringToNumber(assetsData.getString("GrossTradingIncome")));
            row.set("yem_grossprofit", (Object)YEM.convertStringToNumber(assetsData.getString("TotalProfit")));
            row.set("yem_totalrevenue", (Object)YEM.convertStringToNumber(assetsData.getString("MainBusinessIncome")));
            row.set("yem_netprofit", (Object)YEM.convertStringToNumber(assetsData.getString("NetProfit")));
            row.set("yem_totaltaxpaid", (Object)YEM.convertStringToNumber(assetsData.getString("TotalTaxAmount")));
            row.set("yem_totalliabilities", (Object)YEM.convertStringToNumber(assetsData.getString("TotalLiabilities")));
        }
    }
}

