/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.qcc.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.wm.cs.trade.common.QCCUtil;

public class JudicialInfo {
    private static final String JUDICIAL_AUCTION = "https://api.qichacha.com/JudicialSaleCheck/GetList";
    private static final String SERIOUS_VIOLATION = "https://api.qichacha.com/SeriousIllegalCheck/GetList";
    private static final String SUMPTUARY_CHECK = "https://api.qichacha.com/SumptuaryCheck/GetList";
    private static final String ENFORCEMENT_CHECK = "https://api.qichacha.com/ZhixingCheck/GetList";
    private static final String JUDICIAL_DOCUMENT = "https://api.qichacha.com/JudgmentDocCheck/GetList";

    public static void createFinanceTax(HashMap<String, String> param) {
        DynamicObject judicialInfo = QCCUtil.setCommonFiled("yem_cs_judicialinfo", param.get("name"));
        JudicialInfo.constructJudicialAuction(judicialInfo, param);
        JudicialInfo.constructSeriousViolation(judicialInfo, param);
        JudicialInfo.constructSumptuaryCheck(judicialInfo, param);
        JudicialInfo.constructEnforcement(judicialInfo, param);
        JudicialInfo.constructJudicialDocument(judicialInfo, param);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{judicialInfo});
    }

    private static void constructJudicialDocument(DynamicObject judicialInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u88c1\u5224\u6587\u4e66APIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "JudicialDocument";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, JUDICIAL_DOCUMENT);
        if (!map.containsKey("rs")) {
            return;
        }
        JSONObject page = (JSONObject)map.get("page");
        judicialInfo.set("yem_executor", (Object)page.getIntValue("TotalRecords"));
        DynamicObjectCollection documentCheckDC = judicialInfo.getDynamicObjectCollection("yem_cs_sfxx_cpws");
        documentCheckDC.clear();
        JSONArray data = (JSONArray)map.get("data");
        for (Object datum : data) {
            JSONObject jo = (JSONObject)datum;
            DynamicObject row = documentCheckDC.addNew();
            row.set("yem_documentitle", jo.get((Object)"CaseName"));
            row.set("yem_brief", jo.get((Object)"CaseReason"));
            row.set("yem_casnumber", jo.get((Object)"CaseNo"));
            JSONArray party = jo.getJSONArray("PartyList");
            StringBuilder parties = new StringBuilder();
            for (Object p : party) {
                JSONObject j1 = (JSONObject)p;
                String name = j1.getString("Name");
                parties.append(name).append(" ");
            }
            row.set("yem_party", (Object)parties);
            row.set("yem_caseamt", jo.get((Object)"Amount"));
            row.set("yem_refereeresult", jo.get((Object)"JudgeResult"));
            row.set("yem_publishdate", (Object)jo.getDate("PublishDate"));
            row.set("yem_judgmentdate", (Object)jo.getDate("JudgeDate"));
            row.set("yem_whetherdefendant", (Object)jo.getBooleanValue("IsProsecutor"));
            row.set("yem_casetype", (Object)JudicialInfo.getCaseType(jo.getString("CaseType")));
        }
    }

    private static void constructEnforcement(DynamicObject judicialInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u88ab\u6267\u884c\u4ebaAPIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "Enforcement";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, ENFORCEMENT_CHECK);
        if (!map.containsKey("rs")) {
            return;
        }
        JSONObject page = (JSONObject)map.get("page");
        int totalRecords = page.getIntValue("TotalRecords");
        judicialInfo.set("yem_executor", (Object)totalRecords);
        JSONArray data = (JSONArray)map.get("data");
        DynamicObjectCollection enforcementDc = judicialInfo.getDynamicObjectCollection("yem_cs_sfxx_bzxr");
        enforcementDc.clear();
        BigDecimal amount = BigDecimal.ZERO;
        for (Object datum : data) {
            JSONObject jo = (JSONObject)datum;
            DynamicObject row = enforcementDc.addNew();
            row.set("yem_filingtime", (Object)jo.getDate("Liandate"));
            row.set("yem_casenum", jo.get((Object)"Anno"));
            row.set("yem_executivecourt", jo.get((Object)"ExecuteGov"));
            row.set("yem_executarget", jo.get((Object)"Biaodi"));
            amount = amount.add(BigDecimal.valueOf(jo.getDouble("Biaodi")));
        }
        judicialInfo.set("yem_executorcheck", (Object)amount);
    }

    private static void constructSumptuaryCheck(DynamicObject judicialInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u9650\u5236\u9ad8\u6d88\u8d39APIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "SUMPTUARY_CHECK";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, SUMPTUARY_CHECK);
        if (!map.containsKey("rs")) {
            return;
        }
        JSONArray data = (JSONArray)map.get("data");
        DynamicObjectCollection sumptuaryCheckDc = judicialInfo.getDynamicObjectCollection("yem_cs_csxx_xzgxf");
        sumptuaryCheckDc.clear();
        for (Object datum : data) {
            JSONObject jo = (JSONObject)datum;
            DynamicObject row = sumptuaryCheckDc.addNew();
            row.set("yem_casenumber", jo.get((Object)"CaseNo"));
            row.set("yem_relatedparty", jo.get((Object)"PersonName"));
            row.set("yem_foundationdate", (Object)jo.getDate("JudgeDate"));
            row.set("yem_releasedate", (Object)jo.getDate("PublishDate"));
            row.set("yem_restrainingorder", jo.get((Object)"CompanyName"));
            row.set("yem_applicant", jo.get((Object)"Applicant"));
        }
        JSONObject page = (JSONObject)map.get("page");
        int totalRecords = page.getIntValue("TotalRecords");
        judicialInfo.set("yem_limithigh", (Object)totalRecords);
    }

    private static void constructSeriousViolation(DynamicObject judicialInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u4e25\u91cd\u8fdd\u6cd5\u6838\u67e5APIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "SeriousViolation";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, SERIOUS_VIOLATION);
        if (!map.containsKey("rs")) {
            return;
        }
        JSONArray data = (JSONArray)map.get("data");
        DynamicObjectCollection seriousViolationDc = judicialInfo.getDynamicObjectCollection("yem_cs_csxx_yzwf");
        seriousViolationDc.clear();
        for (Object datum : data) {
            JSONObject jo = (JSONObject)datum;
            DynamicObject row = seriousViolationDc.addNew();
            row.set("yem_type", jo.get((Object)"Type"));
            row.set("yem_reasonlisting", jo.get((Object)"AddReason"));
            row.set("yem_inclusiontime", (Object)jo.getDate("AddDate"));
            row.set("yem_decisionauthority", jo.get((Object)"AddOffice"));
            row.set("yem_removalreason", jo.get((Object)"RemoveReason"));
            row.set("yem_removaldate", jo.get((Object)"RemoveDate"));
            row.set("yem_removalorgan", jo.get((Object)"RemoveOffice"));
        }
        judicialInfo.set("yem_seriousviolation", (Object)data.size());
    }

    private static void constructJudicialAuction(DynamicObject judicialInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u53f8\u6cd5\u62cd\u5356APIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "JudicialAuction";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, JUDICIAL_AUCTION);
        if (!map.containsKey("rs")) {
            return;
        }
        JSONArray data = (JSONArray)map.get("data");
        DynamicObjectCollection judicialAuctionDc = judicialInfo.getDynamicObjectCollection("yem_cs_csxx_sfpm");
        judicialAuctionDc.clear();
        BigDecimal auctionAmount = BigDecimal.ZERO;
        for (Object datum : data) {
            DynamicObject row = judicialAuctionDc.addNew();
            JSONObject jo = (JSONObject)datum;
            row.set("yem_title", (Object)jo.getString("Name"));
            row.set("yem_courtappointment", (Object)jo.getString("Executegov"));
            row.set("yem_auctiontime", (Object)jo.getString("ActionRemark"));
            row.set("yem_startingprice", (Object)jo.getString("YiWu"));
            row.set("yem_valuation", (Object)jo.getString("EvaluationPrice"));
            auctionAmount = auctionAmount.add(new BigDecimal(jo.getString("EvaluationPrice")));
        }
        JSONObject page = (JSONObject)map.get("page");
        judicialInfo.set("yem_auctionamt", (Object)auctionAmount);
        judicialInfo.set("yem_auction", (Object)page.getIntValue("TotalRecords"));
    }

    private static String getCaseType(String key) {
        switch (key) {
            case "zx": {
                return "\u6267\u884c";
            }
            case "zscq": {
                return "\u77e5\u8bc6\u4ea7\u6743";
            }
            case "xz": {
                return "\u884c\u653f";
            }
            case "ms": {
                return "\u6c11\u4e8b";
            }
            case "pc": {
                return "\u8d54\u507f";
            }
            case "xs": {
                return "\u5211\u4e8b";
            }
            case "gx": {
                return "\u7ba1\u8f96\u6848\u4ef6";
            }
            case "qsx": {
                return "\u533a\u9645\u53f8\u6cd5\u534f\u52a9\u6848\u4ef6";
            }
            case "gsx": {
                return "\u56fd\u9645\u53f8\u6cd5\u534f\u52a9\u6848\u4ef6";
            }
            case "zc": {
                return "\u53f8\u6cd5\u5236\u88c1\u6848\u4ef6";
            }
            case "bq": {
                return "\u975e\u8bc9\u4fdd\u5168\u5ba1\u67e5\u6848\u4ef6";
            }
        }
        return "\u5176\u4ed6";
    }
}

