/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cs.trade.qcc.invoke;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.wm.cs.trade.common.QCCUtil;

public class ManagementInfo {
    private static final String ADMINISTRATIVE_DECISION = "https://api.qichacha.com/AdminPenaltyCheck/GetList";
    private static final String ENV_PUNISH = "https://api.qichacha.com/EnvPunishmentCheck/GetList";
    private static final String BANKRUPTCY_CHECK = "https://api.qichacha.com/BankruptcyCheck/GetList";
    private static final String CREDITOR_BREACH = "https://api.qichacha.com/CreditorBreachCheck/GetList";
    private static final String LIQUIDATION = "https://api.qichacha.com/LiquidationCheck/GetDetail";

    public static void createFinanceTax(HashMap<String, String> param) {
        DynamicObject managementInfo = QCCUtil.setCommonFiled("yem_cs_management", param.get("name"));
        ManagementInfo.penaltyDecisionDc(managementInfo, param);
        ManagementInfo.envPunish(managementInfo, param);
        ManagementInfo.bankruptcyCheck(managementInfo, param);
        ManagementInfo.creditorBreach(managementInfo, param);
        ManagementInfo.liquidation(managementInfo, param);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{managementInfo});
    }

    private static void liquidation(DynamicObject managementInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u6e05\u7b97\u6838\u67e5APIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "Liquidation";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, LIQUIDATION);
        if (map.containsKey("rs")) {
            JSONObject data = (JSONObject)map.get("data");
            String leader = data.getString("Leader");
            String member = data.getString("Member");
            managementInfo.set("yem_personcharge", (Object)leader);
            managementInfo.set("yem_member", (Object)member);
        }
    }

    private static void creditorBreach(DynamicObject managementInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u7834\u4ea7\u91cd\u6574APIKEY");
        req.put("keyword", param.get("name"));
        req.put("searchType", "1");
        req.put("pageSize", "20");
        String flag = "CreditorBreach";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, CREDITOR_BREACH);
        if (!map.containsKey("rs")) {
            return;
        }
        DynamicObjectCollection creditorDc = managementInfo.getDynamicObjectCollection("yem_cs_jyxx_zjwy");
        creditorDc.clear();
        JSONArray data = (JSONArray)map.get("data");
        BigDecimal capital = BigDecimal.ZERO;
        BigDecimal interest = BigDecimal.ZERO;
        for (Object datum : data) {
            DynamicObject row = creditorDc.addNew();
            JSONObject jo = (JSONObject)datum;
            row.set("yem_abbreviation", jo.get((Object)"ShortName"));
            row.set("yem_bondtype", jo.get((Object)"BondType"));
            row.set("yem_defaultstatus", jo.get((Object)"Status"));
            row.set("yem_firstdefault", (Object)jo.getDate("FirstBreakDate"));
            row.set("yem_liquidatedsum", (Object)jo.getDoubleValue("TotalAmount"));
            row.set("yem_defaultinterest", (Object)jo.getDoubleValue("TotalInterest"));
            row.set("yem_expirydate", (Object)jo.getDate("EndDate"));
            capital = capital.add(jo.getBigDecimal("TotalAmount"));
            interest = interest.add(jo.getBigDecimal("TotalInterest"));
        }
        managementInfo.set("yem_bonddefault", ((JSONObject)map.get("page")).get((Object)"TotalRecords"));
        managementInfo.set("yem_bondscumulative", (Object)capital);
        managementInfo.set("yem_cumulativedefault", (Object)interest);
    }

    private static void bankruptcyCheck(DynamicObject managementInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u7834\u4ea7\u91cd\u6574APIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "BankruptcyCheck";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, BANKRUPTCY_CHECK);
        if (!map.containsKey("rs")) {
            return;
        }
        DynamicObjectCollection bankruptcyDc = managementInfo.getDynamicObjectCollection("yem_cs_jyxx_pccz");
        bankruptcyDc.clear();
        JSONArray data = (JSONArray)map.get("data");
        for (Object datum : data) {
            DynamicObject row = bankruptcyDc.addNew();
            JSONObject jo = (JSONObject)datum;
            row.set("yem_casenum", jo.get((Object)"CaseNo"));
            row.set("yem_publicdate", (Object)jo.getDate("PublicDate"));
            JSONArray applicantList = jo.getJSONArray("ApplicantList");
            String applicants = applicantList.stream().map(e -> ((JSONObject)e).getString("Name")).collect(Collectors.joining(", "));
            row.set("yem_applicant", (Object)applicants);
            JSONArray respondentList = jo.getJSONArray("RespondentList");
            String respondent = respondentList.stream().map(e -> ((JSONObject)e).getString("Name")).collect(Collectors.joining(", "));
            row.set("yem_respondent", (Object)respondent);
        }
        managementInfo.set("yem_insolreorganiza", ((JSONObject)map.get("page")).get((Object)"TotalRecords"));
    }

    private static void envPunish(DynamicObject managementInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u73af\u5883\u5904\u7f5aAPIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "EnvPunish";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, ENV_PUNISH);
        if (!map.containsKey("rs")) {
            return;
        }
        DynamicObjectCollection envDc = managementInfo.getDynamicObjectCollection("yem_cs_jyxx_hbcf");
        envDc.clear();
        JSONArray data = (JSONArray)map.get("data");
        for (Object datum : data) {
            DynamicObject row = envDc.addNew();
            JSONObject jo = (JSONObject)datum;
            row.set("yem_decisionsymbol", jo.get((Object)"CaseNo"));
            row.set("yem_illegaltype", jo.get((Object)"IllegalType"));
            row.set("yem_penaltyresults", (Object)("\u7f5a\u6b3e\u91d1\u989d" + jo.get((Object)"PunishAmt")));
            row.set("yem_penaltydate", (Object)jo.getDate("PunishDate"));
            row.set("yem_penaltyunit", jo.get((Object)"PunishGov"));
        }
        JSONObject page = (JSONObject)map.get("page");
        managementInfo.set("yem_environmentalpenalty", (Object)page.getIntValue("TotalRecords"));
    }

    private static void penaltyDecisionDc(DynamicObject managementInfo, HashMap<String, String> param) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("key", "\u5904\u7f5a\u51b3\u5b9a\u6587\u4e66APIKEY");
        req.put("keyword", param.get("name"));
        req.put("pageSize", "20");
        String flag = "PenaltyDecision";
        HashMap<Object, Object> map = QCCUtil.getRsData(flag, req, ADMINISTRATIVE_DECISION);
        if (!map.containsKey("rs")) {
            return;
        }
        JSONArray data = (JSONArray)map.get("data");
        DynamicObjectCollection administrativeDc = managementInfo.getDynamicObjectCollection("yem_cs_jyxx_xzcs");
        administrativeDc.clear();
        for (Object datum : data) {
            JSONObject jo = (JSONObject)datum;
            DynamicObject row = administrativeDc.addNew();
            row.set("yem_decisioninstrument", jo.get((Object)"DocNo"));
            row.set("yem_majorviolations", jo.get((Object)"PunishReason"));
            row.set("yem_typepenalty", (Object)"\u884c\u653f\u5904\u7f5a");
            row.set("yem_penalties", jo.get((Object)"PunishResult"));
            row.set("yem_punishmentauthority", jo.get((Object)"PunishOffice"));
            row.set("yem_dateofissue", (Object)jo.getDate("PunishDate"));
        }
        JSONObject page = (JSONObject)map.get("page");
        managementInfo.set("yem_executivepenalty", (Object)page.getIntValue("TotalRecords"));
    }
}

