/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.common.module.calculation.dynamic;

import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.wm.cn.common.module.calculation.utils.CalculationUtil;

public class FormulaTestFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"yem_math", "yem_billno"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        IFormView parentView = view.getParentView();
        if (parentView != null) {
            IDataModel parentModel = parentView.getModel();
            DynamicObject dataEntity = parentModel.getDataEntity(true);
            DynamicObjectCollection entry = dataEntity.getDynamicObjectCollection("yem_cn_gsfa_gspz");
            for (DynamicObject row : entry) {
                int index = model.createNewEntryRow("yem_entryentity");
                model.setValue("yem_dataname", (Object)row.getString("yem_dataname"), index);
            }
            model.setValue("yem_billform", dataEntity.get("yem_billform"));
            model.setValue("yem_formulasettings", dataEntity.getPkValue());
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_billno": {
                this.billnoClick(key);
                break;
            }
            case "yem_math": {
                this.mathClick();
                break;
            }
        }
    }

    private void billnoClick(String key) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject billForm = (DynamicObject)model.getValue("yem_billform");
        if (billForm != null) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)billForm.getString("number"), (boolean)false, (int)0);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
            view.showForm((FormShowParameter)listShowParameter);
        }
    }

    private void mathClick() {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        DynamicObject formula = (DynamicObject)model.getValue("yem_formulasettings");
        DynamicObject billForm = (DynamicObject)model.getValue("yem_billform");
        long billId = (Long)model.getValue("yem_billid");
        if (billForm == null || billId == 0L) {
            view.showTipNotification("\u8bf7\u5148\u9009\u62e9\u5355\u636e\u3002");
            return;
        }
        if (formula != null) {
            String entityKey = billForm.getString("number");
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityKey);
            Map<String, Object> dataMap = CalculationUtil.loadDataMap(formula, bill, true);
            model.deleteEntryData("yem_entryentity");
            for (Map.Entry<String, Object> mapEntry : dataMap.entrySet()) {
                String mapKey = mapEntry.getKey();
                Object mapValue = mapEntry.getValue();
                String fieldValue = CalculationUtil.parseString(mapValue);
                int index = model.createNewEntryRow("yem_entryentity");
                model.setValue("yem_dataname", (Object)mapKey, index);
                model.setValue("yem_datavalue", (Object)fieldValue, index);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId != null) {
            switch (actionId) {
                case "yem_billno": {
                    this.billnoCallBack(returnData);
                    break;
                }
            }
        }
    }

    private void billnoCallBack(Object returnData) {
        ListSelectedRowCollection selectedRows;
        IDataModel model = this.getModel();
        if (returnData instanceof ListSelectedRowCollection && !(selectedRows = (ListSelectedRowCollection)returnData).isEmpty()) {
            ListSelectedRow selectedRow = selectedRows.get(0);
            model.setValue("yem_billno", (Object)selectedRow.getBillNo());
            model.setValue("yem_billid", selectedRow.getPrimaryKeyValue());
        }
    }
}

