/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.common.module.calculation.dynamic;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.plugin.Plugin;
import yem.base.common.utils.BigDecimalUtils;
import yem.wm.cn.common.module.calculation.utils.CalculationUtil;

public class ProfitCalcICompFormPlugin
extends AbstractBillPlugIn
implements Plugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        FormShowParameter showParameter = view.getFormShowParameter();
        Object tplId = showParameter.getCustomParam("tplId");
        long tplPkId = BigDecimalUtils.toBigDecimal((Object)tplId).longValue();
        if (tplPkId > 0L) {
            DynamicObject tplBill = BusinessDataServiceHelper.loadSingleFromCache((Object)tplPkId, (String)"yem_cn_profitcalcset");
            DynamicObject formula = tplBill.getDynamicObject("yem_formulasettings");
            DynamicObject bill = view.getParentView().getModel().getDataEntity(true);
            Map<String, Object> dataMap = CalculationUtil.loadDataMap(formula, bill);
            Object currObj = this.getValue(dataMap, tplBill.getDynamicObject("yem_sourcecurr"));
            Object currBaseObj = this.getValue(dataMap, tplBill.getDynamicObject("yem_sourcecurrbase"));
            long currId = this.parseF7(currObj);
            long currBaseId = this.parseF7(currBaseObj);
            model.setValue("yem_curr", (Object)currId);
            model.setValue("yem_currbase", (Object)currBaseId);
            model.deleteEntryData("yem_entryentity");
            DynamicObjectCollection entry = tplBill.getDynamicObjectCollection("yem_cn_ykyc_mbpz");
            for (DynamicObject row : entry) {
                Object srcAmtObj = this.getValue(dataMap, row.getDynamicObject("yem_sourceamt"));
                Object srcAmtBaseObj = this.getValue(dataMap, row.getDynamicObject("yem_sourceamtbase"));
                Object realAmtObj = this.getValue(dataMap, row.getDynamicObject("yem_realsourceamt"));
                Object realAmtBaseObj = this.getValue(dataMap, row.getDynamicObject("yem_realsourceamtbase"));
                BigDecimal srcAmt = BigDecimalUtils.toBigDecimal((Object)srcAmtObj);
                BigDecimal srcAmtBase = BigDecimalUtils.toBigDecimal((Object)srcAmtBaseObj);
                BigDecimal realAmt = BigDecimalUtils.toBigDecimal((Object)realAmtObj);
                BigDecimal realAmtBase = BigDecimalUtils.toBigDecimal((Object)realAmtBaseObj);
                BigDecimal errorAmt = realAmt.subtract(srcAmt);
                int index = model.createNewEntryRow("yem_entryentity");
                model.setValue("yem_itemname", (Object)row.getString("yem_itemname"), index);
                model.setValue("yem_sourceamt", (Object)srcAmt, index);
                model.setValue("yem_sourceamtbase", (Object)srcAmtBase, index);
                model.setValue("yem_realsourceamt", (Object)realAmt, index);
                model.setValue("yem_realsourceamtbase", (Object)realAmtBase, index);
                model.setValue("yem_erroramt", (Object)errorAmt, index);
            }
        }
    }

    private long parseF7(Object currObj) {
        if (currObj instanceof DynamicObject) {
            DynamicObject dyObj = (DynamicObject)currObj;
            return dyObj.getLong("id");
        }
        if (currObj instanceof Long) {
            return (Long)currObj;
        }
        return BigDecimalUtils.toBigDecimal((Object)currObj).longValue();
    }

    private Object getValue(Map<String, Object> dataMap, DynamicObject source) {
        Object value = null;
        if (source != null) {
            String dataname = source.getString("yem_dataname");
            value = dataMap.get(dataname);
        }
        return value;
    }
}

