/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.common.module.calculation.form;

import java.util.EventObject;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.util.StringUtils;
import kd.sdk.plugin.Plugin;
import yem.base.common.de.meta.utils.MetaPropertyHelper;
import yem.base.common.de.utils.ShowFormUtil;
import yem.base.common.utils.YEM;

public class FormulaSettingsBillPlugin
extends AbstractBillPlugIn
implements Plugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"yem_logic"});
        this.addItemClickListeners(new String[]{"yem_advcontoolbarap"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        ChangeData[] changeSet = e.getChangeSet();
        int rowIndex = changeSet[0].getRowIndex();
        IDataModel model = this.getModel();
        switch (key = e.getProperty().getName()) {
            case "yem_billform": {
                DynamicObjectCollection entry = model.getEntryEntity("yem_cn_gsfa_gspz");
                for (int i = 0; i < entry.size(); ++i) {
                    DynamicObject row = (DynamicObject)entry.get(i);
                    String datasource = row.getString("yem_datasource");
                    if (!"A".equals(datasource)) continue;
                    model.setValue("yem_logic", (Object)"", i);
                    model.setValue("yem_desc", (Object)"", i);
                }
                break;
            }
            case "yem_datasource": {
                model.setValue("yem_logic", (Object)"", rowIndex);
                model.setValue("yem_desc", (Object)"", rowIndex);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "yem_logic": {
                this.logicClick(key);
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "yem_test": {
                this.testClick();
                break;
            }
        }
    }

    private void testClick() {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        DynamicObject billForm = (DynamicObject)model.getValue("yem_billform");
        if (billForm == null) {
            view.showTipNotification("\u8bf7\u5148\u9009\u62e9\u9002\u7528\u5355\u636e\u3002");
            return;
        }
        OperationResult result = view.invokeOperation("save", YEM.getOptionNoMsg());
        if (result.isSuccess()) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setStatus(OperationStatus.EDIT);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setFormId("yem_cn_formulatest");
            view.showForm(showParameter);
        } else {
            view.showTipNotification("\u81ea\u52a8\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + YEM.getOpMsg((OperationResult)result));
        }
    }

    private void logicClick(String key) {
        IFormView view = this.getView();
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("yem_cn_gsfa_gspz");
        String datasource = (String)model.getValue("yem_datasource", rowIndex);
        String logic = (String)model.getValue("yem_logic", rowIndex);
        String desc = (String)model.getValue("yem_desc", rowIndex);
        DynamicObject billForm = MetaPropertyHelper.getAndCheckF7Value((IFormView)view, (String)"yem_billform");
        if (billForm == null) {
            return;
        }
        switch (datasource) {
            case "A": {
                ShowFormUtil.selectField((AbstractFormPlugin)this, (String)key, (String)billForm.getString("number"));
                break;
            }
            case "B": {
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setStatus(OperationStatus.EDIT);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                showParameter.setFormId("yem_cn_formulaedit");
                showParameter.setCustomParam("yem_formula", (Object)logic);
                showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, key));
                view.showForm(showParameter);
                break;
            }
            case "C": {
                ShowFormUtil.editPlugin((AbstractFormPlugin)this, (String)key, (String)logic, (String)desc);
                break;
            }
            case "D": {
                ShowFormUtil.editText((AbstractFormPlugin)this, (String)key, (String)logic);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (actionId != null) {
            switch (actionId) {
                case "yem_logic": {
                    this.logicCallBack(returnData);
                    break;
                }
            }
        }
    }

    private void logicCallBack(Object returnData) {
        String datasource;
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        int rowIndex = model.getEntryCurrentRowIndex("yem_cn_gsfa_gspz");
        switch (datasource = (String)model.getValue("yem_datasource", rowIndex)) {
            case "A": {
                String desc;
                DynamicObject billForm;
                if (!(returnData instanceof String) || (billForm = MetaPropertyHelper.getAndCheckF7Value((IFormView)view, (String)"yem_billform")) == null) break;
                String fieldKey = (String)returnData;
                String entityLangName = MetaPropertyHelper.getEntityLangName((String)billForm.getString("id"), (String)fieldKey);
                model.setValue("yem_logic", (Object)fieldKey, rowIndex);
                String dataName = (String)model.getValue("yem_dataname", rowIndex);
                if (StringUtils.isEmpty((String)dataName)) {
                    model.setValue("yem_dataname", (Object)entityLangName, rowIndex);
                }
                if (!StringUtils.isEmpty((String)(desc = (String)model.getValue("yem_desc", rowIndex)))) break;
                model.setValue("yem_desc", (Object)entityLangName, rowIndex);
                break;
            }
            case "B": {
                if (!(returnData instanceof DynamicObject)) break;
                DynamicObject data = (DynamicObject)returnData;
                model.setValue("yem_logic", data.get("yem_formula"), rowIndex);
                break;
            }
            case "C": {
                if (!(returnData instanceof DynamicObject)) break;
                DynamicObject data = (DynamicObject)returnData;
                model.setValue("yem_logic", data.get("yem_plugin"), rowIndex);
                model.setValue("yem_desc", data.get("yem_desc"), rowIndex);
                break;
            }
            case "D": {
                if (!(returnData instanceof String)) break;
                model.setValue("yem_logic", returnData, rowIndex);
                break;
            }
        }
    }
}

