/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.common.module.calculation.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import yem.base.common.de.code.utils.NashornScript;
import yem.base.common.de.service.ServiceFactory;
import yem.base.common.utils.BigDecimalUtils;
import yem.base.common.utils.YEM;
import yem.wm.cn.sdk.pluginconfig.ICalculationService;

public class CalculationUtil {
    private static final Log log = LogFactory.getLog(CalculationUtil.class);

    public static Map<String, Object> loadDataMap(DynamicObject formula, DynamicObject bill) {
        return CalculationUtil.loadDataMap(formula, bill, false);
    }

    public static Map<String, Object> loadDataMap(DynamicObject formula, DynamicObject bill, boolean throwError) {
        LinkedHashMap<String, Object> dataMap = new LinkedHashMap<String, Object>();
        if (formula != null && bill != null) {
            formula = BusinessDataServiceHelper.loadSingle((Object)formula.getPkValue(), (String)formula.getDynamicObjectType().getName());
            DynamicObjectCollection configEntry = formula.getDynamicObjectCollection("yem_cn_gsfa_gspz");
            for (DynamicObject row : configEntry) {
                String key = row.getString("yem_dataname");
                String datasource = row.getString("yem_datasource");
                String logic = row.getString("yem_logic");
                String sumType = row.getString("yem_sumtype");
                Object value = null;
                switch (datasource) {
                    case "A": {
                        if (!StringUtils.isNotEmpty((String)logic)) break;
                        value = CalculationUtil.getFieldValue(logic, bill, sumType);
                        break;
                    }
                    case "B": {
                        for (Map.Entry mapEntry : dataMap.entrySet()) {
                            String mapKey = (String)mapEntry.getKey();
                            Object mapValue = mapEntry.getValue();
                            String fieldValue = CalculationUtil.parseString(mapValue);
                            logic = logic.replace("{" + mapKey + "}", fieldValue);
                        }
                        value = CalculationUtil.scriptEngineEval(logic, throwError);
                        break;
                    }
                    case "C": {
                        if (!StringUtils.isNotEmpty((String)logic)) break;
                        try {
                            ICalculationService service = (ICalculationService)ServiceFactory.getService((String)logic);
                            value = service.getValue(bill);
                            break;
                        }
                        catch (Exception e) {
                            log.error("ICalculationService Error", (Throwable)e);
                            if (!throwError) break;
                            throw new RuntimeException("ICalculationService Error", e);
                        }
                    }
                    case "D": {
                        value = logic;
                        break;
                    }
                }
                dataMap.put(key, value);
            }
        }
        return dataMap;
    }

    public static Object scriptEngineEval(String logic) {
        return CalculationUtil.scriptEngineEval(logic, false);
    }

    public static Object scriptEngineEval(String logic, boolean throwError) {
        Object resultObj;
        block2: {
            ScriptEngine engine = NashornScript.getEngineAll();
            resultObj = null;
            try {
                resultObj = engine.eval(logic);
            }
            catch (Exception e) {
                log.error("ScriptEngineEval Error", (Throwable)e);
                if (!throwError) break block2;
                throw new RuntimeException("ScriptEngineEval Error", e);
            }
        }
        return resultObj;
    }

    public static Object getFieldValue(String fullNumber, DynamicObject bill, String sumType) {
        List<Object> values = CalculationUtil.getFieldValue(fullNumber, bill);
        if (!values.isEmpty()) {
            Object firstValue = values.get(0);
            if (YEM.isNotEmpty((Object)sumType) && !"0".equals(sumType)) {
                BigDecimal sum = BigDecimal.ZERO;
                BigDecimal max = BigDecimal.ZERO;
                BigDecimal min = null;
                for (Object value : values) {
                    BigDecimal decimal = BigDecimalUtils.toBigDecimal((Object)value);
                    sum = sum.add(decimal);
                    if (decimal.compareTo(max) > 0) {
                        max = decimal;
                    }
                    if (min == null) {
                        min = decimal;
                        continue;
                    }
                    if (decimal.compareTo(min) >= 0) continue;
                    min = decimal;
                }
                switch (sumType) {
                    case "1": {
                        return sum;
                    }
                    case "2": {
                        return BigDecimalUtils.div((Object)sum, (Object)values.size(), (int)10);
                    }
                    case "3": {
                        return values.size();
                    }
                    case "4": {
                        return max;
                    }
                    case "5": {
                        return min;
                    }
                }
                return firstValue;
            }
            return firstValue;
        }
        return null;
    }

    public static List<Object> getFieldValue(String fullNumber, DynamicObject bill) {
        ArrayList<Object> values = new ArrayList<Object>();
        Object value = null;
        String[] fields = fullNumber.split("\\.");
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (i == 0) {
                value = bill.get(field);
                continue;
            }
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).get(field);
                continue;
            }
            if (!(value instanceof DynamicObjectCollection)) continue;
            DynamicObjectCollection dyObjs = (DynamicObjectCollection)value;
            if (dyObjs.isEmpty()) {
                return values;
            }
            ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fields).subList(i, fields.length));
            String number = String.join((CharSequence)".", fieldList);
            for (DynamicObject dyObj : dyObjs) {
                if (fieldList.isEmpty()) {
                    values.add(dyObj);
                    continue;
                }
                values.addAll(CalculationUtil.getFieldValue(number, dyObj));
            }
            return values;
        }
        values.add(value);
        return values;
    }

    public static String parseString(Object mapValue) {
        String fieldValue = mapValue instanceof BigDecimal ? ((BigDecimal)mapValue).toPlainString() : mapValue + "";
        return fieldValue;
    }
}

