/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.cn.common.module.contracttpl.opplugin.validator;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class PayEntrySubmitValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedData : this.getDataEntities()) {
            this.totalRate(extendedData);
        }
    }

    private void totalRate(ExtendedDataEntity extendedData) {
        DynamicObject dataEntity = extendedData.getDataEntity();
        DynamicObjectCollection entryRows = dataEntity.getDynamicObjectCollection("yem_cng_paycollplan");
        if (entryRows.size() > 0) {
            BigDecimal rapamt;
            BigDecimal raprate = entryRows.stream().map(x -> x.getBigDecimal("yem_raprate")).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (raprate.compareTo(new BigDecimal(100)) != 0) {
                this.addMessage(extendedData, String.format("{%s}\u767e\u5206\u6bd4\u4e4b\u548c\u5fc5\u987b\u4e3a100", entryRows.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN()));
            }
            if ((rapamt = entryRows.stream().map(x -> x.getBigDecimal("yem_rapamt")).reduce(BigDecimal.ZERO, BigDecimal::add)).compareTo(dataEntity.getBigDecimal("yem_amounttax")) != 0) {
                this.addMessage(extendedData, String.format("{%s}\u6536\u4ed8\u6b3e\u91d1\u989d\u5408\u8ba1\u4e0d\u7b49\u4e8e\u5408\u540c\u603b\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u3002", entryRows.getDynamicObjectType().getDisplayName().getLocaleValue_zh_CN()));
            }
        }
    }
}

