/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.change.dynamic;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import yem.wm.base.com.change.common.enums.EnableStatusEnum;
import yem.wm.base.com.change.utils.ChangsUtils;

public class ChangeConvertopEditPlugin
extends AbstractFormPlugin
implements ClickListener {
    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.fillBillCombo();
        this.fillRuleCombo();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if (e.getProperty().getName().equalsIgnoreCase("yem_fbill")) {
            this.fillRuleCombo();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control srcCtrl = (Control)evt.getSource();
        if ("btnok".equalsIgnoreCase(srcCtrl.getKey())) {
            Object creditno = this.getModel().getValue("yem_frule");
            this.getView().returnDataToParent(creditno);
            this.getView().close();
        }
    }

    private void fillBillCombo() {
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object srcbill = showParameter.getCustomParam("srcbill");
        if (srcbill != null) {
            QFilter qf1 = new QFilter("srcbill", "=", srcbill);
            QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"yem_changemodel", (QFilter[])new QFilter[]{qf1, qf2});
            if (!ChangsUtils.isNull(map)) {
                ArrayList changemodellist = new ArrayList(map.values());
                ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>();
                ArrayList<String> xbillLsit = new ArrayList<String>();
                for (DynamicObject changeModel : changemodellist) {
                    DynamicObject xbill = changeModel.getDynamicObject("xbill");
                    if (xbillLsit.contains(xbill.getString("number"))) continue;
                    ComboItem ruleItem = new ComboItem();
                    ruleItem.setValue(xbill.getString("number"));
                    ruleItem.setCaption(new LocaleString(xbill.getString("name")));
                    ruleItems.add(ruleItem);
                    xbillLsit.add(xbill.getString("number"));
                }
                ComboEdit billEditor = (ComboEdit)this.getView().getControl("yem_fbill");
                billEditor.setComboItems(ruleItems);
                if (ruleItems.size() != 0) {
                    this.getModel().setValue("yem_fbill", (Object)((ComboItem)ruleItems.get(0)).getValue());
                }
            }
        }
    }

    private void fillRuleCombo() {
        String xbill = this.getModel().getDataEntity().getString("yem_fbill");
        if (!ChangsUtils.isNull(xbill)) {
            QFilter qf1 = new QFilter("xbill", "=", (Object)xbill);
            QFilter qf2 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
            Map map = BusinessDataServiceHelper.loadFromCache((String)"yem_changemodel", (QFilter[])new QFilter[]{qf1, qf2});
            if (!ChangsUtils.isNull(map)) {
                ArrayList changemodellist = new ArrayList(map.values());
                ArrayList<ComboItem> ruleItems = new ArrayList<ComboItem>();
                for (DynamicObject changeModel : changemodellist) {
                    ComboItem ruleItem = new ComboItem();
                    ruleItem.setValue(changeModel.getPkValue().toString());
                    ruleItem.setCaption(new LocaleString(changeModel.getString("name")));
                    ruleItems.add(ruleItem);
                }
                ComboEdit billEditor = (ComboEdit)this.getView().getControl("yem_frule");
                billEditor.setComboItems(ruleItems);
                if (ruleItems.size() != 0) {
                    this.getModel().setValue("yem_frule", (Object)((ComboItem)ruleItems.get(0)).getValue());
                }
            }
        }
    }
}

