/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.change.dynamic;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import yem.wm.base.com.change.business.ChangeModelHelper;
import yem.wm.base.com.change.business.ChangeResumeLogHelper;
import yem.wm.base.com.change.utils.ChangsUtils;

public class ChangeResumeFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object srcbillId = showParameter.getCustomParam("srcbillid");
        Object xbillid = showParameter.getCustomParam("xbillid");
        this.getView().setEnable(Boolean.valueOf(false), new String[]{"billinfo"});
        if (!ChangsUtils.isNull(srcbillId)) {
            QFilter qFilter3 = new QFilter("srcbillid", "=", srcbillId);
            QFilter qFilter2 = new QFilter("currentchangenumber", "!=", (Object)0);
            DynamicObjectCollection num = QueryServiceHelper.query((String)"yem_changeresume", (String)"currentchangenumber", (QFilter[])new QFilter[]{qFilter3, qFilter2}, (String)"currentchangenumber");
            int currentchangenumber = num.size();
            this.getModel().setValue("currentchangenumber", (Object)currentchangenumber);
            this.getView().updateView("currentchangenumber");
            ListShowParameter showParameterMenu = new ListShowParameter();
            showParameterMenu.getOpenStyle().setShowType(ShowType.InContainer);
            showParameterMenu.getOpenStyle().setTargetKey("changerecord");
            showParameterMenu.setBillFormId("yem_changeresume");
            showParameterMenu.setStatus(OperationStatus.VIEW);
            showParameterMenu.setCustomParam("srcbillid", srcbillId);
            if (!ChangsUtils.isNull(xbillid)) {
                showParameterMenu.setCustomParam("xbillid", xbillid);
            }
            this.getPageCache().put("childpageid", showParameterMenu.getPageId());
            this.getView().showForm((FormShowParameter)showParameterMenu);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if ("refresh".equals(operate.getOperateKey())) {
            this.getView().updateView();
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        String srcbillno = (String)showParameter.getCustomParam("srcbillno");
        if (!ChangsUtils.isNull(srcbillno)) {
            this.getModel().setValue("srcbillno", (Object)srcbillno);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        Object newValue = changeData.getNewValue();
        if (name.equals("vnum")) {
            this.getView().getPageCache().put("vnum", String.valueOf(newValue));
            this.getView().getFormShowParameter().setCustomParam("vnum", (Object)String.valueOf(newValue));
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"highlight"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey().toLowerCase();
        if (key.equals("highlight")) {
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            FormShowParameter showParameter = view.getFormShowParameter();
            String vnum = (String)model.getValue("vnum");
            if (vnum == null || vnum.isEmpty()) {
                view.showTipNotification("\u8bf7\u9009\u62e9\u8981\u6bd4\u8f83\u7684\u7248\u672c\u3002");
                return;
            }
            DynamicObject srcBill = null;
            String childPageId = this.getPageCache().get("childpageid");
            IFormView childView = this.getView().getView(childPageId);
            BillList billList = (BillList)childView.getControl("billlistap");
            ListSelectedRow row = billList.getCurrentSelectedRowInfo();
            Long selectId = (Long)row.getPrimaryKeyValue();
            DynamicObject changeresume = BusinessDataServiceHelper.loadSingle((Object)selectId, (String)"yem_changeresume");
            if (changeresume == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u7248\u672c\u4fe1\u606f\u5f02\u5e38\u3002", (String)"ChangeResumeFromPlugin_0", (String)"yem-yc-changemodel", (Object[])new Object[0]));
                return;
            }
            String billentity = (String)changeresume.get("xbillentity");
            long billID = (Long)changeresume.get("xbillid");
            DynamicObject xBill = BusinessDataServiceHelper.loadSingle((Object)billID, (String)billentity);
            ListSelectedRowCollection AllRowCol = billList.getCurrentListAllRowCollection();
            for (ListSelectedRow rowNex : AllRowCol) {
                Long selectIdNex = (Long)rowNex.getPrimaryKeyValue();
                DynamicObject changeresumeNex = BusinessDataServiceHelper.loadSingle((Object)selectIdNex, (String)"yem_changeresume");
                if (changeresumeNex == null) continue;
                long billIDNex = (Long)changeresumeNex.get("xbillid");
                String billentityNex = (String)changeresumeNex.get("xbillentity");
                int changenumber = (Integer)changeresumeNex.get("currentchangenumber");
                String version = changeresumeNex.getString("srcbillversion");
                if (0 != changenumber) {
                    version = changeresumeNex.getString("srcbillversion");
                }
                if (!vnum.equals(version)) continue;
                srcBill = BusinessDataServiceHelper.loadSingle((Object)billIDNex, (String)billentityNex);
            }
            if (xBill != null && srcBill != null) {
                ArrayList<DynamicObject> ChangeModeList;
                DynamicObject changeModel = xBill.getDynamicObject("yem_changemodel");
                if (changeModel == null && (ChangeModeList = ChangeModelHelper.getChangeModelListXBill(billentity)) != null) {
                    changeModel = ChangeModeList.get(0);
                }
                changeModel = BusinessDataServiceHelper.loadSingleFromCache((Object)changeModel.getPkValue(), (String)changeModel.getDynamicObjectType().getName());
                String crdheadjson = ChangeResumeLogHelper.getBilljson(srcBill, xBill, changeModel);
                String crdentryjson = ChangeResumeLogHelper.getBillEntryjson(srcBill, xBill, changeModel, ChangeModelHelper.getXBillEntryAndOp(changeModel));
                HashMap<String, Object> customParams = new HashMap<String, Object>();
                customParams.put("crdheadjson", crdheadjson);
                customParams.put("crdentryjson", crdentryjson);
                this.showBillinfo(billID, billentity, customParams);
            }
        }
    }

    public void showBillinfo(long billID, String billentity, Map<String, Object> customParams) {
        IFormView View = this.getView();
        if (!ChangsUtils.isNull(billentity) && billID != 0L) {
            QFilter qf1 = new QFilter("xbillid", "=", (Object)billID);
            boolean changeReCord = QueryServiceHelper.exists((String)"yem_changeresume", (QFilter[])new QFilter[]{qf1});
            if (changeReCord) {
                View.setVisible(Boolean.valueOf(true), new String[]{"billinfo"});
                BillShowParameter showParameter = new BillShowParameter();
                customParams.put("InContainer", "InContainer");
                showParameter.setCustomParams(customParams);
                showParameter.getOpenStyle().setShowType(ShowType.InContainer);
                showParameter.getOpenStyle().setTargetKey("billinfo");
                showParameter.setFormId(billentity);
                showParameter.setPkId((Object)billID);
                showParameter.setBillStatus(BillOperationStatus.VIEW);
                View.showForm((FormShowParameter)showParameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"ChangeResumeListPlugin_0", (String)"yem-yc-changemodel", (Object[])new Object[0]));
                View.setVisible(Boolean.valueOf(false), new String[]{"billinfo"});
            }
        } else {
            View.setVisible(Boolean.valueOf(false), new String[]{"billinfo"});
        }
    }
}

