/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.change.op;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import yem.base.common.utils.DynamicObjUtils;
import yem.base.common.utils.StringUtils;
import yem.base.common.utils.YEM;
import yem.wm.base.com.change.business.ChangeModelHelper;
import yem.wm.base.com.change.common.consts.ChangeResumeFormConst;
import yem.wm.base.com.change.common.enums.BizChangeStatusEnum;
import yem.wm.base.com.change.common.enums.StatusEnum;
import yem.wm.base.com.change.op.SrcBillBizChangeOpValidator;
import yem.wm.base.com.change.utils.ChangsUtils;

public class SrcBillBizChangeOpPlugin
extends AbstractOperationServicePlugIn {
    public static Log logger = LogFactory.getLog(SrcBillBizChangeOpPlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new SrcBillBizChangeOpValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("yem_changstate");
        e.getFieldKeys().add("yem_changemodel");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills = e.getDataEntities();
            String changemodeid = this.getOption().getVariableValue("changemode", null);
            DynamicObject changeModel = null;
            if (!ChangsUtils.isNull(changemodeid)) {
                changeModel = ChangeModelHelper.getChangeModel(changemodeid);
            }
            if (changeModel == null) {
                return;
            }
            for (DynamicObject bill : bills) {
                ChangeModelHelper.excutePluginMethod(changeModel, "beforeSrcBillChange", bill);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        OperateOption Option = OperateOption.create();
        Option.setVariableValue("updateModifyDate", String.valueOf(false));
        if ("bizchange".equals(e.getOperationKey()) && e.getDataEntities() != null && e.getDataEntities().length != 0) {
            QFilter qf1;
            Map map;
            DynamicObject[] bills = e.getDataEntities();
            logger.info("bills.length : " + bills.length);
            long beginTime = System.currentTimeMillis();
            logger.info("bizchange begin :" + new Date(beginTime));
            String changemodeid = this.getOption().getVariableValue("changemode", null);
            DynamicObject changeModel = null;
            if (!ChangsUtils.isNull(changemodeid) && !ChangsUtils.isNull(map = BusinessDataServiceHelper.loadFromCache((String)"yem_changemodel", (QFilter[])new QFilter[]{qf1 = new QFilter("id", "=", (Object)Long.valueOf(changemodeid))}))) {
                ArrayList list = new ArrayList(map.values());
                changeModel = (DynamicObject)list.get(0);
            }
            DynamicObject[] xBills = ChangeModelHelper.generateXBilll(bills, changeModel);
            String xBillEntityID = "";
            if (!ChangsUtils.isNull(xBills) && !ChangsUtils.isNull(changeModel)) {
                xBillEntityID = xBills[0].getDataEntityType().getName();
                for (DynamicObject dynamicObject : bills) {
                    dynamicObject.set("yem_changstate", (Object)BizChangeStatusEnum.CHANGING.getValue());
                }
                for (DynamicObject dynamicObject : xBills) {
                    dynamicObject.set("yem_changemodel", (Object)changeModel);
                }
                SaveServiceHelper.save((DynamicObject[])xBills);
                SaveServiceHelper.update((DynamicObject[])bills, (OperateOption)Option);
                for (DynamicObject dynamicObject : xBills) {
                    long sourceBillId = dynamicObject.getLong("yem_xsourcebillid");
                    DynamicObject srcBill = BusinessDataServiceHelper.loadSingleFromCache((Object)sourceBillId, (String)bills[0].getDataEntityType().getName());
                    String enableChangeResume = this.getOption().getVariableValue(ChangeResumeFormConst.ENABLE_CHANGERESUME, "true");
                    boolean isExistsZero = QueryServiceHelper.exists((String)"yem_changeresume", (QFilter[])new QFilter[]{new QFilter("srcbillid", "=", (Object)sourceBillId), new QFilter("currentchangenumber", "=", (Object)0)});
                    ChangeModelHelper.excutePluginMethod(changeModel, "afterSrcBillChange", dynamicObject);
                    if (changeModel == null || !"true".equalsIgnoreCase(enableChangeResume) || srcBill == null || isExistsZero || !"1".equals(srcBill.getString("yem_version")) || !"1".equals(srcBill.getString("yem_subversion"))) continue;
                    DynamicObject zeroXBill = (DynamicObject)new CloneUtils(false, true).clone(dynamicObject.getDataEntityType(), (Object)dynamicObject);
                    zeroXBill.set("yem_changstate", (Object)"D");
                    zeroXBill.set("yem_changebillno", (Object)(srcBill.getString("billno") + "_0"));
                    Object[] inDBZeroXBill = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{zeroXBill});
                    if (inDBZeroXBill == null || inDBZeroXBill.length <= 0 || inDBZeroXBill[0] == null) continue;
                    DynamicObject zeroXBillDO = (DynamicObject)inDBZeroXBill[0];
                    MainEntityType changeResumeET = MetadataServiceHelper.getDataEntityType((String)"yem_changeresume");
                    DynamicObject changeResumeDO = new DynamicObject((DynamicObjectType)changeResumeET);
                    changeResumeDO.set("xbillid", zeroXBillDO.getPkValue());
                    changeResumeDO.set("xbillno", (Object)zeroXBillDO.getString("yem_changebillno"));
                    changeResumeDO.set("xvalidstatus", (Object)zeroXBillDO.getString("yem_activestatus"));
                    changeResumeDO.set("xbillentity", (Object)dynamicObject.getDataEntityType().getName());
                    changeResumeDO.set("xbiztime", (Object)dynamicObject.getDate("yem_changebizdate"));
                    DynamicObject creator = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
                    changeResumeDO.set("xcreator", (Object)creator);
                    changeResumeDO.set("srcbillid", (Object)sourceBillId);
                    changeResumeDO.set("srcbillentity", (Object)srcBill.getDataEntityType().getName());
                    changeResumeDO.set("srcbillno", (Object)srcBill.getString("billno"));
                    changeResumeDO.set("srcbillversion", (Object)0);
                    changeResumeDO.set("srcbillsubversion", (Object)0);
                    changeResumeDO.set("changemodel", changeModel.getPkValue());
                    changeResumeDO.set("currentchangenumber", (Object)0);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{changeResumeDO});
                }
                this.getOperationResult().setSuccess(true);
                long endTime = System.currentTimeMillis();
                logger.info("bizchange end :" + new Date(endTime));
                logger.info("bizchange usetime(ms): " + (endTime - beginTime));
                this.getOption().setVariableValue("changemodel", changeModel != null ? changeModel.getPkValue().toString() : "");
                this.getOption().setVariableValue("xBillEntityID", xBillEntityID);
            }
            for (DynamicObject dynamicObject : bills) {
                ChangeModelHelper.excutePluginMethod(changeModel, "afterSrcBillChange", dynamicObject);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        this.attachment(bills);
    }

    public void attachment(DynamicObject[] Bills) {
        String xBillEntityID = this.getOption().getVariableValue("xBillEntityID");
        for (DynamicObject bill : Bills) {
            DynamicObject yem_changemodel;
            QFilter q3;
            QFilter q2;
            long id = bill.getLong("id");
            QFilter q1 = new QFilter("yem_xsourcebillid", "=", (Object)id);
            DynamicObject xbill = BusinessDataServiceHelper.loadSingleFromCache((String)xBillEntityID, (QFilter[])new QFilter[]{q1, q2 = new QFilter("billstatus", "=", (Object)StatusEnum.SAVE.getValue()), q3 = new QFilter("yem_changstate", "!=", (Object)"D")});
            if (xbill == null || (yem_changemodel = xbill.getDynamicObject("yem_changemodel")) == null || !yem_changemodel.getBoolean("yem_setattachment")) continue;
            bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
            xbill = BusinessDataServiceHelper.loadSingle((Object)xbill.getPkValue(), (String)xbill.getDynamicObjectType().getName());
            SrcBillBizChangeOpPlugin.uploadAttachmentPanel(bill, xbill);
        }
    }

    public static void uploadAttachmentPanel(DynamicObject from, DynamicObject to) {
        DynamicObjectCollection yem_attachmentpanelentityColfrom = from.getDynamicObjectCollection("yem_attachmentinfo_e");
        DynamicObjectCollection yem_attachmentpanelentityColto = to.getDynamicObjectCollection("yem_attachmentinfo_e");
        yem_attachmentpanelentityColto.clear();
        List attachments = AttachmentServiceHelper.getAttachmentsByExport((String)from.getDataEntityType().getName(), (Object)from.getLong("id"));
        List toattachments = AttachmentServiceHelper.getAttachmentsByExport((String)to.getDynamicObjectType().getName(), (Object)to.getLong("id"));
        List toname = toattachments.stream().map(x -> (String)x.get("name")).collect(Collectors.toList());
        for (Map map : attachments) {
            String uid = (String)map.get("uid");
            String fileName = (String)map.get("name");
            if (fileName == null || toname.contains(fileName)) continue;
            DynamicObject newAtt = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            Long id = ORM.create().genLongId("bos_attachment");
            newAtt.set("id", (Object)id);
            newAtt.set("fnumber", (Object)("upload_" + id));
            newAtt.set("FBillType", (Object)to.getDataEntityType().getName());
            newAtt.set("FInterID", (Object)to.getString("id"));
            newAtt.set("FModifyTime", map.get("lastModified"));
            newAtt.set("fcreatetime", map.get("createdate"));
            newAtt.set("FaliasFileName", (Object)fileName);
            newAtt.set("FAttachmentName", (Object)fileName);
            newAtt.set("FFileId", map.get("url"));
            newAtt.set("FExtName", map.get("type"));
            newAtt.set("FATTACHMENTSIZE", map.get("size"));
            newAtt.set("fattachmentpanel", map.get("fattachmentpanel"));
            newAtt.set("fdescription", map.get("description"));
            DynamicObject attach = yem_attachmentpanelentityColto.addNew();
            DynamicObject yem_attacheduser = null;
            for (DynamicObject yem_attachmentpanelentityfrom : yem_attachmentpanelentityColfrom) {
                String yem_attachedid = yem_attachmentpanelentityfrom.getString("yem_attachedid");
                if (StringUtils.isEmpty((String)yem_attachedid) || !yem_attachedid.equals(uid) && !fileName.equals(yem_attachmentpanelentityfrom.getString("yem_attachmentname"))) continue;
                yem_attacheduser = yem_attachmentpanelentityfrom.getDynamicObject("yem_attacheduser");
                attach.set("yem_attachedid", newAtt.get("fnumber"));
                attach.set("yem_atturl", (Object)yem_attachmentpanelentityfrom.getString("yem_atturl"));
                attach.set("yem_attachmentname", (Object)yem_attachmentpanelentityfrom.getLocaleString("yem_attachmentname"));
                attach.set("yem_attachmenttype", (Object)yem_attachmentpanelentityfrom.getDynamicObject("yem_attachmenttype"));
                attach.set("yem_uploaddate", (Object)yem_attachmentpanelentityfrom.getDate("yem_uploaddate"));
                attach.set("yem_attacheduser", (Object)yem_attachmentpanelentityfrom.getDynamicObject("yem_attacheduser"));
                attach.set("yem_panel", (Object)yem_attachmentpanelentityfrom.getString("yem_panel"));
                attach.set("yem_docid", (Object)yem_attachmentpanelentityfrom.getString("yem_docid"));
                attach.set("yem_docname", (Object)yem_attachmentpanelentityfrom.getString("yem_docname"));
                attach.set("yem_billno", (Object)yem_attachmentpanelentityfrom.getString("yem_billno"));
                attach.set("yem_billid", (Object)yem_attachmentpanelentityfrom.getString("yem_billid"));
            }
            String creatorName = map.get("creator") != null ? map.get("creator").toString() : (yem_attacheduser != null ? yem_attacheduser.getString("name") : "");
            DynamicObject User = YEM.getCurrentUser((String)creatorName);
            if (User != null) {
                newAtt.set("FCREATEMEN", (Object)User.getString("id"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAtt});
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("yem_attachmentinfo_e", "");
            DynamicObjUtils.resetSeq((DynamicObject)to, map1);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{to});
        }
    }
}

