/*
 * Decompiled with CFR 0.152.
 */
package yem.wm.base.com.change.op;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.validation.ConditionValidation;
import kd.bos.orm.ORM;
import kd.bos.service.operation.validate.ConditionValidator;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import yem.base.common.utils.DynamicObjUtils;
import yem.base.common.utils.StringUtils;
import yem.base.common.utils.YEM;
import yem.wm.base.com.change.business.ChangeModelHelper;
import yem.wm.base.com.change.utils.ChangsUtils;

public class XBillBizValidOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log LOGGER = LogFactory.getLog(XBillBizValidOpPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("yem_sourcebillentity");
        e.getFieldKeys().add("yem_xsourcebillid");
        e.getFieldKeys().add("xvalidstatus");
        e.getFieldKeys().add("yem_changemodel");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        if (this.billEntityType != null) {
            String opkey = (String)this.operateMeta.get("key");
            DynamicObject[] bills = e.getDataEntities();
            ArrayList<DynamicObject> ChangeModellist = ChangeModelHelper.getChangeModelListXBill(this.billEntityType.getName());
            if (ChangeModellist != null) {
                for (DynamicObject changeModel : ChangeModellist) {
                    List<ConditionValidation> vallist = ChangeModelHelper.getValidConditionList(opkey, changeModel);
                    if (vallist == null || vallist.size() <= 0) continue;
                    for (ConditionValidation conditionValidation : vallist) {
                        ConditionValidator XBillBizValidCV = new ConditionValidator();
                        XBillBizValidCV.setValidation(conditionValidation.createValidate());
                        e.addValidator((AbstractValidator)XBillBizValidCV);
                    }
                }
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        if (e.getDataEntities() != null && e.getDataEntities().length != 0) {
            DynamicObject[] bills;
            for (DynamicObject bill : bills = e.getDataEntities()) {
                DynamicObject changeModel = bill.getDynamicObject("yem_changemodel");
                if (changeModel == null) continue;
                ChangeModelHelper.excutePluginMethod(changeModel, "beforeXBillBizValid", bill);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void endOperationTransaction(EndOperationTransactionArgs e) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[UNCONDITIONALDOLOOP]], but top level block is 33[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if ("bizvalid".equals(e.getOperationKey()) && !ChangsUtils.isNull(e.getDataEntities())) {
            DynamicObject[] bills;
            long beginTime = System.currentTimeMillis();
            LOGGER.info("BizValidPerformance--BeginTime: " + new Date(beginTime));
            DynamicObject[] dynamicObjectArray = bills = e.getDataEntities();
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dynamicObject;
                DynamicObject bill = dynamicObject = dynamicObjectArray[i];
                bill = BusinessDataServiceHelper.loadSingle((Object)bill.getPkValue(), (String)bill.getDynamicObjectType().getName());
                DynamicObject changeModel = bill.getDynamicObject("yem_changemodel");
                ChangeModelHelper.excutePluginMethod(changeModel, "afterExecuteXBillBizValid", bill);
                this.attachment(bill);
            }
        }
    }

    protected Map<String, Map<String, String>> getXBillEntryAndField(DynamicObject changeModel) {
        Map<String, Map<String, String>> result = ChangeModelHelper.getXBillEntryAndOp(changeModel);
        if (result.size() != 0) {
            return result;
        }
        HashMap<String, String> value = new HashMap<String, String>();
        value.put("entity", "billentry");
        value.put("changetype", "billentrychangetype");
        value.put("srcid", "billentrysrcid");
        result.put((String)value.get("entity"), (Map<String, String>)value);
        return result;
    }

    public void attachment(DynamicObject xBill) {
        DynamicObject yem_changemodel = xBill.getDynamicObject("yem_changemodel");
        if (yem_changemodel != null && (yem_changemodel = BusinessDataServiceHelper.loadSingle((Object)yem_changemodel.getPkValue(), (String)yem_changemodel.getDynamicObjectType().getName())).getBoolean("yem_backsetattachment")) {
            DynamicObject Sbill = BusinessDataServiceHelper.loadSingle((Object)xBill.getLong("yem_xsourcebillid"), (String)xBill.getString("yem_sourcebillentity"));
            xBill = BusinessDataServiceHelper.loadSingle((Object)xBill.getPkValue(), (String)xBill.getDynamicObjectType().getName());
            XBillBizValidOpPlugin.uploadAttachmentPanel(xBill, Sbill);
        }
    }

    public static void uploadAttachmentPanel(DynamicObject from, DynamicObject to) {
        DynamicObjectCollection yem_attachmentpanelentityColfrom = from.getDynamicObjectCollection("yem_attachmentinfo_e");
        DynamicObjectCollection yem_attachmentpanelentityColto = to.getDynamicObjectCollection("yem_attachmentinfo_e");
        yem_attachmentpanelentityColto.clear();
        List attachments = AttachmentServiceHelper.getAttachmentsByExport((String)from.getDataEntityType().getName(), (Object)from.getLong("id"));
        List toattachments = AttachmentServiceHelper.getAttachmentsByExport((String)to.getDynamicObjectType().getName(), (Object)to.getLong("id"));
        List toname = toattachments.stream().map(x -> (String)x.get("name")).collect(Collectors.toList());
        for (Map map : attachments) {
            String uid = (String)map.get("uid");
            String fileName = (String)map.get("name");
            if (fileName == null || toname.contains(fileName)) continue;
            DynamicObject newAtt = BusinessDataServiceHelper.newDynamicObject((String)"bos_attachment");
            Long id = ORM.create().genLongId("bos_attachment");
            newAtt.set("id", (Object)id);
            newAtt.set("fnumber", (Object)("upload_" + id));
            newAtt.set("FBillType", (Object)to.getDataEntityType().getName());
            newAtt.set("FInterID", (Object)to.getString("id"));
            newAtt.set("FModifyTime", map.get("lastModified"));
            newAtt.set("fcreatetime", map.get("createdate"));
            newAtt.set("FaliasFileName", (Object)fileName);
            newAtt.set("FAttachmentName", (Object)fileName);
            newAtt.set("FFileId", map.get("url"));
            newAtt.set("FExtName", map.get("type"));
            newAtt.set("FATTACHMENTSIZE", map.get("size"));
            newAtt.set("fattachmentpanel", map.get("fattachmentpanel"));
            newAtt.set("fdescription", map.get("description"));
            DynamicObject attach = yem_attachmentpanelentityColto.addNew();
            DynamicObject yem_attacheduser = null;
            for (DynamicObject yem_attachmentpanelentityfrom : yem_attachmentpanelentityColfrom) {
                String yem_attachedid = yem_attachmentpanelentityfrom.getString("yem_attachedid");
                if (StringUtils.isEmpty((String)yem_attachedid) || !yem_attachedid.equals(uid) && !fileName.equals(yem_attachmentpanelentityfrom.getString("yem_attachmentname"))) continue;
                yem_attacheduser = yem_attachmentpanelentityfrom.getDynamicObject("yem_attacheduser");
                attach.set("yem_attachedid", newAtt.get("fnumber"));
                attach.set("yem_atturl", (Object)yem_attachmentpanelentityfrom.getString("yem_atturl"));
                attach.set("yem_attachmentname", (Object)yem_attachmentpanelentityfrom.getLocaleString("yem_attachmentname"));
                attach.set("yem_attachmenttype", (Object)yem_attachmentpanelentityfrom.getDynamicObject("yem_attachmenttype"));
                attach.set("yem_uploaddate", (Object)yem_attachmentpanelentityfrom.getDate("yem_uploaddate"));
                attach.set("yem_attacheduser", (Object)yem_attachmentpanelentityfrom.getDynamicObject("yem_attacheduser"));
                attach.set("yem_panel", (Object)yem_attachmentpanelentityfrom.getString("yem_panel"));
                attach.set("yem_docid", (Object)yem_attachmentpanelentityfrom.getString("yem_docid"));
                attach.set("yem_docname", (Object)yem_attachmentpanelentityfrom.getString("yem_docname"));
                attach.set("yem_billno", (Object)yem_attachmentpanelentityfrom.getString("yem_billno"));
                attach.set("yem_billid", (Object)yem_attachmentpanelentityfrom.getString("yem_billid"));
            }
            String creatorName = map.get("creator") != null ? map.get("creator").toString() : (yem_attacheduser != null ? yem_attacheduser.getString("name") : "");
            DynamicObject User = YEM.getCurrentUser((String)creatorName);
            if (User != null) {
                newAtt.set("FCREATEMEN", (Object)User.getString("id"));
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newAtt});
            HashMap<String, String> map1 = new HashMap<String, String>();
            map1.put("yem_attachmentinfo_e", "");
            DynamicObjUtils.resetSeq((DynamicObject)to, map1);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{to});
        }
    }
}

